/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ivs.remote.IvsAlgorithmRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsAlgorithmService;
import com.zkteco.zkbiosecurity.ivs.service.IvsChannelService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsAlgorithmInfoItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsAlgorithmController
extends BaseController
implements IvsAlgorithmRemote {
    @Autowired
    private IvsAlgorithmService ivsAlgorithmService;
    @Autowired
    private IvsChannelService ivsChannelService;

    @RequiresPermissions(value={"ivs:ext:algorithm"})
    public ModelAndView index() {
        return new ModelAndView("ivs/algorithm/ivsAlgorithm");
    }

    @RequiresPermissions(value={"ivs:algorithm:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsChannelService.getItemById(id));
        }
        return new ModelAndView("ivs/algorithm/editVidAlgorithm");
    }

    @RequiresPermissions(value={"ivs:algorithm:refresh"})
    public DxGrid list(IvsAlgorithmInfoItem condition) {
        Pager pager = this.ivsAlgorithmService.getChannelList(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ivs:algorithm:synchronize"})
    public ZKResultMsg synchronize(String ids) {
        ZKResultMsg zkResultMsg = this.ivsAlgorithmService.synchronizeAlgorithm(Arrays.asList(ids.split(",")));
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg save(IvsAlgorithmInfoItem condition) {
        return this.ivsAlgorithmService.changeAlgorithm(condition);
    }
}

