/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsAlarmLogRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsAlarmLogService;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.utils.ApiIvsCheckUtil;
import com.zkteco.zkbiosecurity.ivs.vo.IvsAlarmLogItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsEdgeDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsAlarmLogController
extends ExportController
implements IvsAlarmLogRemote {
    @Autowired
    private IvsAlarmLogService ivsAlarmLogService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @RequiresPermissions(value={"ivs:alarmLog"})
    public ModelAndView index() {
        return new ModelAndView("ivs/alarmLog/ivsAlarmLog");
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String[] value = id.split("#");
            this.request.setAttribute("photoPath", (Object)this.ivsAlarmLogService.getBase64ByFileId(value[0], value[1], value[2]));
        }
        return new ModelAndView("ivs/alarmLog/viewPhotoPath");
    }

    @RequiresPermissions(value={"ivs:ivsAlarmLog:refresh"})
    public DxGrid list(IvsAlarmLogItem condition) {
        Pager pager = this.ivsAlarmLogService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        return data;
    }

    public TreeItem tree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        String alarmTypeList = "ALARM_OBJECT_WANDER,Fast_Move,ALARM_EXIT,ALARM_ENTER,ALARM_TRIP_LINE,ALARM_INTRUSION,ALARM_TYPE_MOVE_DECTION";
        String[] alarmTypeListArray = StringUtils.split((String)alarmTypeList, (String)",");
        String alarmTextList = "ivs_alarmObject,ivs_alarmFastMove,ivs_alarmExit,ivs_alarmEnter,ivs_alarmTrip,ivs_alarmIntrusion,ivs_alarmMoveDection";
        String[] alarmTextListArray = StringUtils.split((String)alarmTextList, (String)",");
        for (int i = 0; i < alarmTypeListArray.length; ++i) {
            TreeItem item = new TreeItem();
            item.setId(alarmTypeListArray[i]);
            item.setText(I18nUtil.i18nCode((String)alarmTextListArray[i], (Object[])new Object[0]));
            item.setParent(new TreeItem("0"));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"ivs:ivsAlarmLog:export"})
    public void export(IvsAlarmLogItem condition, HttpServletRequest request, HttpServletResponse response) {
        IvsAlarmLogItem ivsAlarmLogItem = new IvsAlarmLogItem();
        IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemById(condition.getVidExtDeviceId());
        String name = "";
        if (Objects.nonNull(ivsEdgeDeviceItem)) {
            name = ivsEdgeDeviceItem.getName();
        }
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String timeStr = sdf.format(date);
        String typeStr = "2".equals(condition.getType()) ? "-behaviorAnalysis-" : "-faceControl-";
        String text = name + typeStr + timeStr;
        this.setConditionValue((BaseItem)ivsAlarmLogItem);
        condition.setAlarmTypeList(ivsAlarmLogItem.getAlarmTypeList());
        int maxCount = Math.min(Integer.parseInt(request.getParameter("recordcount")), 30000);
        List ivsAlarmLogItemList = this.ivsAlarmLogService.getItemData(condition, 0, maxCount);
        if (CollectionUtils.isEmpty((Collection)ivsAlarmLogItemList)) {
            return;
        }
        ServletOutputStream outputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            outputStream = response.getOutputStream();
            response.setContentType("application/force-download");
            response.addHeader("Content-Disposition", text + ".zipp");
            zipOutputStream = new ZipOutputStream((OutputStream)outputStream);
            for (IvsAlarmLogItem item : ivsAlarmLogItemList) {
                String imgStr = item.getSnapshot();
                if (StringUtils.isEmpty((CharSequence)imgStr)) continue;
                zipOutputStream.putNextEntry(new ZipEntry("picture/" + item.getId() + ".jpg"));
                zipOutputStream.write(Base64.getDecoder().decode(imgStr));
            }
            Map<String, String> map = ApiIvsCheckUtil.getColumnAndI18nByClass(IvsAlarmLogItem.class);
            map.remove("id");
            map.remove("snapshot");
            String jsonColumn = JSONObject.toJSONString(map);
            zipOutputStream.putNextEntry(new ZipEntry("alarmStatistic.xls"));
            if (!CollectionUtils.isEmpty((Collection)ivsAlarmLogItemList)) {
                ExcelUtil.excelExport((List)ivsAlarmLogItemList, IvsAlarmLogItem.class, (String)jsonColumn, (String)"alarmStatistic", (OutputStream)zipOutputStream, (String)"xls", (Map)null);
            }
        }
        catch (Exception e) {
            this.log.error("alarm log download error", (Throwable)e);
        }
        finally {
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
            this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.flush();
                    zipOutputStream.close();
                }
                catch (IOException e) {
                    this.log.error("alarm log zipOutputStream close error", (Throwable)e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    this.log.error("alarm log outputStream close error", (Throwable)e);
                }
            }
        }
    }
}

