/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsAlarmLatestRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsAnalyseFaceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.service.IvsVidAlarmLinkageService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsAlarmLatestItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsAnalyseFaceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsAlarmLatestController
extends ExportController
implements IvsAlarmLatestRemote {
    @Autowired
    private IvsAnalyseFaceService ivsAnalyseFaceService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;
    @Autowired
    private IvsVidAlarmLinkageService ivsVidAlarmLinkageService;
    @Value(value="${system.productCode}")
    private String productCode;

    @RequiresPermissions(value={"ivs:intelApplication:alarmLatest"})
    public ModelAndView index() {
        this.request.setAttribute("isClient", (Object)this.request.getParameter("isClient"));
        return new ModelAndView("ivs/alarm/ivsZKNVRAlarmLatest");
    }

    public ModelAndView openAlarmLatest() {
        this.request.setAttribute("isClient", (Object)this.request.getParameter("isClient"));
        return new ModelAndView("ivs/alarm/ivsAlarmLatest");
    }

    @RequiresPermissions(value={"ivs:alarmLatest:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsAnalyseFaceService.getItemById(id));
        }
        return new ModelAndView("ivs/alarm/editHwAnalyseFace");
    }

    @RequiresPermissions(value={"ivs:alarmLatest:edit"})
    public ZKResultMsg save(IvsAnalyseFaceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.ivsAnalyseFaceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(IvsAnalyseFaceItem condition) {
        Pager pager = this.ivsAnalyseFaceService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        return data;
    }

    @RequiresPermissions(value={"ivs:alarmLatest:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.ivsAnalyseFaceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public TreeItem getAlarmTypeTree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        String alarmTypeList = "";
        String alarmTextList = "";
        if ("ZKBioAccess".equals(this.productCode)) {
            alarmTypeList = "ALARM_GENERAL_BUSINESS";
            alarmTextList = "ivs_alarm_general_business";
        } else {
            alarmTypeList = "ALARM_FACE,ALARM_VEHICLE,ALARM_BEHAVIOR,ALARM_GENERAL_BUSINESS,ALARM_SITUATION_ANALYSIS,ALARM_THIRD_ALGORITHM";
            alarmTextList = "ivs_alarm_face,ivs_alarm_vehicle,ivs_alarm_behavior,ivs_alarm_general_business,ivs_alarm_situation_analysis,ivs_alarm_third_algorithm";
        }
        String[] alarmTypeListArray = StringUtils.split((String)alarmTypeList, (String)",");
        String[] alarmTextListArray = StringUtils.split((String)alarmTextList, (String)",");
        for (int i = 0; i < alarmTypeListArray.length; ++i) {
            TreeItem item = new TreeItem();
            item.setId(alarmTypeListArray[i]);
            item.setText(I18nUtil.i18nCode((String)alarmTextListArray[i], (Object[])new Object[0]));
            item.setParent(new TreeItem("0"));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public TreeItem getEventLeaveTree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        String eventLeaveList = "emergency,important,normal,notice";
        String[] eventLeaveListArray = StringUtils.split((String)eventLeaveList, (String)",");
        String eventTextList = "ivs_urgent,ivs_important,ivs_general,ivs_prompt";
        String[] eventTextListArray = StringUtils.split((String)eventTextList, (String)",");
        for (int i = 0; i < eventLeaveListArray.length; ++i) {
            TreeItem item = new TreeItem();
            item.setId(eventLeaveListArray[i]);
            item.setText(I18nUtil.i18nCode((String)eventTextListArray[i], (Object[])new Object[0]));
            item.setParent(new TreeItem("0"));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public TreeItem getTypeTree() {
        ArrayList items = new ArrayList();
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public TreeItem getParentDeviceTree() {
        return this.ivsEdgeDeviceService.getParentDeviceTree(this.request.getSession().getId());
    }

    public ZKResultMsg getAlarmLinkageImage(IvsAlarmLatestItem ivsAlarmLatestItem) {
        return this.ivsVidAlarmLinkageService.getAlarmLinkageImage(ivsAlarmLatestItem);
    }

    @MessageMapping(value={"/hwAlarmsMonitor/getEventData"})
    @SendTo(value={"/topic/hwAlarmsMonitor/getEventData"})
    public Object getEventData(String params) {
        return null;
    }
}

