/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.ivs.controller.IvsExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsAlarmHistoryRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsAlarmHistoryService;
import com.zkteco.zkbiosecurity.ivs.service.IvsEdgeDeviceService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsAlarmHistoryItem;
import com.zkteco.zkbiosecurity.ivs.vo.IvsEdgeDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsAlarmHistoryController
extends IvsExportController
implements IvsAlarmHistoryRemote {
    @Autowired
    private IvsAlarmHistoryService ivsAlarmHistoryService;
    @Autowired
    private IvsEdgeDeviceService ivsEdgeDeviceService;

    @RequiresPermissions(value={"ivs:alarmHistory"})
    public ModelAndView index() {
        this.request.setAttribute("isClient", (Object)this.request.getParameter("isClient"));
        return new ModelAndView("ivs/alarmHistory/ivsAlarmHistory");
    }

    public DxGrid list(IvsAlarmHistoryItem condition) {
        Pager pager = this.ivsAlarmHistoryService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
        return data;
    }

    public ZKResultMsg tree(String type, String parentDeviceId) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemById(parentDeviceId);
        String alarmTypeList = "";
        String alarmTextList = "";
        switch (type) {
            case "-1": {
                if (ivsEdgeDeviceItem == null || !"7".equals(ivsEdgeDeviceItem.getType()) && !"13".equals(ivsEdgeDeviceItem.getType())) break;
                alarmTypeList = "ALARM_TYPE_ALL";
                alarmTextList = "common_all";
                break;
            }
            case "0": {
                if (ivsEdgeDeviceItem != null && "0".equals(ivsEdgeDeviceItem.getType())) {
                    alarmTypeList = "ALARM_FACE_RECOGNITION,ALARM_FACE_MASK,ALARM_FACE_DETECTION";
                    alarmTextList = "ivs_iClient_face_recogAlarm,ivs_mask_recognition_alarm,ivs_iClient_face_detection_alarm";
                    break;
                }
                alarmTypeList = "ALARM_FACE_RECOGNITION,ALARM_FACE_MASK,ALARM_FACE_DETECTION,ALARM_PERSON,REPEAT_VISITOR";
                alarmTextList = "ivs_iClient_face_recogAlarm,ivs_mask_recognition_alarm,ivs_iClient_face_detection_alarm,ivs_alarm_code_44,ivs_alarm_code_16";
                break;
            }
            case "1": {
                if (ivsEdgeDeviceItem != null && "0".equals(ivsEdgeDeviceItem.getType())) {
                    alarmTypeList = "ALARM_VEHICLE_RECOGNITION,ALARM_VE_ILLEGAL_PARKING";
                    alarmTextList = "ivs_alarm_code_26,ivs_alarm_code_20";
                    break;
                }
                alarmTypeList = "ALARM_VE_ILLEGAL_PARKING,ALARM_VEHICLE_DETECTION,ALARM_NON_VEHICLE_DETECTION";
                alarmTextList = "ivs_alarm_code_20,ivs_alarm_code_46,ivs_alarm_code_45";
                break;
            }
            case "2": {
                if (ivsEdgeDeviceItem != null && "0".equals(ivsEdgeDeviceItem.getType())) {
                    alarmTypeList = "ALARM_TRIP_LINE,ALARM_INTRUSION,ALARM_OBJECT_WANDER,ALARM_ENTER,ALARM_EXIT,ALARM_FASTMOVE,ALARM_FIRE_DETECT,ALARM_OBJECT_ABANDONED,ALARM_OBJECT_REMOVAL,ALARM_ELE_BICYCLE";
                    alarmTextList = "ivs_alarm_code_32,ivs_alarm_code_30,ivs_alarm_code_27,ivs_alarm_code_29,ivs_alarm_code_28,ivs_alarm_code_38,ivs_alarm_code_40,ivs_alarm_code_17,ivs_alarm_code_18,ivs_alarm_code_19";
                    break;
                }
                alarmTypeList = "ALARM_TRIP_LINE,ALARM_INTRUSION,ALARM_OBJECT_WANDER,ALARM_ENTER,ALARM_EXIT,ALARM_FASTMOVE,ALARM_OBJECT_ABANDONED,ALARM_OBJECT_REMOVAL,ALARM_ELE_BICYCLE";
                alarmTextList = "ivs_alarm_code_32,ivs_alarm_code_30,ivs_alarm_code_27,ivs_alarm_code_29,ivs_alarm_code_28,ivs_alarm_code_38,ivs_alarm_code_17,ivs_alarm_code_18,ivs_alarm_code_19";
                break;
            }
            case "3": {
                if (ivsEdgeDeviceItem != null && "0".equals(ivsEdgeDeviceItem.getType())) {
                    alarmTypeList = "ALARM_NO_SIGNAL,ALARM_SHIELD,ALARM_TYPE_MOVE_DECTION,ALARM_SCENECHANGE,ALARM_OUTOFFOCUS_DETECT,ALARM_AUDIO_DOWN,ALARM_AUDIO_UP,ALARM_FACE_RECOGNITION_WARNING,ALARM_BRIGHT_DIAGNOSIS,ALARM_COLORCAST_DIAGNOSIS,ALARM_STRIPENOISE_DIAGNOSIS,ALARM_SNOW_NOISE_DIAGNOSIS,ALARM_FROZEN_DIAGNOSIS,ALARM_SHAKE_DIAGNOSIS";
                    alarmTextList = "ivs_alarm_code_43,ivs_alarm_code_1,ivs_alarm_code_33,ivs_alarm_code_57,ivs_alarm_code_58,ivs_alarm_code_42,ivs_alarm_code_41,ivs_alarm_faceReco,ivs_alarm_code_63,ivs_alarm_code_64,ivs_alarm_code_62,ivs_alarm_code_61,ivs_alarm_code_60,ivs_alarm_code_59";
                    break;
                }
                if (ivsEdgeDeviceItem != null && "2".equals(ivsEdgeDeviceItem.getType())) {
                    alarmTypeList = "ALARM_SHIELD,ALARM_TYPE_MOVE_DECTION,ALARM_Sound";
                    alarmTextList = "ivs_alarm_code_1,ivs_alarm_code_33,ivs_alarm_code_2";
                    break;
                }
                if (ivsEdgeDeviceItem == null || !"7".equals(ivsEdgeDeviceItem.getType()) && !"13".equals(ivsEdgeDeviceItem.getType())) break;
                alarmTypeList = "ALARM_TYPE_MOVE_DECTION_START,ALARM_TYPE_MOVE_DECTION_END,ALARM_SHIELD_START,ALARM_SHIELD_END,ALARM_NO_SIGNAL_START,ALARM_NO_SIGNAL_END,ALARM_OBJECT_DETECTION_START,ALARM_OBJECT_DETECTION_END,ALARM_MOTION_DETECTION_PERSON_START,ALARM_MOTION_DETECTION_PERSON_END,ALARM_MOTION_DETECTION_CAR_START,ALARM_MOTION_DETECTION_CAR_END,ALARM_TARGET_COUNT_PERSON_START,ALARM_TARGET_COUNT_PERSON_END,ALARM_TARGET_COUNT_CAR_START,ALARM_TARGET_COUNT_CAR_END,ALARM_TRIPWIRE_DETECTION_PERSON_START,ALARM_TRIPWIRE_DETECTION_PERSON_END,ALARM_TRIPWIRE_DETECTION_CAR_START,ALARM_TRIPWIRE_DETECTION_CAR_END,ALARM_AREA_DETECTION_PERSON_START,ALARM_AREA_DETECTION_PERSON_END,ALARM_AREA_DETECTION_CAR_START,ALARM_AREA_DETECTION_CAR_END";
                alarmTextList = "ivs_zknvr_alarm_7,ivs_zknvr_alarm_8,ivs_zknvr_alarm_13,ivs_zknvr_alarm_14,ivs_zknvr_alarm_15,ivs_zknvr_alarm_16,ivs_zknvr_alarm_23,ivs_zknvr_alarm_24,ivs_zknvr_alarm_113,ivs_zknvr_alarm_114,ivs_zknvr_alarm_115,ivs_zknvr_alarm_116,ivs_zknvr_alarm_101,ivs_zknvr_alarm_102,ivs_zknvr_alarm_103,ivs_zknvr_alarm_104,ivs_zknvr_alarm_105,ivs_zknvr_alarm_106,ivs_zknvr_alarm_107,ivs_zknvr_alarm_108,ivs_zknvr_alarm_109,ivs_zknvr_alarm_110,ivs_zknvr_alarm_111,ivs_zknvr_alarm_112";
                break;
            }
            case "5": {
                if (ivsEdgeDeviceItem != null && "0".equals(ivsEdgeDeviceItem.getType())) {
                    alarmTypeList = "ALARM_HUMAN_COUNT,ALARM_QUEUE_DETECT,ALARM_CROWD_DENSITY_DETECT,ALARM_CROWD_ANALYSIS,ALARM_PERSON_LEAVE_DETECT";
                    alarmTextList = "ivs_alarm_code_21,ivs_alarm_code_22,ivs_alarm_code_23,ivs_alarm_code_25,ivs_alarm_code_47";
                    break;
                }
                alarmTypeList = "ALARM_HUMAN_COUNT,ALARM_QUEUE_DETECT,ALARM_CROWD_DENSITY_DETECT,ALARM_PERSON_LEAVE_DETECT";
                alarmTextList = "ivs_alarm_code_21,ivs_alarm_code_22,ivs_alarm_code_23,ivs_alarm_code_47";
                break;
            }
            case "6": {
                alarmTypeList = "ALARM_DISK_FULL_START,ALARM_DISK_FULL_END,ALARM_NO_DISK_START,ALARM_NO_DISK_END,ALARM_DISK_LOST_CONNECTION_START,ALARM_DISK_LOST_CONNECTION_END,ALARM_DISK_SMART_ERROR_START,ALARM_DISK_SMART_ERROR_END,ALARM_NETWORK_INTERRUPTION_START,ALARM_NETWORK_INTERRUPTION_END,ALARM_IP_ADDRESS_CONFLICT_START,ALARM_IP_ADDRESS_CONFLICT_END";
                alarmTextList = "ivs_zknvr_alarm_47,ivs_zknvr_alarm_48,ivs_zknvr_alarm_43,ivs_zknvr_alarm_44,ivs_zknvr_alarm_71,ivs_zknvr_alarm_72,ivs_zknvr_alarm_41,ivs_zknvr_alarm_42,ivs_zknvr_alarm_49,ivs_zknvr_alarm_50,ivs_zknvr_alarm_51,ivs_zknvr_alarm_52";
                break;
            }
        }
        String[] alarmTypeListArray = StringUtils.split((String)alarmTypeList, (String)",");
        String[] alarmTextListArray = StringUtils.split((String)alarmTextList, (String)",");
        for (int i = 0; i < alarmTypeListArray.length; ++i) {
            SelectItem selectItem = new SelectItem((Object)I18nUtil.i18nCode((String)alarmTextListArray[i], (Object[])new Object[0]), alarmTypeListArray[i]);
            items.add(selectItem);
        }
        return new ZKResultMsg(items);
    }

    public ZKResultMsg alarmTypeTree(String type, String parentDeviceId) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        IvsEdgeDeviceItem ivsEdgeDeviceItem = this.ivsEdgeDeviceService.getItemById(parentDeviceId);
        if (Objects.nonNull(ivsEdgeDeviceItem)) {
            if ("7".equals(ivsEdgeDeviceItem.getType()) || "13".equals(ivsEdgeDeviceItem.getType())) {
                SelectItem selectItem = new SelectItem((Object)I18nUtil.i18nCode((String)"common_all", (Object[])new Object[0]), "-1");
                items.add(selectItem);
                selectItem = new SelectItem((Object)I18nUtil.i18nCode((String)"ivs_general_alarm", (Object[])new Object[0]), "3");
                items.add(selectItem);
                selectItem = new SelectItem((Object)I18nUtil.i18nCode((String)"ivs_operation_alarm", (Object[])new Object[0]), "6");
                items.add(selectItem);
            } else {
                SelectItem selectItem = new SelectItem((Object)I18nUtil.i18nCode((String)"ivs_face_control", (Object[])new Object[0]), "0");
                items.add(selectItem);
                selectItem = new SelectItem((Object)I18nUtil.i18nCode((String)"ivs_vehicle_control", (Object[])new Object[0]), "1");
                items.add(selectItem);
                selectItem = new SelectItem((Object)I18nUtil.i18nCode((String)"ivs_behavior_analysis", (Object[])new Object[0]), "2");
                items.add(selectItem);
                selectItem = new SelectItem((Object)I18nUtil.i18nCode((String)"ivs_general_alarm", (Object[])new Object[0]), "3");
                items.add(selectItem);
                selectItem = new SelectItem((Object)I18nUtil.i18nCode((String)"ivs_crowd_situation", (Object[])new Object[0]), "5");
                items.add(selectItem);
                selectItem = new SelectItem((Object)I18nUtil.i18nCode((String)"ivs_third_algorithm", (Object[])new Object[0]), "4");
                items.add(selectItem);
            }
        }
        return new ZKResultMsg(items);
    }

    public ZKResultMsg getVidExtDeviceSelectData() {
        String sessionId = WebContextUtil.getCurrentSessionId();
        return new ZKResultMsg((Object)this.ivsAlarmHistoryService.getVidExtDeviceSelectData(sessionId));
    }

    public ZKResultMsg getBase64ByFileId(String fileId, String vidExtDeviceId, String type) {
        return new ZKResultMsg((Object)this.ivsEdgeDeviceService.isEnablePictureBlur(this.ivsAlarmHistoryService.getBase64ByFileId(fileId, vidExtDeviceId, type, null)));
    }

    @RequiresPermissions(value={"ivs:alarmHistory:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        IvsAlarmHistoryItem ivsAlarmHistoryItem = new IvsAlarmHistoryItem();
        this.setConditionValue((BaseItem)ivsAlarmHistoryItem);
        List itemList = this.ivsAlarmHistoryService.getItemData(ivsAlarmHistoryItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, IvsAlarmHistoryItem.class);
    }
}

