/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ivs.remote.IvsAlarmFaceSpotRemote;
import com.zkteco.zkbiosecurity.ivs.service.IvsAnalyseFaceService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsAlarmFaceSpotItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IvsAlarmFaceSpotController
extends ExportController
implements IvsAlarmFaceSpotRemote {
    @Autowired(required=false)
    private IvsAnalyseFaceService ivsAnalyseFaceService;

    @RequiresPermissions(value={"ivs:alarmLatest"})
    public ModelAndView index() {
        return new ModelAndView("ivs/alarm/ivsAlarmFaceSpot");
    }

    @RequiresPermissions(value={"ivs:alarmLatest:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ivsAnalyseFaceService.getItemById(id));
        }
        return new ModelAndView("ivs/alarm/editHwAnalyseFace");
    }

    @RequiresPermissions(value={"ivs:alarmLatest:edit"})
    public ZKResultMsg save(IvsAlarmFaceSpotItem item) {
        ZKResultMsg res = new ZKResultMsg();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(IvsAlarmFaceSpotItem condition) {
        Pager pager = new Pager();
        ArrayList itemList = new ArrayList();
        pager.setTotal(itemList.size());
        pager.setData(itemList);
        DxGrid data = GridUtil.convert((Pager)pager, condition.getClass());
        return data;
    }

    @RequiresPermissions(value={"ivs:alarmLatest:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.ivsAnalyseFaceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }
}

