/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ivs.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.ivs.service.IvsClientRequestLogService;
import com.zkteco.zkbiosecurity.ivs.vo.IvsClientRequestLogItem;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class IvsRequestLogAspect {
    private static final Logger log = LoggerFactory.getLogger(IvsRequestLogAspect.class);
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private IvsClientRequestLogService ivsClientRequestLogService;

    @Around(value="execution( * com.zkteco.zkbiosecurity.ivs.controller.IvsVideoPluginController.*(..))")
    public Object requestPluginLog(ProceedingJoinPoint joinPoint) {
        IvsClientRequestLogItem item = new IvsClientRequestLogItem();
        item.setRequestTime(new Date());
        item.setPath(this.request.getRequestURL().toString());
        Object[] ars = joinPoint.getArgs();
        item.setContent(JSONObject.toJSONString((Object)ars));
        long consuming = 0L;
        Object result = new Object();
        try {
            if (WebContextUtil.getCurrentRequest() != null) {
                HttpServletRequest httpServletRequest = WebContextUtil.getCurrentRequest();
                String ip = httpServletRequest.getHeader("X-Forwarded-For");
                if (StringUtils.isBlank((CharSequence)ip)) {
                    ip = httpServletRequest.getRemoteAddr();
                }
                item.setRequestIp(ip);
            }
            long startTime = System.currentTimeMillis();
            result = joinPoint.proceed(ars);
            JSONObject jsonObject = JSON.parseObject((String)JSONObject.toJSONString((Object)result));
            item.setReceive(JSONObject.toJSONString((Object)result));
            if ("true".equals(jsonObject.getString("success"))) {
                item.setResult("ok");
            } else {
                item.setResult("fail");
            }
            consuming = System.currentTimeMillis() - startTime;
        }
        catch (Throwable throwable) {
            log.error("---request aop log error---", throwable);
            item.setResult("fail");
        }
        item.setTime(Long.valueOf(consuming));
        if (this.ivsClientRequestLogService.isEnableLog()) {
            this.ivsClientRequestLogService.saveItem(item);
        }
        return result;
    }
}

