/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.led.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.led.remote.LedExtSendDataRemote;
import com.zkteco.zkbiosecurity.led.service.LedExtSendDataService;
import com.zkteco.zkbiosecurity.led.vo.LedExtSendDataItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class LedExtSendDataController
extends BaseController
implements LedExtSendDataRemote {
    @Autowired
    private LedExtSendDataService ledExtSendDataService;

    @RequiresPermissions(value={"led:extSendData"})
    public ModelAndView index() {
        return new ModelAndView("led/extSendData/ledExtSendData");
    }

    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.ledExtSendDataService.getItemById(id));
        }
        return new ModelAndView("led/extSendData/editLedExtSendData");
    }

    @LogRequest(module="base_module", object="docking_leftMenu_extSendData", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(LedExtSendDataItem item) {
        this.ledExtSendDataService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid list(LedExtSendDataItem condition) {
        Pager pager = this.ledExtSendDataService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="base_module", object="docking_leftMenu_extSendData", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.ledExtSendDataService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAccZoneList() {
        String zoneExpOutside = this.request.getParameter("zoneExpOutside");
        return new ZKResultMsg((Object)this.ledExtSendDataService.getAccZoneList(zoneExpOutside));
    }

    public void getLedBlockTree() {
        try {
            String blockKeys = this.request.getParameter("blockKeys");
            this.response.setCharacterEncoding("UTF-8");
            this.response.getWriter().write(this.ledExtSendDataService.getLedBlockTree(blockKeys));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String validName(@RequestParam(value="name") String name) {
        LedExtSendDataItem item = this.ledExtSendDataService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public TreeItem getDeptTree() {
        return this.ledExtSendDataService.getDeptTree(WebContextUtil.getCurrentSessionId());
    }

    public ZKResultMsg getParkChannelList() {
        return new ZKResultMsg((Object)this.ledExtSendDataService.getParkChannelList());
    }
}

