/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.init;

import com.zkteco.zkbiosecurity.auth.provider.AuthInitDataProvider;
import com.zkteco.zkbiosecurity.auth.provider.AuthPermissionProvider;
import com.zkteco.zkbiosecurity.auth.vo.AuthRoleItem;
import com.zkteco.zkbiosecurity.base.config.PermissionConfig;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ClassPathResource;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
@Order(value=999999)
public class SystemRolePermissionInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(SystemRolePermissionInit.class);
    @Autowired
    private AuthInitDataProvider authInitDataProvider;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private AuthPermissionProvider authPermissionProvider;
    @Value(value="${system.isCloud:false}")
    private Boolean isCloud;
    @Value(value="${system.productCode:ZKBioSecurity}")
    private String productCode;
    @Value(value="${system.language:zh_CN}")
    private String language;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("SystemRolePermissionInit");
        if (!alreadyInit) {
            this.initAuthRole();
            this.baseSysParamService.setAlreadyInitModule("SystemRolePermissionInit");
        }
        try {
            this.initProductPermission();
        }
        catch (Exception e) {
            log.error("InitProductPermission error ", (Throwable)e);
        }
    }

    private void initAuthRole() {
        if (!this.isCloud.booleanValue()) {
            this.authInitDataProvider.initRoleData(new AuthRoleItem(I18nUtil.i18nCode((String)"auth_role_initAdminRoleName", (Object[])new Object[0]), "administrator", "administrator"));
            this.authInitDataProvider.initRoleData(new AuthRoleItem(I18nUtil.i18nCode((String)"auth_role_entryClerk", (Object[])new Object[0]), "entry", "entry"));
            this.authInitDataProvider.initRoleData(new AuthRoleItem(I18nUtil.i18nCode((String)"auth_role_monitorClerk", (Object[])new Object[0]), "monitor", "monitor"));
            this.authInitDataProvider.initRoleData(new AuthRoleItem(I18nUtil.i18nCode((String)"pers_person_employee", (Object[])new Object[0]), "employee", "employee"));
        }
    }

    private void initProductPermission() {
        Map<String, Set<String>> productPermissionMap = this.getProductPermissionMap();
        if (productPermissionMap != null) {
            Set<String> enablesSet;
            Set<String> disablesSet = productPermissionMap.get("disables");
            if (disablesSet != null && disablesSet.size() > 0) {
                this.authPermissionProvider.updateAvailable(disablesSet, "false");
                log.info("InitProductPermission disable permissions = {}", (Object)StringUtils.join(disablesSet, (String)","));
                PermissionConfig.disable(disablesSet);
            }
            if ((enablesSet = productPermissionMap.get("enables")) != null && enablesSet.size() > 0) {
                this.authPermissionProvider.updateAvailable(enablesSet, "true");
                log.info("InitProductPermission enable permissions = {}", (Object)StringUtils.join(enablesSet, (String)","));
            }
        }
    }

    private Map<String, Set<String>> getProductPermissionMap() {
        HashMap<String, Set<String>> permissionMap = new HashMap<String, Set<String>>();
        HashSet<String> disablesSet = new HashSet<String>();
        HashSet<String> enablesSet = new HashSet<String>();
        try {
            List authPermissionItemList = this.authPermissionProvider.getSystemMenus();
            if (authPermissionItemList == null || authPermissionItemList.size() == 0) {
                return permissionMap;
            }
            List modules = authPermissionItemList.stream().map(authPermission -> authPermission.getCode().toLowerCase()).collect(Collectors.toList());
            for (String module : modules) {
                Element enables;
                ClassPathResource resource = new ClassPathResource(String.valueOf(module) + "-permission.xml");
                if (resource == null || !resource.exists()) continue;
                BufferedReader br = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));
                StringBuffer buffer = new StringBuffer();
                String line = "";
                while ((line = br.readLine()) != null) {
                    buffer.append(line);
                }
                br.close();
                if (StringUtils.isBlank((CharSequence)buffer)) {
                    log.info(String.valueOf(module) + "-permission.xml" + " is empty");
                    continue;
                }
                Document doc = DocumentHelper.parseText((String)buffer.toString());
                if (doc == null) {
                    log.info(String.valueOf(module) + "-permission.xml" + " arseText doc is null");
                    continue;
                }
                Element root = doc.getRootElement();
                Element productElement = root.element(this.productCode);
                if (productElement == null) {
                    log.info(String.valueOf(module) + "-permission.xml" + " {} Element is empty", (Object)this.productCode);
                    continue;
                }
                Element disables = productElement.element("disables");
                if (disables != null && disables.elements() != null) {
                    for (Element element : disables.elements()) {
                        String condition = element.attributeValue("condition");
                        if (StringUtils.isNotBlank((CharSequence)condition) && !this.condition(condition) || StringUtils.isBlank((CharSequence)element.elementText("permission"))) continue;
                        disablesSet.add(element.elementText("permission"));
                    }
                }
                if ((enables = productElement.element("enables")) == null || enables.elements() == null) continue;
                for (Element element : enables.elements()) {
                    String condition = element.attributeValue("condition");
                    if (StringUtils.isNotBlank((CharSequence)condition) && !this.condition(condition) || StringUtils.isBlank((CharSequence)element.elementText("permission"))) continue;
                    enablesSet.add(element.elementText("permission"));
                }
            }
            permissionMap.put("disables", disablesSet);
            permissionMap.put("enables", enablesSet);
        }
        catch (Exception e) {
            log.error("InitProductPermission readResource error ", (Throwable)e);
        }
        return permissionMap;
    }

    private boolean condition(String condition) {
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            try {
                condition = condition.trim();
                if (condition.toLowerCase().equals("true") || condition.toLowerCase().equals("false")) {
                    return Boolean.valueOf(condition.trim().toLowerCase());
                }
                if (condition.startsWith("JAVA#")) {
                    String classMethodName = condition.substring(5);
                    int len = classMethodName.lastIndexOf(".");
                    String className = classMethodName.substring(0, len);
                    String methodName = classMethodName.substring(len + 1);
                    Object obj = null;
                    try {
                        obj = SpringContextUtil.getBean((String)className);
                    }
                    catch (Exception ex) {
                        obj = ClassUtils.getClass((String)className).newInstance();
                    }
                    return (Boolean)MethodUtils.invokeMethod((Object)obj, (String)methodName, null);
                }
                condition = this.parseExpression(condition, "application['", "']");
                SpelExpressionParser parser = new SpelExpressionParser();
                StandardEvaluationContext context = new StandardEvaluationContext();
                context.setVariable("language", (Object)LocaleMessageSourceUtil.language);
                return (Boolean)parser.parseExpression(condition).getValue((EvaluationContext)context, Boolean.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private String parseExpression(String exp, String bTag, String eTag) {
        if (StringUtils.isNotBlank((CharSequence)exp)) {
            int bInd = exp.indexOf(bTag);
            while (bInd != -1) {
                String prop;
                int eInd = exp.indexOf(eTag, bInd);
                if (eInd != -1 && StringUtils.isNotBlank((CharSequence)(prop = exp.substring(bInd + bTag.length(), eInd)))) {
                    String val = SpringContextUtil.getApplicationContext().getEnvironment().getProperty(prop.trim());
                    exp = String.valueOf(exp.substring(0, bInd)) + "'" + val + "'" + exp.substring(eInd + eTag.length());
                }
                bInd = exp.indexOf(bTag, eInd);
            }
        }
        return exp;
    }
}

