/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.security.xss;

import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.security.PatternConstants;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(XssHttpServletRequestWrapper.class);
    private String currentUrl;
    private Map<String, String> checkedMap = new HashMap<String, String>();
    private byte[] body;
    private Map<String, String[]> parameterMap;

    public static boolean isBase64(String value) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        if (PatternConstants.match(PatternConstants.imagePattern, value)) {
            return true;
        }
        boolean isBase64 = value.matches(base64Pattern);
        return value.length() > 1000 && isBase64;
    }

    private boolean isPlusOperate(String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            String base64Pattern;
            boolean isBase64 = (value = value.trim()).matches(base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$");
            if (isBase64) {
                return false;
            }
            if (value.startsWith("+")) {
                return false;
            }
            if (PatternConstants.match(PatternConstants.keyPattern1, value)) {
                return true;
            }
            if (value.length() < 255 && PatternConstants.match(PatternConstants.keyPattern2, value)) {
                return true;
            }
        }
        return false;
    }

    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
        if (StringUtils.isNotBlank((CharSequence)this.getHeader("X-Forwarded-For")) && ("'".equals(this.getHeader("X-Forwarded-For")) || PatternConstants.match(PatternConstants.htmlPatterns, this.getHeader("X-Forwarded-For")))) {
            throw new ZKBusinessException("common_xss_error_info");
        }
        this.currentUrl = servletRequest.getRequestURI();
        this.parameterMap = servletRequest.getParameterMap();
        this.body = XssHttpServletRequestWrapper.readAsChars(servletRequest).getBytes(Charset.forName("UTF-8"));
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (value == null) {
            return null;
        }
        return this.cleanXSS(parameter, value);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        int i = 0;
        while (i < count) {
            encodedValues[i] = this.cleanXSS(parameter, values[i]);
            ++i;
        }
        return encodedValues;
    }

    public Map<String, String[]> getParameterMap() {
        Map values = super.getParameterMap();
        if (values == null) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        for (String key : values.keySet()) {
            String encodedKey = this.cleanXSS(key, key);
            int count = ((String[])values.get(key)).length;
            String[] encodedValues = new String[count];
            int i = 0;
            while (i < count) {
                encodedValues[i] = this.cleanXSS(key, ((String[])values.get(key))[i]);
                ++i;
            }
            result.put(encodedKey, encodedValues);
        }
        return result;
    }

    private String cleanXSS(String parameter, String valueP) {
        String valueChecked;
        if (StringUtils.isBlank((CharSequence)valueP)) {
            return "";
        }
        if (this.checkedMap.containsKey(parameter) && valueP.equals(valueChecked = this.checkedMap.get(parameter))) {
            return valueP;
        }
        if (!parameter.equals(valueP)) {
            this.checkedMap.put(parameter, valueP);
        }
        if (StringUtils.isNotBlank((CharSequence)parameter) && !parameter.matches("[\\w$\\.]+") && !parameter.matches("([\\w$\\.]+(\\[\\d+\\])+[\\w$\\.]*)+")) {
            throw new ZKBusinessException("common_xss_error_info");
        }
        String value = valueP;
        if (value.contains("+") && this.isPlusOperate(value)) {
            throw new ZKBusinessException("common_xss_error_info");
        }
        try {
            if (!XssHttpServletRequestWrapper.isBase64(value)) {
                value = URLDecoder.decode(value, "utf-8");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        if (this.isVaildHtml(value)) {
            throw new ZKBusinessException("common_xss_error_info");
        }
        value = this.cleanSqlKeyWords(parameter, value);
        return valueP;
    }

    private boolean isVaildHtml(String value) {
        return PatternConstants.match(PatternConstants.htmlPatterns, value);
    }

    private String cleanSqlKeyWords(String param, String value) {
        String paramValue = value;
        if (StringUtils.isNotBlank((CharSequence)paramValue)) {
            if (paramValue.length() > 255 && XssHttpServletRequestWrapper.isBase64(paramValue)) {
                return paramValue;
            }
            if (paramValue.contains("||")) {
                throw new ZKBusinessException("common_xss_error_info");
            }
            if (PatternConstants.match(PatternConstants.keyOneSet, paramValue)) {
                throw new ZKBusinessException("common_xss_error_info");
            }
            if (PatternConstants.match(PatternConstants.keyTwoSet, paramValue)) {
                throw new ZKBusinessException("common_xss_error_info");
            }
            if (PatternConstants.match(PatternConstants.keyFunSet, paramValue)) {
                throw new ZKBusinessException("common_xss_error_info");
            }
            for (String keyword : PatternConstants.keySymSet) {
                if (!("+".equals(keyword) ? paramValue.contains("+") && this.isPlusOperate(paramValue) : ("*".equals(keyword) ? paramValue.contains("*") && !PatternConstants.match(PatternConstants.moreStar, paramValue) : paramValue.contains(keyword)))) continue;
                throw new ZKBusinessException("common_xss_error_info");
            }
        }
        return paramValue;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                return bais.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> vector = new Vector<String>(this.parameterMap.keySet());
        return vector.elements();
    }

    public static String readAsChars(HttpServletRequest request) {
        StringBuilder stringBuilder;
        String body;
        block17: {
            body = null;
            stringBuilder = new StringBuilder();
            BufferedReader bufferedReader = null;
            try {
                try {
                    ServletInputStream inputStream = request.getInputStream();
                    if (inputStream != null) {
                        request.setCharacterEncoding("UTF-8");
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, "UTF-8"));
                        char[] charBuffer = new char[128];
                        int bytesRead = -1;
                        while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                            stringBuilder.append(charBuffer, 0, bytesRead);
                        }
                    } else {
                        stringBuilder.append("");
                    }
                }
                catch (IOException ex) {
                    log.error("readAsChars", (Throwable)ex);
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        body = stringBuilder.toString();
        return body;
    }
}

