/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.security.xss;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.PatternConstants;
import com.zkteco.zkbiosecurity.security.xss.XssHttpServletRequestWrapper;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=1)
@WebFilter(urlPatterns={"/*"}, filterName="asecurityFilter")
public class XssFilter
implements Filter {
    @Value(value="${system.isRequestTargetAllow:false}")
    private boolean isAllowRequestTarget;
    @Value(value="${system.requestTargetAllowSpecial:}")
    private String requestTargetAllowSpecial;
    @Value(value="${system.sqlRegex:}")
    private String sqlRegex;
    private static Pattern keyPattern4 = null;

    public void init(FilterConfig config) throws ServletException {
    }

    public static boolean isBase64(String s) {
        String base64Pattern = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
        if (PatternConstants.match(PatternConstants.imagePattern, s)) {
            return true;
        }
        boolean isBase64 = s.matches(base64Pattern);
        return isBase64;
    }

    private boolean validDQ(String queryString) {
        try {
            String _queryString;
            if (StringUtils.isNotBlank((CharSequence)queryString) && PatternConstants.match(PatternConstants.dqPattern, _queryString = URLDecoder.decode(queryString, "utf-8")) && !PatternConstants.match(PatternConstants.bdqPattern, _queryString)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private String getRequestTargetSpecial(String allow) {
        String key = "[]{}";
        if (StringUtils.isNotBlank((CharSequence)allow)) {
            int k = 0;
            while (k < allow.length()) {
                key.replace(String.valueOf(allow.charAt(k)), "");
                ++k;
            }
        }
        return key;
    }

    private boolean validRequestTargetSpecial(String target, String allow) {
        String key = this.getRequestTargetSpecial(allow);
        if (StringUtils.isNotBlank((CharSequence)key)) {
            int k = 0;
            while (k < key.length()) {
                if (target.indexOf(key.charAt(k)) != -1) {
                    return true;
                }
                ++k;
            }
        }
        return false;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        String requestStr = "";
        String requestPath = servletRequest.getServletPath().toString();
        String queryString = servletRequest.getQueryString();
        requestStr = queryString != null ? String.valueOf(requestPath) + "?" + queryString : requestPath;
        try {
            Enumeration names;
            Matcher matcher = PatternConstants.htmlPattern.matcher(requestStr);
            boolean result1 = matcher.find();
            if (result1) {
                throw new ZKBusinessException("common_xss_error_info");
            }
            keyPattern4 = StringUtils.isNotBlank((CharSequence)this.sqlRegex) ? Pattern.compile(this.sqlRegex, 2) : null;
            if (StringUtils.isNotBlank((CharSequence)queryString)) {
                String _queryString;
                if ((PatternConstants.match(PatternConstants.sqlKeyPattern1, queryString) || this.validDQ(queryString) || PatternConstants.match(PatternConstants.sqlKeyPattern3, queryString) || keyPattern4 != null && PatternConstants.match(keyPattern4, queryString)) && (PatternConstants.match(PatternConstants.sqlKeyPattern1, _queryString = URLDecoder.decode(queryString, "utf-8")) || this.validDQ(_queryString) || PatternConstants.match(PatternConstants.sqlKeyPattern3, _queryString) || keyPattern4 != null && PatternConstants.match(keyPattern4, _queryString))) {
                    throw new ZKBusinessException("common_xss_error_info");
                }
                if (this.isAllowRequestTarget && this.validRequestTargetSpecial(_queryString = URLDecoder.decode(queryString, "utf-8"), this.requestTargetAllowSpecial)) {
                    throw new ZKBusinessException("common_xss_error_info");
                }
            }
            if ((names = servletRequest.getParameterNames()) != null) {
                while (names.hasMoreElements()) {
                    String paramName = (String)names.nextElement();
                    String paramValue = request.getParameter(paramName);
                    if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                    if (StringUtils.isNotBlank((CharSequence)requestPath) && requestPath.contains("portalSystemForgetPwd.do") && this.validDQ(paramValue)) {
                        throw new ZKBusinessException("common_xss_error_info");
                    }
                    if (paramValue.length() > 255 && XssFilter.isBase64(paramValue)) continue;
                    if (PatternConstants.match(PatternConstants.sqlKeyPattern2, paramValue) && !XssFilter.isBase64(paramValue)) {
                        throw new ZKBusinessException("common_xss_error_info");
                    }
                    if (!PatternConstants.match(PatternConstants.sqlKeyPattern3, paramValue) && (keyPattern4 == null || !PatternConstants.match(keyPattern4, paramValue))) continue;
                    if (PatternConstants.match(PatternConstants.urlPattern, paramValue)) {
                        if (!PatternConstants.match(PatternConstants.sqlKeyPattern3, paramValue = URLDecoder.decode(paramValue, "utf-8")) && (keyPattern4 == null || !PatternConstants.match(keyPattern4, paramValue))) continue;
                        throw new ZKBusinessException("common_xss_error_info");
                    }
                    throw new ZKBusinessException("common_xss_error_info");
                }
            }
            String enctype = request.getContentType();
            XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest)request);
            if (StringUtils.isNotEmpty((CharSequence)enctype) && enctype.contains("application/json")) {
                String params = new String(xssRequest.getBody(), "UTF-8");
                if (StringUtils.isBlank((CharSequence)params)) {
                    params = XssHttpServletRequestWrapper.readAsChars((HttpServletRequest)xssRequest);
                }
                if (StringUtils.isNotBlank((CharSequence)params) && JSONValidator.from((String)params).validate()) {
                    HashSet<String> jsonSet = new HashSet<String>();
                    Object object = JSON.parse((String)params);
                    XssFilter.parseJsonToSet(object, jsonSet);
                    for (String paramValue : jsonSet) {
                        if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
                        if (StringUtils.isNotBlank((CharSequence)requestPath) && requestPath.contains("portalSystemForgetPwd.do") && this.validDQ(paramValue)) {
                            throw new ZKBusinessException("common_xss_error_info");
                        }
                        if (paramValue.length() > 255 && XssFilter.isBase64(paramValue)) continue;
                        if (PatternConstants.match(PatternConstants.sqlKeyPattern2, paramValue) && !XssFilter.isBase64(paramValue)) {
                            throw new ZKBusinessException("common_xss_error_info");
                        }
                        if (PatternConstants.match(PatternConstants.sqlKeyPattern3, paramValue)) {
                            throw new ZKBusinessException("common_xss_error_info");
                        }
                        if (keyPattern4 == null || !PatternConstants.match(keyPattern4, paramValue)) continue;
                        throw new ZKBusinessException("common_xss_error_info");
                    }
                }
            }
            chain.doFilter((ServletRequest)xssRequest, response);
        }
        catch (ZKBusinessException e) {
            e.printStackTrace();
            HttpServletResponse resp = (HttpServletResponse)response;
            resp.setContentType("text/html;charset=UTF-8");
            resp.setCharacterEncoding("UTF-8");
            resp.setStatus(403);
            resp.getWriter().print(JSONObject.toJSONString((Object)ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0]), (Object[])new Object[0])));
            return;
        }
    }

    private static void parseJsonToSet(Object object, Set<String> jsonSet) {
        if (object instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)object;
            for (String entry2 : jsonObject.keySet()) {
                XssFilter.parseJsonToSet(jsonObject.get((Object)entry2), jsonSet);
            }
        } else if (object instanceof JSONArray) {
            JSONArray list = (JSONArray)object;
            int i = 0;
            while (i < list.size()) {
                XssFilter.parseJsonToSet(list.get(i), jsonSet);
                ++i;
            }
        } else {
            jsonSet.add("" + object);
        }
    }

    public void destroy() {
    }
}

