/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.security.aspect;

import com.zkteco.zkbiosecurity.security.BrowserTokenValidator;
import com.zkteco.zkbiosecurity.security.annotation.ValidSecurity;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class SecurityAspect {
    @Autowired
    private BrowserTokenValidator browserTokenValidator;
    private ExpressionParser parser = new SpelExpressionParser();
    private LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();

    @Around(value="@annotation(validSecurity)")
    public Object around(ProceedingJoinPoint pjp, ValidSecurity validSecurity) throws Throwable {
        HttpSession session;
        boolean needValid = true;
        if (StringUtils.isNotBlank((CharSequence)validSecurity.condition())) {
            Method method = this.getMethod(pjp);
            Object[] args = pjp.getArgs();
            EvaluationContext context = this.bindParam(method, args);
            Expression expression = this.parser.parseExpression(validSecurity.condition());
            needValid = (Boolean)expression.getValue(context, Boolean.class);
        }
        ServletRequestAttributes ra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ra.getRequest();
        if (validSecurity.onlyLogin() && Objects.nonNull(session = request.getSession(true)) && Objects.nonNull(session.getAttribute("user"))) {
            needValid = false;
        }
        if (needValid) {
            if (this.browserTokenValidator.validate()) {
                return pjp.proceed();
            }
        } else {
            return pjp.proceed();
        }
        return null;
    }

    private Method getMethod(ProceedingJoinPoint pjp) throws NoSuchMethodException {
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        Method targetMethod = pjp.getTarget().getClass().getMethod(method.getName(), method.getParameterTypes());
        return targetMethod;
    }

    private EvaluationContext bindParam(Method method, Object[] args) {
        String[] params = this.discoverer.getParameterNames(method);
        StandardEvaluationContext context = new StandardEvaluationContext();
        int len = 0;
        while (len < params.length) {
            context.setVariable(params[len], args[len]);
            ++len;
        }
        ServletRequestAttributes ra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = ra.getRequest();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            String val = request.getParameter(key);
            context.setVariable(key, (Object)val);
        }
        return context;
    }
}

