/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.security;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternConstants {
    private static final Logger log = LoggerFactory.getLogger(PatternConstants.class);
    private static String keyOne = "insert|select|delete|update|drop|truncate|declare";
    private static String keyTwo = "and|or|xor|like|rlike|not";
    private static String keyFun = "exec|count|chr|mid|char|avg|sum|min|max|cast|convert|lower|upper|trim|ltrim|rtrim";
    private static String keySym = "%|--|+";
    public static List<Pattern> keyOneSet = null;
    public static List<Pattern> keyTwoSet = null;
    public static List<Pattern> keyFunSet = null;
    public static List<String> keySymSet = new ArrayList<String>();
    public static Pattern moreStar = Pattern.compile("[*]{2,}");
    public static Pattern urlPattern = Pattern.compile("%[0-9a-fA-F]{2}");
    public static Pattern keyPattern1 = Pattern.compile("[+][\\s]*(('(.)*)|([\\d]+[\\s]*(,|;)))");
    public static Pattern keyPattern2 = Pattern.compile("[\\d]+[\\s]*[+][\\s]*(-)?[\\s]*[\\d]+");
    public static Pattern sqlKeyPattern1 = Pattern.compile("[+]*(like|and|or|xor|rlike|not)(([+])|([\\s]+['0-9]+))", 2);
    public static Pattern sqlKeyPattern2 = Pattern.compile("[+]*(like|and|or|xor|rlike|not)(([+]{2})|([\\s]+['0-9]+))", 2);
    public static Pattern sqlKeyPattern3 = Pattern.compile("((like|and|or|xor|rlike|not)[\\s]*[%'])|([%'][\\s]*(like|and|or|xor|rlike|not)[\\W]+)|(\\|\\|)|(&&)", 2);
    public static Pattern dqPattern = Pattern.compile("[\"]+(.)*[\"]+");
    public static Pattern bdqPattern = Pattern.compile("\\{\"");
    public static Pattern htmlPattern = Pattern.compile("<([^>]*)>");
    public static Pattern imagePattern = Pattern.compile("data:image/(.)*;base64,");
    public static List<Pattern> htmlPatterns = new ArrayList<Pattern>();

    static {
        keyOneSet = PatternConstants.convertStringToList(keyOne, "([\\s]+|;|(\\([\\s]*))", "([\\s]+|[+])");
        keyOneSet.addAll(PatternConstants.convertStringToList(keyOne, "^", "([\\s]+|[+])"));
        keyOneSet.addAll(PatternConstants.convertStringToList(keyOne, "", "[\\s]*/\\*(.)*\\*/"));
        keyTwoSet = PatternConstants.convertStringToList(keyTwo, "[\\s]+", "[\\s]+([\\d]+|')");
        keyFunSet = PatternConstants.convertStringToList(keyFun, "", "[\\s]*\\(");
        keySymSet = PatternConstants.convertStringToSet(keySym);
        PatternConstants.initHtml();
    }

    private static void initHtml() {
        ArrayList<String> regexs = new ArrayList<String>();
        regexs.add("<([^>]*)>");
        regexs.add("<script>(.*?)</script>");
        regexs.add("(href|src)[\r\n]*=[\r\n]*\\'(.*?)");
        regexs.add("(href|src)[\r\n]*=[\r\n]*\\\"(.*?)");
        regexs.add("(window\\[\"location\"\\]|window\\['location'\\]|location)[\\s]*=(.*)");
        regexs.add("onmouse(over|down|out|move|up|wheel|enter)[\\s]*=(.*)");
        regexs.add("(onclick|ondblclick|onsubmit|onblur|onchange|onfocus)[\\s]*=(.*)");
        regexs.add("alert[\\s]*\\((.*?)\\)");
        regexs.add(":[\\s]*alert");
        regexs.add("</script>");
        regexs.add("<script(.*?)>");
        regexs.add("eval\\((.*?)\\)");
        regexs.add("function[\\s]*\\((.*?)\\)");
        regexs.add("(;|=)[\\s]*new[\\s]+");
        regexs.add("expression\\((.*?)\\)");
        regexs.add("javascript:");
        regexs.add("vbscript:");
        regexs.add("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']");
        regexs.add("onload(.*?)=");
        regexs.add("<iframe>(.*?)</iframe>");
        regexs.add("</iframe>");
        regexs.add("<iframe(.*?)>");
        regexs.add("<frame>(.*?)</frame>");
        regexs.add("</frame>");
        regexs.add("<frame(.*?)>");
        regexs.add("<a>(.*?)</a>");
        regexs.add("</a>");
        regexs.add("<a(.*?)>");
        regexs.add("((like|and|or|xor|not|rlike)[\\s]*[%'])|([%'][\\s]*(like|and|or|xor|not|rlike)[\\W]+)");
        regexs.add("(/\\*(.)*\\*/)[\\s]*(like|and|or|xor|not|rlike)");
        regexs.add("(like|and|or|xor|not|rlike)[\\s]*(/\\*(.)*\\*/)");
        regexs.add("'[\\s]*[+][\\s]*''[\\s]*[+][\\s]*'");
        regexs.add("%'[\\s]*(like|and|or|xor|not|rlike)[\\s]*'(.)*%'[\\s]*=[\\s]*'");
        for (String regex : regexs) {
            Pattern pattern = Pattern.compile(regex, 42);
            htmlPatterns.add(pattern);
        }
    }

    private static List<Pattern> convertStringToList(String str, String prefix, String suffix) {
        String[] keyStr;
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        String[] stringArray = keyStr = str.split("\\|");
        int n = keyStr.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            patterns.add(Pattern.compile(String.valueOf(prefix) + key + suffix, 2));
            ++n2;
        }
        return patterns;
    }

    private static List<String> convertStringToSet(String str) {
        String[] keyStr;
        ArrayList<String> ret = new ArrayList<String>(0);
        String[] stringArray = keyStr = str.split("\\|");
        int n = keyStr.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            ret.add(key);
            ++n2;
        }
        return ret;
    }

    public static boolean match(List<Pattern> patterns, String value) {
        if (Objects.nonNull(patterns) && StringUtils.isNotBlank((CharSequence)value)) {
            for (Pattern pattern : patterns) {
                if (!PatternConstants.match(pattern, value)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean match(Pattern pattern, String value) {
        Matcher match = pattern.matcher(value);
        if (match.find()) {
            log.error("pos:" + match.start() + " cont:" + match.group());
            return true;
        }
        return false;
    }
}

