/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.security;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class BrowserTokenValidator {
    @Value(value="${system.validBrowser:true}")
    private Boolean validBrowser;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public boolean validate() {
        if (this.validBrowser.booleanValue()) {
            String val;
            String bToken = this.getToken();
            if (StringUtils.isNotBlank((CharSequence)bToken) && StringUtils.isNotBlank((CharSequence)(val = this.getPassTokenFromRedis(bToken)))) {
                String passToken = this.getPassTokenFromRequest();
                if (val.equals(passToken)) {
                    this.stringRedisTemplate.delete((Object)("system:browser:" + bToken));
                    return true;
                }
                return false;
            }
            return false;
        }
        return true;
    }

    public String getToken() {
        HttpServletRequest request = this.getRequest();
        String bToken = null;
        if (Objects.nonNull(request) && StringUtils.isBlank((CharSequence)(bToken = request.getHeader("browser-token")))) {
            bToken = request.getParameter("browserToken");
        }
        return bToken;
    }

    public String getPassTokenFromRequest() {
        String token = null;
        HttpServletRequest request = this.getRequest();
        if (Objects.nonNull(request) && StringUtils.isBlank((CharSequence)(token = request.getParameter("passToken")))) {
            token = request.getHeader("pass-token");
        }
        return token;
    }

    private HttpServletRequest getRequest() {
        HttpServletRequest req = null;
        ServletRequestAttributes ra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (Objects.nonNull(ra)) {
            req = ra.getRequest();
        }
        return req;
    }

    public String getPassTokenFromRedis(String bToken) {
        String token = null;
        if (StringUtils.isNotBlank((CharSequence)bToken)) {
            token = (String)this.stringRedisTemplate.opsForValue().get((Object)("system:browser:" + bToken));
        }
        return token;
    }

    public String getPassTokenFromRedis() {
        String bToken = this.getToken();
        return this.getPassTokenFromRedis(bToken);
    }

    public void deleteToken() {
        String bToken = this.getToken();
        if (StringUtils.isNotBlank((CharSequence)bToken)) {
            this.stringRedisTemplate.delete((Object)("system:browser:" + bToken));
        }
    }

    public String createToken() {
        String bToken = this.getToken();
        if (this.validBrowser.booleanValue() && StringUtils.isNotBlank((CharSequence)bToken)) {
            String pass = UUID.randomUUID().toString().replace("-", "");
            this.stringRedisTemplate.opsForValue().set((Object)("system:browser:" + bToken), (Object)pass, 5L, TimeUnit.MINUTES);
            return pass;
        }
        return null;
    }

    public boolean isValid(boolean flag) {
        if (this.validBrowser.booleanValue() && flag) {
            HttpServletRequest request = this.getRequest();
            if (Objects.nonNull(request)) {
                String vb = request.getParameter("validBrowser");
                return Boolean.TRUE.toString().equals(vb);
            }
            return false;
        }
        return this.validBrowser;
    }

    public boolean isValid() {
        return this.isValid(false);
    }
}

