/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.controller;

import com.zkteco.zkbiosecurity.adms.remote.AdmsProductRemote;
import com.zkteco.zkbiosecurity.adms.service.AdmsProductService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsProductItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AdmsProductController
extends BaseController
implements AdmsProductRemote {
    @Autowired
    private AdmsProductService admsProductService;

    @RequiresPermissions(value={"adms:product"})
    public ModelAndView index() {
        return new ModelAndView("adms/product/admsProduct");
    }

    @RequiresPermissions(value={"adms:product:refresh"})
    public DxGrid list(AdmsProductItem admsProductItem) {
        Pager pager = this.admsProductService.getItemsByPage((BaseItem)admsProductItem, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, admsProductItem.getClass());
    }

    public ModelAndView edit(String id) {
        AdmsProductItem item = this.admsProductService.getItemById(id);
        if (item != null) {
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("adms/product/editAdmsProduct");
    }

    @RequiresPermissions(value={"adms:product:edit"})
    @LogChangeRequest(module="adms_module", object="adms_product_title", opType="common_op_edit", service=AdmsProductService.class, vo=AdmsProductItem.class)
    public ZKResultMsg save(AdmsProductItem admsProductItem) {
        this.admsProductService.saveItem(admsProductItem);
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"adms:product:del"})
    @LogRequest(module="adms_module", object="adms_product_title", opType="common_op_del", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg del(String ids) {
        this.admsProductService.deleteByIds(ids);
        return ZKResultMsg.successMsg();
    }

    public boolean isNotExist(String name) {
        return this.admsProductService.isNotExist(name);
    }

    public ZKResultMsg getSelectList() {
        return this.admsProductService.getSelectList();
    }
}

