/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.adms.remote.AdmsDeviceRemote;
import com.zkteco.zkbiosecurity.adms.service.AdmsAuthDeviceService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDevCmdService;
import com.zkteco.zkbiosecurity.adms.service.AdmsDeviceService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsAuthDeviceItem;
import com.zkteco.zkbiosecurity.adms.vo.AdmsDeviceItem;
import com.zkteco.zkbiosecurity.adms.vo.AdmsDeviceKeyItem;
import com.zkteco.zkbiosecurity.adms.vo.AdmsDeviceServerInfoItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.EmptyUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AdmsDeviceController
extends BaseController
implements AdmsDeviceRemote {
    @Autowired
    private AdmsDeviceService admsDeviceService;
    @Autowired
    private AdmsAuthDeviceService admsAuthDeviceService;
    @Autowired
    private AdmsDevCmdService admsDevCmdService;

    @RequiresPermissions(value={"adms:device"})
    public ModelAndView index() {
        return new ModelAndView("adms/device/admsDevice");
    }

    @RequiresPermissions(value={"adms:device:add"})
    public ModelAndView edit(String id) {
        if (!StringUtils.isNotBlank((CharSequence)id)) {
            return new ModelAndView("adms/device/addAdmsDevice");
        }
        this.request.setAttribute("item", (Object)this.admsDeviceService.getItemById(id));
        return new ModelAndView("adms/device/editAdmsDevice");
    }

    public ZKResultMsg save(AdmsDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.admsDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"adms:device:refresh"})
    public DxGrid list(AdmsDeviceItem codition) {
        Pager pager = this.admsDeviceService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        List deviceItems = pager.getData();
        ArrayList resultDeviceItems = new ArrayList();
        if (EmptyUtil.isNotEmpty((Collection)deviceItems)) {
            for (AdmsDeviceItem admsDeviceItem : deviceItems) {
                admsDeviceItem.setStatus(this.admsDeviceService.getDevStatus(admsDeviceItem.getSn()));
                admsDeviceItem.setCmdCount(this.admsDevCmdService.getWaitCmdCount(admsDeviceItem.getSn()));
            }
        }
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"adms:device:del"})
    @LogRequest(module="adms_module", object="adms_device", opType="common_op_del", requestParams={"sn"}, opContent="adms_device_sn")
    public ZKResultMsg delete(String ids) {
        this.admsDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid authDeviceList(AdmsAuthDeviceItem codition) {
        Pager pager = this.admsAuthDeviceService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        List authDeviceItems = pager.getData();
        if (EmptyUtil.isNotEmpty((Collection)authDeviceItems)) {
            for (AdmsAuthDeviceItem item : authDeviceItems) {
                item.setPing(this.admsDeviceService.isOnline(item.getSn()));
            }
        }
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"adms:device:authSearch"})
    public ModelAndView authDeviceIndex() {
        return new ModelAndView("adms/device/admsAuthDevice");
    }

    public ZKResultMsg authDevice(String sn) {
        AdmsAuthDeviceItem item = this.admsAuthDeviceService.authDevice(sn);
        if (item == null) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.msg((boolean)false));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView addAuthDevice(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.admsAuthDeviceService.getServerInfoItem(id));
        }
        return new ModelAndView("adms/device/addAuthDevice");
    }

    public ZKResultMsg authConfirm(AdmsDeviceServerInfoItem item) {
        if (this.admsDeviceService.isOnline(item.getSn()).booleanValue()) {
            this.admsAuthDeviceService.authDevice(item.getSn());
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"adms_device_offlineErr"));
    }

    @RequiresPermissions(value={"adms:device:add"})
    @LogRequest(module="adms_module", object="adms_device", opType="common_op_new", requestParams={"sn"}, opContent="adms_device_sn")
    public ZKResultMsg addDevice(AdmsDeviceItem item) {
        if (this.admsDeviceService.isOnline(item.getSn()).booleanValue()) {
            this.admsAuthDeviceService.authDevice(item.getSn());
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"adms_device_offlineErr"));
    }

    @RequiresPermissions(value={"adms:device:authSetKey"})
    public ModelAndView setAuthDeviceKey() {
        this.request.setAttribute("item", (Object)this.admsAuthDeviceService.getAdmsDeviceKeyItem());
        return new ModelAndView("adms/device/setAuthDeviceKey");
    }

    @RequiresPermissions(value={"adms:device:authSetKey"})
    public ZKResultMsg saveAuthDeviceCode(AdmsDeviceKeyItem item) {
        this.admsAuthDeviceService.saveDeviceAuthKeyItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"adms:device:authDelKey"})
    public ZKResultMsg delAuthDeviceKey() {
        this.admsAuthDeviceService.delAuthDeviceKey();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"adms:device:devCtrlImport"})
    public ModelAndView importAuthManagement() {
        this.request.setAttribute("editPage", (Object)false);
        return new ModelAndView("adms/device/importAuthManagement");
    }

    @ResponseBody
    @LogRequest(module="adms_module", object="adms_device", opType="common_op_import", opContent="adms_projectDevCtrl_import")
    public ZKResultMsg uploadAuthManagement(MultipartFile file) {
        String errorMess = null;
        String projectNo = this.admsAuthDeviceService.getCurrentProjectNo();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream inputStream1 = file.getInputStream();){
                byte[] fileByte = this.admsAuthDeviceService.parseProjectDeviceControl(inputStream1);
                if (fileByte != null && fileByte.length > 0) {
                    String jsonStr = new String(fileByte, StandardCharsets.UTF_8);
                    JSONObject jsonObject = JSON.parseObject((String)jsonStr);
                    String fileProjectNo = jsonObject.getString("projectNo");
                    String fileExportTime = jsonObject.getString("time");
                    if (StringUtils.isNotBlank((CharSequence)projectNo)) {
                        if (StringUtils.equals((CharSequence)fileProjectNo, (CharSequence)projectNo)) {
                            this.saveProjectDeviceFile(file);
                        } else {
                            errorMess = I18nUtil.i18nCode((String)"adms_projectDevCtrl_errorProjectNo", (Object[])new Object[]{projectNo});
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)fileProjectNo) && StringUtils.isNotBlank((CharSequence)fileExportTime)) {
                        this.admsAuthDeviceService.saveProjectId(fileProjectNo);
                        this.admsAuthDeviceService.saveProjectVersion(fileExportTime);
                        this.saveProjectDeviceFile(file);
                    } else {
                        errorMess = I18nUtil.i18nCode((String)"adms_projectDevCtrl_jsonErr", (Object[])new Object[0]);
                    }
                } else {
                    errorMess = I18nUtil.i18nCode((String)"adms_projectDevCtrl_jsonErr", (Object[])new Object[0]);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error("uploadAuthManagement json error\uff1a" + e);
            errorMess = I18nUtil.i18nCode((String)"adms_projectDevCtrl_jsonErr", (Object[])new Object[0]);
        }
        return StringUtils.isBlank((CharSequence)errorMess) ? ZKResultMsg.successMsg() : ZKResultMsg.failMsg((String)errorMess, (Object[])new Object[0]);
    }

    private void saveProjectDeviceFile(MultipartFile file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = file.getInputStream();){
                this.admsAuthDeviceService.saveProjectDeviceFile(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage());
        }
    }
}

