/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.adms.remote.AdmsAuthDeviceRemote;
import com.zkteco.zkbiosecurity.adms.service.AdmsAuthDeviceFunctionCtrlService;
import com.zkteco.zkbiosecurity.adms.service.AdmsAuthDeviceService;
import com.zkteco.zkbiosecurity.adms.vo.AdmsAuthDeviceItem;
import com.zkteco.zkbiosecurity.adms.vo.AdmsAuthDeviceSimpleItem;
import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AdmsAuthDeviceController
extends BaseController
implements AdmsAuthDeviceRemote {
    @Autowired
    private AdmsAuthDeviceService admsAuthDeviceService;

    @RequiresPermissions(value={"adms:authDevice"})
    public ModelAndView index() {
        return new ModelAndView("adms/authDevice/admsAuthDevice");
    }

    @RequiresPermissions(value={"adms:authDevice:refresh"})
    public DxGrid list(AdmsAuthDeviceSimpleItem item) {
        Pager pager = this.admsAuthDeviceService.getSimpleItemsByPage(item, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, item.getClass());
    }

    public ModelAndView edit(String id) {
        AdmsAuthDeviceItem item;
        if (StringUtils.isNotBlank((CharSequence)id) && (item = this.admsAuthDeviceService.getItemById(id)) != null) {
            this.request.setAttribute("item", (Object)item);
        }
        JSONArray protypeArr = new JSONArray();
        AdmsAuthDeviceFunctionCtrlService.protypeInstanceForEach(ctrlService -> {
            JSONObject protypeJson = new JSONObject();
            protypeJson.put("name", (Object)ctrlService.getProtype());
            protypeJson.put("needCert", (Object)ctrlService.isOpenSslFunc());
            protypeJson.put("sort", (Object)ctrlService.getSort());
            protypeArr.add((Object)protypeJson);
        });
        protypeArr.sort(Comparator.comparing(json -> ((JSONObject)json).getIntValue("sort")));
        this.request.setAttribute("protypeArr", (Object)protypeArr.toJSONString());
        return new ModelAndView("adms/authDevice/editAdmsAuthDevice");
    }

    @RequiresPermissions(value={"adms:authDevice:edit"})
    @LogChangeRequest(module="adms_module", object="adms_auth_device", opType="common_op_edit", service=AdmsAuthDeviceService.class, vo=AdmsAuthDeviceSimpleItem.class)
    public ZKResultMsg save(AdmsAuthDeviceItem admsAuthDeviceItem, @RequestParam(value="devCert", required=false) MultipartFile devCert) {
        this.admsAuthDeviceService.saveAuthItem(admsAuthDeviceItem);
        if (devCert != null) {
            try {
                AdmsAuthDeviceFunctionCtrlService instance = AdmsAuthDeviceFunctionCtrlService.getInstanceByProtype((String)admsAuthDeviceItem.getProtype());
                if (instance.isOpenSslFunc()) {
                    instance.dealWithCert(admsAuthDeviceItem, devCert.getBytes());
                }
            }
            catch (Exception e) {
                this.log.error("dealWithCert error", (Throwable)e);
            }
        }
        return ZKResultMsg.successMsg();
    }

    @RequiresPermissions(value={"adms:authDevice:del"})
    @LogRequest(module="adms_module", object="adms_auth_device", opType="common_op_del", requestParams={"sn"}, opContent="common_dev_sn")
    public ZKResultMsg del(String ids) {
        this.admsAuthDeviceService.deleteByIds(ids);
        return ZKResultMsg.successMsg();
    }

    public boolean isNotExistSn(String sn) {
        return this.admsAuthDeviceService.isNotExistSn(sn);
    }

    public ModelAndView exportView(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        return new ModelAndView("adms/authDevice/opExportConnElement");
    }

    @LogRequest(module="adms_module", object="adms_auth_device", opType="common_op_export", requestParams={"ids"}, opContent="common_number")
    public void export(String ids, Integer activeTime) {
        block31: {
            this.response.setCharacterEncoding("utf-8");
            this.response.setHeader("Content-Disposition", "attachment;filename=\"connElement_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".zip" + "\"");
            this.response.setContentType("application/octet-stream");
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (ServletOutputStream outputStream = this.response.getOutputStream();){
                    if (!StringUtils.isNotBlank((CharSequence)ids)) break block31;
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
                        Throwable throwable3 = null;
                        Object var10_16 = null;
                        try (ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);){
                            String[] idAr = StringUtils.split((String)ids, (String)",");
                            List authDeviceItemList = this.admsAuthDeviceService.getItemByIdList(Arrays.asList(idAr));
                            HashSet<AdmsAuthDeviceFunctionCtrlService> protypeSet = new HashSet<AdmsAuthDeviceFunctionCtrlService>();
                            for (AdmsAuthDeviceItem deviceItem : authDeviceItemList) {
                                AdmsAuthDeviceFunctionCtrlService instance = AdmsAuthDeviceFunctionCtrlService.getInstanceByProtype((String)deviceItem.getProtype());
                                instance.addInfoToConnElementFile(deviceItem, zipOutputStream, activeTime);
                                protypeSet.add(instance);
                            }
                            for (AdmsAuthDeviceFunctionCtrlService instance : protypeSet) {
                                instance.afterConnElementFileCreate(zipOutputStream);
                            }
                            zipOutputStream.flush();
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                        byteArrayOutputStream.writeTo((OutputStream)outputStream);
                        outputStream.flush();
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage());
            }
        }
    }
}

