/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.init;

import com.alibaba.druid.util.Base64;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.provider.AuthInitDataProvider;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.esdc.constant.EsdcConstants;
import com.zkteco.zkbiosecurity.esdc.service.EsdcCrosslineConfigImgService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcDealEventQuickLabelService;
import com.zkteco.zkbiosecurity.esdc.service.EsdcRankingWidgetService;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcCrosslineConfigImgItem;
import com.zkteco.zkbiosecurity.esdc.vo.EsdcDealEventQuickLabelItem;
import com.zkteco.zkbiosecurity.system.constants.BaseDataConstants;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
@Order(value=200)
public class EsdcInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(EsdcInit.class);
    @Autowired(required=false)
    private AuthInitDataProvider authInitDataProvider;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private EsdcDealEventQuickLabelService esdcDealEventQuickLabelService;
    @Autowired
    private EsdcCrosslineConfigImgService esdcCrosslineConfigImgService;
    @Autowired
    private EsdcRankingWidgetService esdcRankingWidgetService;

    public void run(String ... args) {
        try {
            boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("EsdcInit");
            if (!alreadyInit) {
                this.initAuthPermission();
                this.initQuickLabel();
                this.initDataImg();
                this.initUpgradeVersion();
                this.baseSysParamService.setAlreadyInitModule("EsdcInit");
                this.initParams();
            }
        }
        catch (Exception e) {
            log.error("EsdcInit error", (Throwable)e);
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("Esdc", "esdc_module", "esdc", "system", "true", Integer.valueOf(20));
        systemItem = this.authInitDataProvider.initPermissionData(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("EsdcSceneManager", "esdc_scene_manager", "esdc:scene:manager", "menu", "true", Integer.valueOf(1));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setImg("esdc_scene.png");
        subMenuItem1.setImgHover("esdc_scene_over.png");
        subMenuItem1 = this.authInitDataProvider.initPermissionData(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("EsdcQuitJobPersonManager", "esdc_quitJobPerson_manager", "esdc:keyPerson", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcKeyPerson.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subMenuItem = new AuthPermissionItem("EsdcPersonnelSearchManager", "esdc_personSearch_manager", "esdc:personnelSearch", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcPersonnelSearch.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subMenuItem = new AuthPermissionItem("EsdcPasskbackManager", "esdc_passback_event_manager", "esdc:quitJobPerson", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcPassback.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subMenuItem = new AuthPermissionItem("EsdcEntranceFenceManager", "esdc_entrance_fence_manager", "esdc:entrancefence", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcEntranceFence.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subMenuItem = new AuthPermissionItem("EsdcLeavePost", "esdc_leave_post", "esdc:leavePost", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcLeavePost.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subMenuItem = new AuthPermissionItem("EsdcCrosslineScene", "esdc_crossline", "esdc:crossline", "menu", "true", Integer.valueOf(10));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcCrossline.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subMenuItem = new AuthPermissionItem("EsdcIndustryManage", "esdc_industry_management", "esdc:industry:manage", "menu", "true", Integer.valueOf(11));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcIndustryManage.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("EsdcIndustryManageRefresh", "common_op_refresh", "esdc:industry:manage:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EsdcRankingList", "esdc_rankingList", "esdc:rankingList", "menu", "true", Integer.valueOf(12));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcRankingWidget.do?rankingView");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subMenuItem1 = new AuthPermissionItem("EsdcDeviceManager", "esdc_device_manager", "esdc:device:manager", "menu", "true", Integer.valueOf(2));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("esdcDevice.do");
        subMenuItem1.setImg("device.png");
        subMenuItem1.setImgHover("device_over.png");
        subMenuItem1 = this.authInitDataProvider.initPermissionData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("EsdcSdcDevice", "esdc_sdc_device", "esdc:sdcdevice", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcSdcDevice.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceRefresh", "common_op_refresh", "esdc:sdcdevice:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subMenuItem.setActionLink("esdcSdcDevice.do");
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceRefresh", "common_op_refresh", "esdc:sdcdevice:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceAdd", "common_op_add", "esdc:sdcdevice:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceEdit", "common_op_edit", "esdc:sdcdevice:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceDel", "common_op_del", "esdc:sdcdevice:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceSearch", "common_dev_searchDev", "esdc:sdcdevice:searchDev", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceLineReplay", "esdc_sdc_video_storage", "esdc:sdcdevice:sdcLineReplay", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceEditSdkPassword", "esdc_device_edit_sdk_password", "esdc:sdcdevice:editsdkpassword", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceReboot", "common_op_reboot", "esdc:sdcdevice:reboot", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceSyncTime", "common_dev_syncTime", "esdc:sdcdevice:syncTime", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceVideoPlay", "esdc_common_rt_preview", "esdc:sdcdevice:videoPlay", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceOpenHWWeb", "esdc_sdc_server_system", "esdc:sdcdevice:openHWWeb", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDevicePersonnelList", "esdc_aiBox_target_list_library", "esdc:sdcdevice:faceList", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDevicesyncSdcDevice", "esdc_ai_box_sync", "esdc:sdcdevice:syncSdcDevice", "button", "true", Integer.valueOf(13));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSdcDeviceDelPersonnelList", "esdc_personnelList_delAll", "esdc:sdcdevice:delAllPersonnelList", "button", "true", Integer.valueOf(14));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EsdcAiBoxDevice", "esdc_ai_box_device", "esdc:aiboxdevice", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcAiBoxDevice.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxDeviceRefresh", "common_op_refresh", "esdc:aiboxdevice:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxDeviceAdd", "common_op_add", "esdc:aiboxdevice:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxDeviceEdit", "common_op_edit", "esdc:aiboxdevice:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxDeviceDel", "common_op_del", "esdc:aiboxdevice:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxDeviceReboot", "common_op_reboot", "esdc:aiboxdevice:reboot", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxDeviceHttpReportConfig", "esdc_ai_box_report", "esdc:aiboxdevice:setHttpReportConfig", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxDeviceSyncTime", "common_dev_syncTime", "esdc:aiboxdevice:syncTime", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxDeviceSynchronize", "esdc_ai_box_sync", "esdc:aiboxdevice:synchronize", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxDevicePersonnelList", "esdc_aiBox_target_list_library", "esdc:aiboxdevice:faceList", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxDelDeviceDeviceFace", "esdc_aiBox_del_all_device_face", "esdc:aiboxdevice:delAllDeviceFace", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxChannelRefresh", "common_op_refresh", "esdc:aiboxchannel:refresh", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxChannelAdd", "esdc_ai_box_addChannel", "esdc:aiboxchannel:add", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxChannelEdit", "common_op_edit", "esdc:aiboxchannel:edit", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxChannelDel", "common_op_del", "esdc:aiboxchannel:del", "button", "true", Integer.valueOf(14));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxChannelConfig", "esdc_ai_box_channel_config", "esdc:aiboxchannel:channelConfig", "button", "true", Integer.valueOf(15));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcAiBoxVideoStorage", "esdc_sdc_video_storage", "esdc:aiboxchannel:linkReplay", "button", "true", Integer.valueOf(16));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("EsdcConfigManager", "esdc_config_manager", "esdc:config:manager", "menu", "true", Integer.valueOf(3));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("esdcConfig.do");
        subMenuItem1.setImg("esdc_config.png");
        subMenuItem1.setImgHover("esdc_config_over.png");
        subMenuItem1 = this.authInitDataProvider.initPermissionData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("EsdcCrosslineArea", "esdc_crossline_area", "esdc:crosslineArea", "menu", "true", Integer.valueOf(12));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcCrosslineArea.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcCrosslineAreaRefresh", "common_op_refresh", "esdc:crosslineArea:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcCrosslineAreaAdd", "common_op_add", "esdc:crosslineArea:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcCrosslineAreaEdit", "common_op_edit", "esdc:crosslineArea:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcCrosslineAreaDel", "common_op_del", "esdc:crosslineArea:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcCrosslineAreaCheck", "esdc_crossline_check", "esdc:crosslineArea:check", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EsdcSceneConfig", "esdc_scene_config", "esdc:sceneconfig", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcSceneConfig.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcSceneConfigRefresh", "common_op_refresh", "esdc:sceneconfig:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSceneConfigAdd", "common_op_add", "esdc:sceneconfig:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSceneConfigEdit", "common_op_edit", "esdc:sceneconfig:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSceneConfigDel", "common_op_del", "esdc:sceneconfig:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSceneConfigExport", "common_op_export", "esdc:sceneconfig:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcSceneConfigImport", "common_op_import", "esdc:sceneconfig:import", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EsdcCrosslineConfigImg", "esdc_crossline_configimg", "esdc:crosslineConfigImg", "menu", "true", Integer.valueOf(13));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcCrosslineConfigImg.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcCrosslineConfigImgRefresh", "common_op_refresh", "esdc:crosslineConfigImg:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcCrosslineConfigImgAdd", "common_op_add", "esdc:crosslineConfigImg:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcCrosslineConfigImgDel", "common_op_del", "esdc:crosslineConfigImg:del", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EsdcTimeSeg", "common_leftMenu_timeZone", "base:timeseg", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("baseTimeSeg.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcTimeSegRefresh", "common_op_refresh", "base:timeseg:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTimeSegAdd", "common_op_add", "base:timeseg:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTimeSegEdit", "common_op_edit", "base:timeseg:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTimeSegDel", "common_op_del", "base:timeseg:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTimeSegExport", "common_op_export", "base:timeseg:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTimeSegImport", "common_op_import", "base:timeseg:import", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EsdcRankingWidget", "esdc_rankingWidget_setting", "esdc:ranking:widget", "menu", "true", Integer.valueOf(14));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcRankingWidget.do?rankingWidgetConfig");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcRankingRefresh", "common_op_refresh", "esdc:ranking:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcRankingAdd", "common_op_add", "esdc:ranking:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcRankingEdit", "common_op_edit", "esdc:ranking:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcRankingDel", "common_op_del", "esdc:ranking:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EsdcIndustryConfig", "esdc_industry_config", "esdc:industry:config", "menu", "true", Integer.valueOf(15));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcIndustryConfig.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcIndustryConfigRefresh", "common_op_refresh", "esdc:industry:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcIndustryConfigAdd", "common_op_add", "esdc:industry:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcIndustryConfigEdit", "common_op_edit", "esdc:industry:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcIndustryConfigDel", "common_op_del", "esdc:industry:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EsdcParams", "esdc_params", "esdc:params", "menu", "true", Integer.valueOf(16));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcParams.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        AuthPermissionItem authPermissionItem = new AuthPermissionItem("EsdcGlobalLinkage", "esdc_Global_Linkage", "esdc:global:linkage", "menu", "true", Integer.valueOf(17));
        authPermissionItem.setParentId(subMenuItem1.getId());
        authPermissionItem.setActionLink("esdcGlobalLinkage.do");
        this.authInitDataProvider.initPermissionData(authPermissionItem);
        subMenuItem1 = new AuthPermissionItem("EsdcTransactionManager", "esdc_transaction_manager", "esdc:transaction:manager", "menu", "true", Integer.valueOf(5));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("esdcTransaction.do");
        subMenuItem1.setImg("esdc_report.png");
        subMenuItem1.setImgHover("esdc_report_over.png");
        subMenuItem1 = this.authInitDataProvider.initPermissionData(subMenuItem1);
        subMenuItem = new AuthPermissionItem("EsdcTransaction", "esdc_transaction", "esdc:transaction", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcTransaction.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcTransactionRefresh", "common_op_refresh", "esdc:transaction:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTransactionAdd", "common_op_add", "esdc:transaction:add", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTransactionEdit", "common_op_edit", "esdc:transaction:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTransactionDel", "common_op_del", "esdc:transaction:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTransactionExport", "common_op_export", "esdc:transaction:export", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTransactionImport", "common_op_import", "esdc:transaction:import", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EsdcCrosslineEvent", "esdc_crosslineEvent", "esdc:crosslineEvent", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcCrosslineEvent.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcCrosslineEventRefresh", "common_op_refresh", "esdc:crosslineEvent:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcCrosslineEventExport", "common_op_import", "esdc:crosslineEvent:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EsdcTrackReport", "esdc_track_report_manager", "esdc:trackreport", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcTrackReport.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcTrackReportRefresh", "common_op_refresh", "esdc:trackreport:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTrackReportDel", "common_op_del", "esdc:trackreport:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcTrackReportDetail", "esdc_common_detail", "esdc:trackreport:reportDetail", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subMenuItem = new AuthPermissionItem("EsdcLeavePostReport", "esdc_leave_post_report_manager", "esdc:leavePostReport", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("esdcLeavePostReport.do");
        subMenuItem = this.authInitDataProvider.initPermissionData(subMenuItem);
        subButtonItem = new AuthPermissionItem("EsdcLeavePostReportRefresh", "common_op_refresh", "esdc:leavePostReport:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcLeavePostReportDel", "common_op_del", "esdc:leavePostReport:del", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
        subButtonItem = new AuthPermissionItem("EsdcLeavePostReportInfoDetail", "esdc_common_detail", "esdc:leavePostReport:reportDetail", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authInitDataProvider.initPermissionData(subButtonItem);
    }

    private void initQuickLabel() {
        EsdcDealEventQuickLabelItem item = null;
        for (int i = 1; i <= 6; ++i) {
            item = new EsdcDealEventQuickLabelItem("000" + i, "esdc_transaction_quick" + i);
            item = this.esdcDealEventQuickLabelService.initData(item);
        }
    }

    private void initDataImg() {
        try {
            Resource[] resources = new PathMatchingResourcePatternResolver().getResources("classpath:static/images/crosslineConfigImg/*.png");
            log.info("-----------------initconfigImg----------------------" + resources);
            String fileBase64Str = "";
            String saveFilePath = "";
            String imgPath = "upload/esdc/crosslineImage/";
            String defaultPath = FileUtils.systemFilePath + File.separator + imgPath;
            for (Resource res : resources) {
                fileBase64Str = this.getBase64FromInputStream(res.getInputStream());
                String fileName = res.getFilename();
                FileUtils.saveFile((String)imgPath, (String)fileName, (String)fileBase64Str, (boolean)false);
                saveFilePath = imgPath + fileName;
                EsdcCrosslineConfigImgItem configImgItem = new EsdcCrosslineConfigImgItem();
                configImgItem.setImgPath(saveFilePath);
                configImgItem.setImgName(fileName);
                configImgItem.setDelFlag(Boolean.valueOf(false));
                this.esdcCrosslineConfigImgService.saveDefaultImgItem(configImgItem);
            }
        }
        catch (Exception e) {
            log.error("Init image error");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBase64FromInputStream(InputStream is) throws Exception {
        byte[] data = null;
        try {
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = is.read(buff, 0, 100)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            data = swapStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new Exception("inputstream close error");
                }
            }
        }
        return Base64.byteArrayToBase64(data);
    }

    private void initParams() {
        BaseSysParamItem item = new BaseSysParamItem("esdc.capturePrivacySaveEnable", EsdcConstants.CAPTURE_PRIVACY_SAVE_ENABLED.toString(), "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("esdc.allowListPrivateNameEnable", EsdcConstants.DEFAULT_ALLOW_LIST_PRIVATE_NAME_ENABLED.toString(), "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("esdc.blockListPrivateNameEnable", EsdcConstants.DEFAULT_BLOCK_LIST_PRIVATE_NAME_ENABLED.toString(), "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("esdc.face38ServerEnable", EsdcConstants.DEFAULT_ALGORITHM_38_SERVER_ENABLED.toString(), "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("esdc.bodyStructuredServerEnable", EsdcConstants.DEFAULT_ALGORITHM_BODY_SERVER_ENABLED.toString(), "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("esdc.mail", "", "Receiver");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("esdc.popUpAlarmEnable", "false", "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("esdc.eventTypes", "", "Alarm Event Type");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("esdc.serverUrl", "http://127.0.0.1:58098", "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("esdc.wsUrl", "ws://127.0.0.1:58098/websocket", "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("esdc.serverHttpPort", "58097", "");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("facecompare.version", "true", "facecompare", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("persstructured.version", "true", "persstructured", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("peoplecounting.version", "true", "peoplecounting", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("personnelcontrol.version", "true", "personnelcontrol", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("keyaccesscontrol.version", "true", "keyaccesscontrol", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("electronicfence.version", "true", "electronicfence", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("offduty.version", "true", "offduty", Boolean.valueOf(true));
        this.baseSysParamService.initData(item);
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"6");
        values.put("runtime", (Object)"01:00:00");
        values.put("keptType", (Object)BaseDataConstants.DATA_CLEAN_KEPTDAY);
        item = new BaseSysParamItem("esdcReportDataClean", values.toString(), "base_dataClean_psgTrans");
        this.baseSysParamService.initData(item);
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"esdc");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("EsdcUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("EsdcUpgradeVersion", curVersion, "Esdc Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

