/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.cloud.sdk.util;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.cloud.sdk.ApiException;
import com.zkteco.cloud.sdk.FileItem;
import com.zkteco.cloud.sdk.bean.FileBean;
import com.zkteco.cloud.sdk.internal.util.StringUtils;
import com.zkteco.cloud.sdk.internal.util.WebUtils;
import com.zkteco.cloud.sdk.internal.util.ZKCloudHashMap;
import com.zkteco.cloud.sdk.resp.BaseResponse;
import com.zkteco.cloud.sdk.util.EncrypAESUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ZKCloudApiFileUploadUtil {
    public static BaseResponse upload(FileBean fileBean) throws ApiException {
        BaseResponse response = new BaseResponse();
        Long timestamp = System.currentTimeMillis();
        byte[] imageBytes = null;
        String rsp = null;
        ZKCloudHashMap signMap = new ZKCloudHashMap();
        String nonce = new StringBuilder(fileBean.getAppId().substring(8, 24)).reverse().toString();
        signMap.put("timestamp", timestamp.toString());
        signMap.put("appId", fileBean.getAppId());
        signMap.put("nonce", nonce);
        signMap.put("method", "/file/uploadImage");
        ZKCloudHashMap appParams = new ZKCloudHashMap();
        appParams.put("moduleName", fileBean.getModuleName());
        HashMap<String, FileItem> fileParams = new HashMap<String, FileItem>();
        try {
            String url = null;
            if (Objects.nonNull(fileBean.getFile())) {
                url = fileBean.getCloudServerFileUrl() + "/file/uploadFile";
                fileParams.put("file", fileBean.getFile());
                imageBytes = fileBean.getFile().getBytes();
            } else if (!StringUtils.isEmpty(fileBean.getBase64Image())) {
                url = fileBean.getCloudServerFileUrl() + "/file/uploadImage";
                appParams.put("base64Image", fileBean.getBase64Image());
                imageBytes = fileBean.getBase64Image().getBytes("UTF-8");
            }
            appParams.put("image", EncrypAESUtil.encryptHMACSHA256(imageBytes, fileBean.getAppKey()));
            signMap.put("file", JSONObject.toJSONString((Object)appParams.sortMap()));
            System.out.println(JSONObject.toJSONString((Object)signMap.sortMap()));
            String sign = EncrypAESUtil.encryptHMACSHA256(JSONObject.toJSONString((Object)signMap.sortMap()), fileBean.getAppKey());
            System.out.println(sign);
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Authorization", String.format("HMAC-SHA256,appId=%s,nonce=%s,timestamp=%s,signature=%s", fileBean.getAppId(), nonce, timestamp, sign));
            headerMap.put("Cos-Version", "4.0");
            headerMap.put("X-COS-SERVER-SIDE-ENCRYPTION", fileBean.getCosEncry());
            rsp = WebUtils.doPost(url, (Map<String, String>)appParams, fileParams, "UTF-8", 15000, 30000, headerMap);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        response.setBody(rsp);
        return response;
    }

    public static BaseResponse getDecryptFileBase64(FileBean fileBean) throws ApiException {
        BaseResponse response = new BaseResponse();
        Long timestamp = System.currentTimeMillis();
        Object imageBytes = null;
        String rsp = null;
        ZKCloudHashMap signMap = new ZKCloudHashMap();
        String nonce = new StringBuilder(fileBean.getAppId().substring(8, 24)).reverse().toString();
        signMap.put("timestamp", timestamp.toString());
        signMap.put("appId", fileBean.getAppId());
        signMap.put("nonce", nonce);
        signMap.put("method", "/file/decryptFile");
        signMap.put("fileId", fileBean.getFileId());
        ZKCloudHashMap appParams = new ZKCloudHashMap();
        appParams.put("fileId", fileBean.getFileId());
        HashMap<String, FileItem> fileParams = new HashMap<String, FileItem>();
        try {
            String url = fileBean.getCloudServerFileUrl() + "/file/decryptFile";
            System.out.println(JSONObject.toJSONString((Object)signMap.sortMap()));
            String sign = EncrypAESUtil.encryptHMACSHA256(JSONObject.toJSONString((Object)signMap.sortMap()), fileBean.getAppKey());
            System.out.println(sign);
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("Authorization", String.format("HMAC-SHA256,appId=%s,nonce=%s,timestamp=%s,signature=%s", fileBean.getAppId(), nonce, timestamp, sign));
            headerMap.put("Cos-Version", "4.0");
            rsp = WebUtils.doPost(url, (Map<String, String>)appParams, fileParams, "UTF-8", 15000, 30000, headerMap);
        }
        catch (IOException e) {
            throw new ApiException(e);
        }
        response.setBody(rsp);
        return response;
    }
}

