/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.cloud.sdk;

import com.zkteco.cloud.sdk.ApiException;
import com.zkteco.cloud.sdk.ApiRuleException;
import com.zkteco.cloud.sdk.BaseRequest;
import com.zkteco.cloud.sdk.BaseUploadRequest;
import com.zkteco.cloud.sdk.FileItem;
import com.zkteco.cloud.sdk.ZKCouldClient;
import com.zkteco.cloud.sdk.internal.util.RequestParametersHolder;
import com.zkteco.cloud.sdk.internal.util.WebUtils;
import com.zkteco.cloud.sdk.internal.util.ZKCLoudLogger;
import com.zkteco.cloud.sdk.internal.util.ZKCloudHashMap;
import com.zkteco.cloud.sdk.internal.util.ZKCloudUtils;
import com.zkteco.cloud.sdk.resp.BaseResponse;
import java.io.IOException;
import java.util.Map;

public class DefaultZKCloudClient
implements ZKCouldClient {
    protected String serverUrl;
    protected String appId;
    protected String appKey;
    protected String format = "json";
    protected String signMethod = "hmac";
    protected int connectTimeout = 15000;
    protected int readTimeout = 30000;
    protected boolean needCheckRequest = true;
    protected boolean needEnableParser = true;
    protected boolean useGzipEncoding = true;

    public DefaultZKCloudClient(String serverUrl, String appId, String appKey) {
        this.appId = appId;
        this.appKey = appKey;
        this.serverUrl = serverUrl;
    }

    public DefaultZKCloudClient(String serverUrl, String appId, String appKey, String format) {
        this(serverUrl, appId, appKey);
        this.format = format;
    }

    public DefaultZKCloudClient(String serverUrl, String appId, String appKey, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, appId, appKey, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultZKCloudClient(String serverUrl, String appId, String appKey, String format, int connectTimeout, int readTimeout, String signMethod) {
        this(serverUrl, appId, appKey, format, connectTimeout, readTimeout);
        this.signMethod = signMethod;
    }

    @Override
    public <T extends BaseResponse> T execute(BaseRequest<T> request) throws ApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends BaseResponse> T execute(BaseRequest<T> request, String access_token) throws ApiException {
        return this._execute(request, access_token);
    }

    private <T extends BaseResponse> T _execute(BaseRequest<T> request, String access_token) throws ApiException {
        long start = System.currentTimeMillis();
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                BaseResponse localResponse = null;
                try {
                    localResponse = (BaseResponse)request.getResponseClass().newInstance();
                }
                catch (Exception xe) {
                    throw new ApiException(xe);
                }
                localResponse.setCode(e.getErrCode());
                localResponse.setMsg(e.getErrMsg());
                return (T)localResponse;
            }
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        ZKCloudHashMap appParams = new ZKCloudHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        ZKCloudHashMap protocalMustParams = new ZKCloudHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("v", "4.0");
        protocalMustParams.put("app_id", this.appId);
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("timestamp", (Object)timestamp);
        requestHolder.setProtocalMustParams(protocalMustParams);
        ZKCloudHashMap protocalOptParams = new ZKCloudHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("sign_method", this.signMethod);
        protocalOptParams.put("access_token", access_token);
        protocalOptParams.put("target_app_key", request.getTargetAppKey());
        requestHolder.setProtocalOptParams(protocalOptParams);
        try {
            protocalMustParams.put("sign", ZKCloudUtils.signTopRequest(requestHolder, this.appKey, this.signMethod));
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            String fullUrl = WebUtils.buildRequestUrl(this.serverUrl, sysMustQuery, sysOptQuery);
            System.out.println(fullUrl);
            String rsp = null;
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            if (request instanceof BaseUploadRequest) {
                BaseUploadRequest uRequest = (BaseUploadRequest)request;
                Map<String, FileItem> fileParams = ZKCloudUtils.cleanupMap(uRequest.getFileParams());
                rsp = WebUtils.doPost(fullUrl, (Map<String, String>)appParams, fileParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
            } else {
                rsp = WebUtils.doPost(fullUrl, (Map<String, String>)appParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap(), null);
            }
            requestHolder.setResponseBody(rsp);
        }
        catch (IOException e) {
            ZKCLoudLogger.logApiError(this.appKey, request.getApiMethodName(), this.serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new ApiException(e);
        }
        BaseResponse tRsp = null;
        if (this.needEnableParser) {
            tRsp = (BaseResponse)request.toResponse(requestHolder.getResponseBody());
        } else {
            try {
                tRsp = (BaseResponse)request.getResponseClass().newInstance();
                tRsp.setBody(requestHolder.getResponseBody());
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        tRsp.setParams(appParams);
        return (T)tRsp;
    }

    protected String getSdkVersion() {
        return "top-sdk-java-20180326";
    }

    public void setNeedCheckRequest(boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }

    public void setNeedEnableParser(boolean needEnableParser) {
        this.needEnableParser = needEnableParser;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        ZKCLoudLogger.setNeedEnableLogger(needEnableLogger);
    }

    public void setIgnoreSSLCheck(boolean ignore) {
        WebUtils.setIgnoreSSLCheck(ignore);
    }

    public void setUseGzipEncoding(boolean useGzipEncoding) {
        this.useGzipEncoding = useGzipEncoding;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void resetServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getRequestUrl() {
        return this.serverUrl;
    }

    public String getAppKey() {
        return this.appKey;
    }
}

