/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="PERS_PERSON PP LEFT JOIN AUTH_DEPARTMENT AD ON PP.AUTH_DEPT_ID = AD.ID LEFT JOIN INS_AREA_PERSON ISP ON ISP.PERS_PERSON_ID = PP.ID")
@GridConfig
public class InsPersonInAreaItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="ISP.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="ISP.AUTH_AREA_ID")
    private String authAreaId;
    @Column(name="PP.ID")
    private String personId;
    @Column(name="PP.PIN")
    @GridColumn(label="pers_person_pin", width="100", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String personPin;
    @Column(name="PP.NAME")
    @GridColumn(label="pers_person_name", width="100", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String personName;
    @Column(name="PP.LAST_NAME")
    @GridColumn(label="pers_person_lastName", showExpression="#language!='zh_CN'", width="100", encryptMode="${pers.lastName.encryptMode}", encryptProp="${pers.lastName.encryptProp}")
    private String personLastName;
    @Column(name="AD.ID")
    private String deptId;
    @Condition(value="AD.ID", equalTag="in")
    private String inDeptId;
    @Column(name="AD.CODE")
    private String deptCode;
    @Column(name="AD.NAME")
    @GridColumn(label="pers_dept_entity", width="*", sort="na")
    private String deptName;
    @Condition(value="(LOWER (PP.NAME) LIKE LOWER (''%{0}%'') OR LOWER (PP.LAST_NAME) LIKE LOWER (''%{0}%''))")
    private String likeName;
    @Condition(value="PP.AUTH_DEPT_ID IN (SELECT ud.AUTH_DEPT_ID FROM AUTH_USER_DEPT ud WHERE ud.AUTH_USER_ID=''{0}'')")
    private String userId;
    private String type;
    @Condition(value="PP.ID", equalTag="not in")
    private String selectId;
    private String isIncludeLower;

    public InsPersonInAreaItem setId(String id) {
        this.id = id;
        return this;
    }

    public InsPersonInAreaItem setAuthAreaId(String authAreaId) {
        this.authAreaId = authAreaId;
        return this;
    }

    public InsPersonInAreaItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public InsPersonInAreaItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public InsPersonInAreaItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public InsPersonInAreaItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public InsPersonInAreaItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public InsPersonInAreaItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public InsPersonInAreaItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public InsPersonInAreaItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public InsPersonInAreaItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public InsPersonInAreaItem setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public InsPersonInAreaItem setType(String type) {
        this.type = type;
        return this;
    }

    public InsPersonInAreaItem setSelectId(String selectId) {
        this.selectId = selectId;
        return this;
    }

    public InsPersonInAreaItem setIsIncludeLower(String isIncludeLower) {
        this.isIncludeLower = isIncludeLower;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getAuthAreaId() {
        return this.authAreaId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getType() {
        return this.type;
    }

    public String getSelectId() {
        return this.selectId;
    }

    public String getIsIncludeLower() {
        return this.isIncludeLower;
    }
}

