/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import sun.security.krb5.Checksum;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.internal.KDCRep;
import sun.security.krb5.internal.KDCReq;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.util.DerInputStream;

abstract class KrbKdcRep {
    KrbKdcRep() {
    }

    static void check(boolean isAsReq, KDCReq req, KDCRep rep, EncryptionKey replyKey) throws KrbApErrException {
        if (!(!isAsReq || req.reqBody.cname.equals(rep.cname) || req.reqBody.kdcOptions.get(15) && rep.encKDCRepPart.flags.get(15))) {
            rep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
        if (!req.reqBody.sname.equals(rep.encKDCRepPart.sname)) {
            String[] snameStrings = rep.encKDCRepPart.sname.getNameStrings();
            if (isAsReq || !req.reqBody.kdcOptions.get(15) || snameStrings == null || snameStrings.length != 2 || !snameStrings[0].equals("krbtgt") || !rep.encKDCRepPart.sname.getRealmString().equals(req.reqBody.sname.getRealmString())) {
                rep.encKDCRepPart.key.destroy();
                throw new KrbApErrException(41);
            }
        }
        if (req.reqBody.getNonce() != rep.encKDCRepPart.nonce) {
            rep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
        if (req.reqBody.addresses != null && rep.encKDCRepPart.caddr != null && !req.reqBody.addresses.equals(rep.encKDCRepPart.caddr)) {
            rep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
        for (int i = 2; i < 6; ++i) {
            if (req.reqBody.kdcOptions.get(i) == rep.encKDCRepPart.flags.get(i)) continue;
            if (Krb5.DEBUG) {
                System.out.println("> KrbKdcRep.check: at #" + i + ". request for " + req.reqBody.kdcOptions.get(i) + ", received " + rep.encKDCRepPart.flags.get(i));
            }
            throw new KrbApErrException(41);
        }
        if (req.reqBody.kdcOptions.get(8) && !rep.encKDCRepPart.flags.get(8)) {
            throw new KrbApErrException(41);
        }
        if ((req.reqBody.from == null || req.reqBody.from.isZero()) && rep.encKDCRepPart.starttime != null && !rep.encKDCRepPart.starttime.inClockSkew()) {
            rep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(37);
        }
        if (req.reqBody.from != null && !req.reqBody.from.isZero() && rep.encKDCRepPart.starttime != null && !req.reqBody.from.equals(rep.encKDCRepPart.starttime)) {
            rep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
        if (!req.reqBody.till.isZero() && rep.encKDCRepPart.endtime.greaterThan(req.reqBody.till)) {
            rep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
        if (rep.encKDCRepPart.flags.get(15) && req.reqBody.kdcOptions.get(15)) {
            boolean reqPaReqEncPaRep = false;
            boolean repPaReqEncPaRepValid = false;
            for (PAData pa : req.pAData) {
                if (pa.getType() != 149) continue;
                reqPaReqEncPaRep = true;
                break;
            }
            if (rep.encKDCRepPart.pAData != null) {
                for (PAData pa : rep.encKDCRepPart.pAData) {
                    if (pa.getType() != 149) continue;
                    try {
                        Checksum repCksum = new Checksum(new DerInputStream(pa.getValue()).getDerValue());
                        repPaReqEncPaRepValid = repCksum.verifyAnyChecksum(req.asn1Encode(), replyKey, 56);
                    }
                    catch (Exception e) {
                        if (!Krb5.DEBUG) break;
                        e.printStackTrace();
                    }
                    break;
                }
            }
            if (reqPaReqEncPaRep && !repPaReqEncPaRepValid) {
                throw new KrbApErrException(41);
            }
        }
        if (req.reqBody.kdcOptions.get(8) && req.reqBody.rtime != null && !req.reqBody.rtime.isZero() && (rep.encKDCRepPart.renewTill == null || rep.encKDCRepPart.renewTill.greaterThan(req.reqBody.rtime))) {
            rep.encKDCRepPart.key.destroy();
            throw new KrbApErrException(41);
        }
    }
}

