/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.kerberos.KeyTab;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KdcComm;
import sun.security.krb5.KrbAsRep;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.crypto.EType;

public final class KrbAsReqBuilder {
    private KDCOptions options;
    private PrincipalName cname;
    private PrincipalName refCname;
    private PrincipalName sname;
    private KerberosTime from;
    private KerberosTime till;
    private KerberosTime rtime;
    private HostAddresses addresses;
    private final char[] password;
    private final KeyTab ktab;
    private PAData[] paList;
    private KrbAsReq req;
    private KrbAsRep rep;
    private State state;

    private void init(PrincipalName cname) throws KrbException {
        this.cname = cname;
        this.refCname = cname;
        this.state = State.INIT;
    }

    public KrbAsReqBuilder(PrincipalName cname, KeyTab ktab) throws KrbException {
        this.init(cname);
        this.ktab = ktab;
        this.password = null;
    }

    public KrbAsReqBuilder(PrincipalName cname, char[] pass) throws KrbException {
        this.init(cname);
        this.password = (char[])pass.clone();
        this.ktab = null;
    }

    public EncryptionKey[] getKeys(boolean isInitiator) throws KrbException {
        this.checkState(isInitiator ? State.REQ_OK : State.INIT, "Cannot get keys");
        if (this.password != null) {
            int[] eTypes = EType.getDefaults("default_tkt_enctypes");
            EncryptionKey[] result = new EncryptionKey[eTypes.length];
            String salt = null;
            try {
                int i;
                for (i = 0; i < eTypes.length; ++i) {
                    PAData.SaltAndParams snp = PAData.getSaltAndParams(eTypes[i], this.paList);
                    if (snp == null) continue;
                    if (eTypes[i] != 23 && snp.salt != null) {
                        salt = snp.salt;
                    }
                    result[i] = EncryptionKey.acquireSecretKey(this.cname, this.password, eTypes[i], snp);
                }
                if (salt == null) {
                    salt = this.cname.getSalt();
                }
                for (i = 0; i < eTypes.length; ++i) {
                    if (result[i] != null) continue;
                    result[i] = EncryptionKey.acquireSecretKey(this.password, salt, eTypes[i], null);
                }
            }
            catch (IOException ioe) {
                KrbException ke = new KrbException(909);
                ke.initCause(ioe);
                throw ke;
            }
            return result;
        }
        throw new IllegalStateException("Required password not provided");
    }

    public void setOptions(KDCOptions options) {
        this.checkState(State.INIT, "Cannot specify options");
        this.options = options;
    }

    public void setTill(KerberosTime till) {
        this.checkState(State.INIT, "Cannot specify till");
        this.till = till;
    }

    public void setRTime(KerberosTime rtime) {
        this.checkState(State.INIT, "Cannot specify rtime");
        this.rtime = rtime;
    }

    public void setTarget(PrincipalName sname) {
        this.checkState(State.INIT, "Cannot specify target");
        this.sname = sname;
    }

    public void setAddresses(HostAddresses addresses) {
        this.checkState(State.INIT, "Cannot specify addresses");
        this.addresses = addresses;
    }

    private KrbAsReq build(EncryptionKey key, ReferralsState referralsState) throws KrbException, IOException {
        int[] eTypes;
        PAData[] extraPAs = null;
        if (this.password != null) {
            eTypes = EType.getDefaults("default_tkt_enctypes");
        } else {
            EncryptionKey[] ks = Krb5Util.keysFromJavaxKeyTab(this.ktab, this.cname);
            eTypes = EType.getDefaults("default_tkt_enctypes", ks);
            for (EncryptionKey k : ks) {
                k.destroy();
            }
        }
        KDCOptions kDCOptions = this.options = this.options == null ? new KDCOptions() : this.options;
        if (referralsState.isEnabled()) {
            this.options.set(15, true);
            extraPAs = new PAData[]{new PAData(149, new byte[0])};
        } else {
            this.options.set(15, false);
        }
        return new KrbAsReq(key, this.options, this.refCname, this.sname, this.from, this.till, this.rtime, eTypes, this.addresses, extraPAs);
    }

    private KrbAsReqBuilder resolve() throws KrbException, Asn1Exception, IOException {
        if (this.ktab != null) {
            this.rep.decryptUsingKeyTab(this.ktab, this.req, this.cname);
        } else {
            this.rep.decryptUsingPassword(this.password, this.req, this.cname);
        }
        if (this.rep.getPA() != null) {
            if (this.paList == null || this.paList.length == 0) {
                this.paList = this.rep.getPA();
            } else {
                int extraLen = this.rep.getPA().length;
                if (extraLen > 0) {
                    int oldLen = this.paList.length;
                    this.paList = Arrays.copyOf(this.paList, this.paList.length + extraLen);
                    System.arraycopy(this.rep.getPA(), 0, this.paList, oldLen, extraLen);
                }
            }
        }
        return this;
    }

    private KrbAsReqBuilder send() throws KrbException, IOException {
        boolean preAuthFailedOnce = false;
        KdcComm comm = null;
        EncryptionKey pakey = null;
        ReferralsState referralsState = new ReferralsState();
        while (true) {
            if (referralsState.refreshComm()) {
                comm = new KdcComm(this.refCname.getRealmAsString());
            }
            try {
                this.req = this.build(pakey, referralsState);
                this.rep = new KrbAsRep(comm.send(this.req.encoding()));
                return this;
            }
            catch (KrbException ke) {
                if (!(preAuthFailedOnce || ke.returnCode() != 24 && ke.returnCode() != 25)) {
                    if (Krb5.DEBUG) {
                        System.out.println("KrbAsReqBuilder: PREAUTH FAILED/REQ, re-send AS-REQ");
                    }
                    preAuthFailedOnce = true;
                    KRBError kerr = ke.getError();
                    int paEType = PAData.getPreferredEType(kerr.getPA(), EType.getDefaults("default_tkt_enctypes")[0]);
                    if (this.password == null) {
                        EncryptionKey[] ks = Krb5Util.keysFromJavaxKeyTab(this.ktab, this.cname);
                        pakey = EncryptionKey.findKey(paEType, ks);
                        if (pakey != null) {
                            pakey = (EncryptionKey)pakey.clone();
                        }
                        for (EncryptionKey k : ks) {
                            k.destroy();
                        }
                    } else {
                        pakey = EncryptionKey.acquireSecretKey(this.cname, this.password, paEType, PAData.getSaltAndParams(paEType, kerr.getPA()));
                    }
                    this.paList = kerr.getPA();
                    continue;
                }
                if (referralsState.handleError(ke)) {
                    pakey = null;
                    preAuthFailedOnce = false;
                    continue;
                }
                throw ke;
            }
            break;
        }
    }

    public KrbAsReqBuilder action() throws KrbException, Asn1Exception, IOException {
        this.checkState(State.INIT, "Cannot call action");
        this.state = State.REQ_OK;
        return this.send().resolve();
    }

    public Credentials getCreds() {
        this.checkState(State.REQ_OK, "Cannot retrieve creds");
        return this.rep.getCreds();
    }

    public sun.security.krb5.internal.ccache.Credentials getCCreds() {
        this.checkState(State.REQ_OK, "Cannot retrieve CCreds");
        return this.rep.getCCreds();
    }

    public void destroy() {
        this.state = State.DESTROYED;
        if (this.password != null) {
            Arrays.fill(this.password, '\u0000');
        }
    }

    private void checkState(State st, String msg) {
        if (this.state != st) {
            throw new IllegalStateException(msg + " at " + (Object)((Object)st) + " state");
        }
    }

    private final class ReferralsState {
        private boolean enabled;
        private int count;
        private boolean refreshComm;

        ReferralsState() throws KrbException {
            if (Config.DISABLE_REFERRALS) {
                if (KrbAsReqBuilder.this.refCname.getNameType() == 10) {
                    throw new KrbException("NT-ENTERPRISE principals only allowed when referrals are enabled.");
                }
                this.enabled = false;
            } else {
                this.enabled = true;
            }
            this.refreshComm = true;
        }

        boolean handleError(KrbException ke) throws RealmException {
            if (this.enabled) {
                if (ke.returnCode() == 68) {
                    Realm referredRealm = ke.getError().getClientRealm();
                    if (((KrbAsReqBuilder)KrbAsReqBuilder.this).req.getMessage().reqBody.kdcOptions.get(15) && referredRealm != null && referredRealm.toString().length() > 0 && this.count < Config.MAX_REFERRALS) {
                        KrbAsReqBuilder.this.refCname = new PrincipalName(KrbAsReqBuilder.this.refCname.getNameType(), KrbAsReqBuilder.this.refCname.getNameStrings(), referredRealm);
                        this.refreshComm = true;
                        ++this.count;
                        return true;
                    }
                }
                if (this.count < Config.MAX_REFERRALS && KrbAsReqBuilder.this.refCname.getNameType() != 10) {
                    this.enabled = false;
                    return true;
                }
            }
            return false;
        }

        boolean refreshComm() {
            boolean retRefreshComm = this.refreshComm;
            this.refreshComm = false;
            return retRefreshComm;
        }

        boolean isEnabled() {
            return this.enabled;
        }
    }

    private static enum State {
        INIT,
        REQ_OK,
        DESTROYED;

    }
}

