/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.KerberosSecrets;

class SubjectComber {
    private static final boolean DEBUG = Krb5Util.DEBUG;

    private SubjectComber() {
    }

    static <T> T find(Subject subject, String serverPrincipal, String clientPrincipal, Class<T> credClass) {
        return credClass.cast(SubjectComber.findAux(subject, serverPrincipal, clientPrincipal, credClass, true));
    }

    static <T> List<T> findMany(Subject subject, String serverPrincipal, String clientPrincipal, Class<T> credClass) {
        return (List)SubjectComber.findAux(subject, serverPrincipal, clientPrincipal, credClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Object findAux(Subject subject, String serverPrincipal, String clientPrincipal, Class<T> credClass, boolean oneOnly) {
        ArrayList<T> answer;
        if (subject == null) {
            return null;
        }
        ArrayList<T> arrayList = answer = oneOnly ? null : new ArrayList<T>();
        if (credClass == KeyTab.class) {
            for (KeyTab t : subject.getPrivateCredentials(KeyTab.class)) {
                if (serverPrincipal != null && t.isBound()) {
                    KerberosPrincipal name = t.getPrincipal();
                    if (name != null) {
                        if (!serverPrincipal.equals(name.getName())) {
                            continue;
                        }
                    } else {
                        boolean found = false;
                        for (KerberosPrincipal princ : subject.getPrincipals(KerberosPrincipal.class)) {
                            if (!princ.getName().equals(serverPrincipal)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                    }
                }
                if (DEBUG) {
                    System.out.println("Found " + credClass.getSimpleName() + " " + t);
                }
                if (oneOnly) {
                    return t;
                }
                answer.add(credClass.cast(t));
            }
        } else if (credClass == KerberosKey.class) {
            for (KerberosKey t : subject.getPrivateCredentials(KerberosKey.class)) {
                String name = t.getPrincipal().getName();
                if (serverPrincipal != null && !serverPrincipal.equals(name)) continue;
                if (DEBUG) {
                    System.out.println("Found " + credClass.getSimpleName() + " for " + name);
                }
                if (oneOnly) {
                    return t;
                }
                answer.add(credClass.cast(t));
            }
        } else if (credClass == KerberosTicket.class) {
            Set<Object> pcs;
            Set<Object> set = pcs = subject.getPrivateCredentials();
            synchronized (set) {
                Iterator<Object> iterator = pcs.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (!(obj instanceof KerberosTicket)) continue;
                    KerberosTicket ticket = (KerberosTicket)obj;
                    if (DEBUG) {
                        System.out.println("Found ticket for " + ticket.getClient() + " to go to " + ticket.getServer() + " expiring on " + ticket.getEndTime());
                    }
                    if (!ticket.isCurrent()) {
                        if (subject.isReadOnly()) continue;
                        iterator.remove();
                        try {
                            ticket.destroy();
                            if (!DEBUG) continue;
                            System.out.println("Removed and destroyed the expired Ticket \n" + ticket);
                        }
                        catch (DestroyFailedException dfe) {
                            if (!DEBUG) continue;
                            System.out.println("Expired ticket not detroyed successfully. " + dfe);
                        }
                        continue;
                    }
                    KerberosPrincipal serverAlias = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetServerAlias(ticket);
                    if (serverPrincipal != null && !ticket.getServer().getName().equals(serverPrincipal) && (serverAlias == null || !serverPrincipal.equals(serverAlias.getName()))) continue;
                    KerberosPrincipal clientAlias = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetClientAlias(ticket);
                    if (clientPrincipal != null && !clientPrincipal.equals(ticket.getClient().getName()) && (clientAlias == null || !clientPrincipal.equals(clientAlias.getName()))) continue;
                    if (oneOnly) {
                        return ticket;
                    }
                    if (clientPrincipal == null) {
                        clientPrincipal = clientAlias == null ? ticket.getClient().getName() : clientAlias.getName();
                    }
                    if (serverPrincipal == null) {
                        serverPrincipal = serverAlias == null ? ticket.getServer().getName() : serverAlias.getName();
                    }
                    answer.add(credClass.cast(ticket));
                }
            }
        }
        return answer;
    }
}

