/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.ExtendedCopyOption;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.LinkOption;
import java.nio.file.LinkPermission;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.ExecutionException;
import sun.nio.fs.Cancellable;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.WindowsAclFileAttributeView;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributeViews;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;
import sun.nio.fs.WindowsSecurity;

class WindowsFileCopy {
    private WindowsFileCopy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void copy(final WindowsPath source, final WindowsPath target, CopyOption ... options) throws IOException {
        boolean followLinks;
        block52: {
            boolean replaceExisting = false;
            boolean copyAttributes = false;
            followLinks = true;
            boolean interruptible = false;
            for (CopyOption option : options) {
                if (option == StandardCopyOption.REPLACE_EXISTING) {
                    replaceExisting = true;
                    continue;
                }
                if (option == LinkOption.NOFOLLOW_LINKS) {
                    followLinks = false;
                    continue;
                }
                if (option == StandardCopyOption.COPY_ATTRIBUTES) {
                    copyAttributes = true;
                    continue;
                }
                if (option != ExtendedCopyOption.INTERRUPTIBLE) {
                    if (option != null) throw new UnsupportedOperationException("Unsupported copy option");
                    throw new NullPointerException();
                }
                interruptible = true;
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                source.checkRead();
                target.checkWrite();
            }
            WindowsFileAttributes sourceAttrs = null;
            WindowsFileAttributes targetAttrs = null;
            long sourceHandle = 0L;
            try {
                sourceHandle = source.openForReadAttributeAccess(followLinks);
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(source);
            }
            try {
                try {
                    sourceAttrs = WindowsFileAttributes.readAttributes(sourceHandle);
                }
                catch (WindowsException x) {
                    x.rethrowAsIOException(source);
                }
                long targetHandle = 0L;
                try {
                    block48: {
                        targetHandle = target.openForReadAttributeAccess(false);
                        targetAttrs = WindowsFileAttributes.readAttributes(targetHandle);
                        if (!WindowsFileAttributes.isSameFile(sourceAttrs, targetAttrs)) break block48;
                        WindowsNativeDispatcher.CloseHandle(targetHandle);
                        return;
                    }
                    try {
                        if (!replaceExisting) {
                            throw new FileAlreadyExistsException(target.getPathForExceptionMessage());
                        }
                    }
                    finally {
                        WindowsNativeDispatcher.CloseHandle(targetHandle);
                    }
                }
                catch (WindowsException windowsException) {
                    // empty catch block
                }
            }
            finally {
                WindowsNativeDispatcher.CloseHandle(sourceHandle);
            }
            if (sm != null && sourceAttrs.isSymbolicLink()) {
                sm.checkPermission(new LinkPermission("symbolic"));
            }
            final String sourcePath = WindowsFileCopy.asWin32Path(source);
            final String targetPath = WindowsFileCopy.asWin32Path(target);
            if (targetAttrs != null) {
                try {
                    if (targetAttrs.isDirectory() || targetAttrs.isDirectoryLink()) {
                        WindowsNativeDispatcher.RemoveDirectory(targetPath);
                    } else {
                        WindowsNativeDispatcher.DeleteFile(targetPath);
                    }
                }
                catch (WindowsException x) {
                    if (targetAttrs.isDirectory()) {
                        if (x.lastError() == 145) throw new DirectoryNotEmptyException(target.getPathForExceptionMessage());
                        if (x.lastError() == 183) {
                            throw new DirectoryNotEmptyException(target.getPathForExceptionMessage());
                        }
                    }
                    x.rethrowAsIOException(target);
                }
            }
            if (!sourceAttrs.isDirectory() && !sourceAttrs.isDirectoryLink()) {
                int flags;
                int n = flags = source.getFileSystem().supportsLinks() && !followLinks ? 2048 : 0;
                if (interruptible) {
                    Cancellable copyTask = new Cancellable(){

                        @Override
                        public int cancelValue() {
                            return 1;
                        }

                        @Override
                        public void implRun() throws IOException {
                            try {
                                WindowsNativeDispatcher.CopyFileEx(sourcePath, targetPath, flags, this.addressToPollForCancel());
                            }
                            catch (WindowsException x) {
                                x.rethrowAsIOException(source, target);
                            }
                        }
                    };
                    try {
                        Cancellable.runInterruptibly(copyTask);
                    }
                    catch (ExecutionException e) {
                        Throwable t = e.getCause();
                        if (!(t instanceof IOException)) throw new IOException(t);
                        throw (IOException)t;
                    }
                }
                try {
                    WindowsNativeDispatcher.CopyFileEx(sourcePath, targetPath, flags, 0L);
                }
                catch (WindowsException x) {
                    x.rethrowAsIOException(source, target);
                }
                if (!copyAttributes) return;
                try {
                    WindowsFileCopy.copySecurityAttributes(source, target, followLinks);
                    return;
                }
                catch (IOException x) {
                    // empty catch block
                }
                return;
            }
            try {
                if (sourceAttrs.isDirectory()) {
                    WindowsNativeDispatcher.CreateDirectory(targetPath, 0L);
                } else {
                    String linkTarget = WindowsLinkSupport.readLink(source);
                    int flags = 1;
                    WindowsNativeDispatcher.CreateSymbolicLink(targetPath, WindowsPath.addPrefixIfNeeded(linkTarget), flags);
                }
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(target);
            }
            if (!copyAttributes) return;
            WindowsFileAttributeViews.Dos view = WindowsFileAttributeViews.createDosView(target, false);
            try {
                view.setAttributes(sourceAttrs);
            }
            catch (IOException x) {
                if (!sourceAttrs.isDirectory()) break block52;
                try {
                    WindowsNativeDispatcher.RemoveDirectory(targetPath);
                }
                catch (WindowsException windowsException) {
                    // empty catch block
                }
            }
        }
        try {
            WindowsFileCopy.copySecurityAttributes(source, target, followLinks);
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void move(WindowsPath source, WindowsPath target, CopyOption ... options) throws IOException {
        boolean atomicMove = false;
        boolean replaceExisting = false;
        for (CopyOption option : options) {
            if (option == StandardCopyOption.ATOMIC_MOVE) {
                atomicMove = true;
                continue;
            }
            if (option == StandardCopyOption.REPLACE_EXISTING) {
                replaceExisting = true;
                continue;
            }
            if (option == LinkOption.NOFOLLOW_LINKS) continue;
            if (option != null) throw new UnsupportedOperationException("Unsupported copy option");
            throw new NullPointerException();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            source.checkWrite();
            target.checkWrite();
        }
        String sourcePath = WindowsFileCopy.asWin32Path(source);
        String targetPath = WindowsFileCopy.asWin32Path(target);
        if (atomicMove) {
            try {
                WindowsNativeDispatcher.MoveFileEx(sourcePath, targetPath, 1);
                return;
            }
            catch (WindowsException x) {
                if (x.lastError() == 17) {
                    throw new AtomicMoveNotSupportedException(source.getPathForExceptionMessage(), target.getPathForExceptionMessage(), x.errorString());
                }
                x.rethrowAsIOException(source, target);
            }
            return;
        }
        WindowsFileAttributes sourceAttrs = null;
        WindowsFileAttributes targetAttrs = null;
        long sourceHandle = 0L;
        try {
            sourceHandle = source.openForReadAttributeAccess(false);
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(source);
        }
        try {
            try {
                sourceAttrs = WindowsFileAttributes.readAttributes(sourceHandle);
            }
            catch (WindowsException x) {
                x.rethrowAsIOException(source);
            }
            long targetHandle = 0L;
            try {
                block55: {
                    targetHandle = target.openForReadAttributeAccess(false);
                    targetAttrs = WindowsFileAttributes.readAttributes(targetHandle);
                    if (!WindowsFileAttributes.isSameFile(sourceAttrs, targetAttrs)) break block55;
                    WindowsNativeDispatcher.CloseHandle(targetHandle);
                    return;
                }
                try {
                    if (!replaceExisting) {
                        throw new FileAlreadyExistsException(target.getPathForExceptionMessage());
                    }
                }
                finally {
                    WindowsNativeDispatcher.CloseHandle(targetHandle);
                }
            }
            catch (WindowsException windowsException) {
                // empty catch block
            }
        }
        finally {
            WindowsNativeDispatcher.CloseHandle(sourceHandle);
        }
        if (targetAttrs != null) {
            try {
                if (targetAttrs.isDirectory() || targetAttrs.isDirectoryLink()) {
                    WindowsNativeDispatcher.RemoveDirectory(targetPath);
                } else {
                    WindowsNativeDispatcher.DeleteFile(targetPath);
                }
            }
            catch (WindowsException x) {
                if (targetAttrs.isDirectory()) {
                    if (x.lastError() == 145) throw new DirectoryNotEmptyException(target.getPathForExceptionMessage());
                    if (x.lastError() == 183) {
                        throw new DirectoryNotEmptyException(target.getPathForExceptionMessage());
                    }
                }
                x.rethrowAsIOException(target);
            }
        }
        try {
            WindowsNativeDispatcher.MoveFileEx(sourcePath, targetPath, 0);
            return;
        }
        catch (WindowsException x) {
            if (x.lastError() != 17) {
                x.rethrowAsIOException(source, target);
            }
            if (!sourceAttrs.isDirectory() && !sourceAttrs.isDirectoryLink()) {
                try {
                    WindowsNativeDispatcher.MoveFileEx(sourcePath, targetPath, 2);
                }
                catch (WindowsException x2) {
                    x2.rethrowAsIOException(source, target);
                }
                try {
                    WindowsFileCopy.copySecurityAttributes(source, target, false);
                    return;
                }
                catch (IOException x2) {
                    // empty catch block
                }
                return;
            }
            assert (sourceAttrs.isDirectory() || sourceAttrs.isDirectoryLink());
            try {
                if (sourceAttrs.isDirectory()) {
                    WindowsNativeDispatcher.CreateDirectory(targetPath, 0L);
                } else {
                    String linkTarget = WindowsLinkSupport.readLink(source);
                    WindowsNativeDispatcher.CreateSymbolicLink(targetPath, WindowsPath.addPrefixIfNeeded(linkTarget), 1);
                }
            }
            catch (WindowsException x3) {
                x3.rethrowAsIOException(target);
            }
            WindowsFileAttributeViews.Dos view = WindowsFileAttributeViews.createDosView(target, false);
            try {
                view.setAttributes(sourceAttrs);
            }
            catch (IOException x4) {
                try {
                    WindowsNativeDispatcher.RemoveDirectory(targetPath);
                    throw x4;
                }
                catch (WindowsException windowsException) {
                    // empty catch block
                }
                throw x4;
            }
            try {
                WindowsFileCopy.copySecurityAttributes(source, target, false);
            }
            catch (IOException x4) {
                // empty catch block
            }
            try {
                WindowsNativeDispatcher.RemoveDirectory(sourcePath);
                return;
            }
            catch (WindowsException x5) {
                try {
                    WindowsNativeDispatcher.RemoveDirectory(targetPath);
                }
                catch (WindowsException windowsException) {
                    // empty catch block
                }
                if (x5.lastError() == 145) throw new DirectoryNotEmptyException(target.getPathForExceptionMessage());
                if (x5.lastError() == 183) {
                    throw new DirectoryNotEmptyException(target.getPathForExceptionMessage());
                }
                x5.rethrowAsIOException(source);
            }
            return;
        }
    }

    private static String asWin32Path(WindowsPath path) throws IOException {
        try {
            return path.getPathForWin32Calls();
        }
        catch (WindowsException x) {
            x.rethrowAsIOException(path);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySecurityAttributes(WindowsPath source, WindowsPath target, boolean followLinks) throws IOException {
        String path = WindowsLinkSupport.getFinalPath(source, followLinks);
        WindowsSecurity.Privilege priv = WindowsSecurity.enablePrivilege("SeRestorePrivilege");
        try {
            int request = 7;
            NativeBuffer buffer = WindowsAclFileAttributeView.getFileSecurity(path, request);
            try {
                try {
                    WindowsNativeDispatcher.SetFileSecurity(target.getPathForWin32Calls(), request, buffer.address());
                }
                catch (WindowsException x) {
                    x.rethrowAsIOException(target);
                }
            }
            finally {
                buffer.release();
            }
        }
        finally {
            priv.drop();
        }
    }
}

