/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.security.AccessController;
import sun.awt.image.PixelConverter;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.SurfaceDataProxy;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.MaskFill;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.OGLBlitLoops;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLDrawImage;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLMaskBlit;
import sun.java2d.opengl.OGLMaskFill;
import sun.java2d.opengl.OGLPaints;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLRenderer;
import sun.java2d.opengl.OGLSurfaceDataProxy;
import sun.java2d.opengl.OGLTextRenderer;
import sun.java2d.pipe.ParallelogramPipe;
import sun.java2d.pipe.PixelToParallelogramConverter;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.TextPipe;
import sun.java2d.pipe.hw.AccelSurface;
import sun.security.action.GetPropertyAction;

public abstract class OGLSurfaceData
extends SurfaceData
implements AccelSurface {
    public static final int PBUFFER = 2;
    public static final int FBOBJECT = 5;
    public static final int PF_INT_ARGB = 0;
    public static final int PF_INT_ARGB_PRE = 1;
    public static final int PF_INT_RGB = 2;
    public static final int PF_INT_RGBX = 3;
    public static final int PF_INT_BGR = 4;
    public static final int PF_INT_BGRX = 5;
    public static final int PF_USHORT_565_RGB = 6;
    public static final int PF_USHORT_555_RGB = 7;
    public static final int PF_USHORT_555_RGBX = 8;
    public static final int PF_BYTE_GRAY = 9;
    public static final int PF_USHORT_GRAY = 10;
    public static final int PF_3BYTE_BGR = 11;
    private static final String DESC_OPENGL_SURFACE = "OpenGL Surface";
    private static final String DESC_OPENGL_SURFACE_RTT = "OpenGL Surface (render-to-texture)";
    private static final String DESC_OPENGL_TEXTURE = "OpenGL Texture";
    static final SurfaceType OpenGLSurface = SurfaceType.Any.deriveSubType("OpenGL Surface", PixelConverter.ArgbPre.instance);
    static final SurfaceType OpenGLSurfaceRTT = OpenGLSurface.deriveSubType("OpenGL Surface (render-to-texture)");
    static final SurfaceType OpenGLTexture = SurfaceType.Any.deriveSubType("OpenGL Texture");
    private static boolean isFBObjectEnabled;
    private static boolean isLCDShaderEnabled;
    private static boolean isBIOpShaderEnabled;
    private static boolean isGradShaderEnabled;
    private OGLGraphicsConfig graphicsConfig;
    protected int type;
    private int nativeWidth;
    private int nativeHeight;
    protected static OGLRenderer oglRenderPipe;
    protected static PixelToParallelogramConverter oglTxRenderPipe;
    protected static ParallelogramPipe oglAAPgramPipe;
    protected static OGLTextRenderer oglTextPipe;
    protected static OGLDrawImage oglImagePipe;

    protected native boolean initTexture(long var1, boolean var3, boolean var4, boolean var5, int var6, int var7);

    protected native boolean initFBObject(long var1, boolean var3, boolean var4, boolean var5, int var6, int var7);

    protected native boolean initFlipBackbuffer(long var1);

    protected abstract boolean initPbuffer(long var1, long var3, boolean var5, int var6, int var7);

    private native int getTextureTarget(long var1);

    private native int getTextureID(long var1);

    protected OGLSurfaceData(OGLGraphicsConfig gc, ColorModel cm, int type) {
        super(OGLSurfaceData.getCustomSurfaceType(type), cm);
        this.graphicsConfig = gc;
        this.type = type;
        this.setBlitProxyKey(gc.getProxyKey());
    }

    @Override
    public SurfaceDataProxy makeProxyFor(SurfaceData srcData) {
        return OGLSurfaceDataProxy.createProxy(srcData, this.graphicsConfig);
    }

    private static SurfaceType getCustomSurfaceType(int oglType) {
        switch (oglType) {
            case 3: {
                return OpenGLTexture;
            }
            case 5: {
                return OpenGLSurfaceRTT;
            }
        }
        return OpenGLSurface;
    }

    private void initSurfaceNow(int width, int height) {
        boolean isOpaque = this.getTransparency() == 1;
        boolean success = false;
        switch (this.type) {
            case 2: {
                success = this.initPbuffer(this.getNativeOps(), this.graphicsConfig.getNativeConfigInfo(), isOpaque, width, height);
                break;
            }
            case 3: {
                success = this.initTexture(this.getNativeOps(), isOpaque, this.isTexNonPow2Available(), this.isTexRectAvailable(), width, height);
                break;
            }
            case 5: {
                success = this.initFBObject(this.getNativeOps(), isOpaque, this.isTexNonPow2Available(), this.isTexRectAvailable(), width, height);
                break;
            }
            case 4: {
                success = this.initFlipBackbuffer(this.getNativeOps());
                break;
            }
        }
        if (!success) {
            throw new OutOfMemoryError("can't create offscreen surface");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSurface(final int width, final int height) {
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            switch (this.type) {
                case 2: 
                case 3: 
                case 5: {
                    OGLContext.setScratchSurface(this.graphicsConfig);
                    break;
                }
            }
            rq.flushAndInvokeNow(new Runnable(){

                @Override
                public void run() {
                    OGLSurfaceData.this.initSurfaceNow(width, height);
                }
            });
        }
        finally {
            rq.unlock();
        }
    }

    @Override
    public final OGLContext getContext() {
        return this.graphicsConfig.getContext();
    }

    final OGLGraphicsConfig getOGLGraphicsConfig() {
        return this.graphicsConfig;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    public final int getTextureTarget() {
        return this.getTextureTarget(this.getNativeOps());
    }

    public final int getTextureID() {
        return this.getTextureID(this.getNativeOps());
    }

    @Override
    public long getNativeResource(int resType) {
        if (resType == 3) {
            return this.getTextureID();
        }
        return 0L;
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        throw new InternalError("not implemented yet");
    }

    @Override
    public boolean canRenderLCDText(SunGraphics2D sg2d) {
        return this.graphicsConfig.isCapPresent(131072) && sg2d.surfaceData.getTransparency() == 1 && sg2d.paintState <= 0 && (sg2d.compositeState <= 0 || sg2d.compositeState <= 1 && this.canHandleComposite(sg2d.composite));
    }

    private boolean canHandleComposite(Composite c) {
        if (c instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)c;
            return ac.getRule() == 3 && ac.getAlpha() >= 1.0f;
        }
        return false;
    }

    @Override
    public void validatePipe(SunGraphics2D sg2d) {
        TextPipe textpipe;
        boolean validated = false;
        if (sg2d.compositeState <= 0 && sg2d.paintState <= 1 || sg2d.compositeState == 1 && sg2d.paintState <= 1 && ((AlphaComposite)sg2d.composite).getRule() == 3 || sg2d.compositeState == 2 && sg2d.paintState <= 1) {
            textpipe = oglTextPipe;
        } else {
            super.validatePipe(sg2d);
            textpipe = sg2d.textpipe;
            validated = true;
        }
        PixelToParallelogramConverter txPipe = null;
        OGLRenderer nonTxPipe = null;
        if (sg2d.antialiasHint != 2) {
            if (sg2d.paintState <= 1) {
                if (sg2d.compositeState <= 2) {
                    txPipe = oglTxRenderPipe;
                    nonTxPipe = oglRenderPipe;
                }
            } else if (sg2d.compositeState <= 1 && OGLPaints.isValid(sg2d)) {
                txPipe = oglTxRenderPipe;
                nonTxPipe = oglRenderPipe;
            }
        } else if (sg2d.paintState <= 1) {
            if (this.graphicsConfig.isCapPresent(256) && (sg2d.imageComp == CompositeType.SrcOverNoEa || sg2d.imageComp == CompositeType.SrcOver)) {
                if (!validated) {
                    super.validatePipe(sg2d);
                    validated = true;
                }
                PixelToParallelogramConverter aaConverter = new PixelToParallelogramConverter(sg2d.shapepipe, oglAAPgramPipe, 0.125, 0.499, false);
                sg2d.drawpipe = aaConverter;
                sg2d.fillpipe = aaConverter;
                sg2d.shapepipe = aaConverter;
            } else if (sg2d.compositeState == 2) {
                txPipe = oglTxRenderPipe;
                nonTxPipe = oglRenderPipe;
            }
        }
        if (txPipe != null) {
            if (sg2d.transformState >= 3) {
                sg2d.drawpipe = txPipe;
                sg2d.fillpipe = txPipe;
            } else if (sg2d.strokeState != 0) {
                sg2d.drawpipe = txPipe;
                sg2d.fillpipe = nonTxPipe;
            } else {
                sg2d.drawpipe = nonTxPipe;
                sg2d.fillpipe = nonTxPipe;
            }
            sg2d.shapepipe = txPipe;
        } else if (!validated) {
            super.validatePipe(sg2d);
        }
        sg2d.textpipe = textpipe;
        sg2d.imagepipe = oglImagePipe;
    }

    @Override
    protected MaskFill getMaskFill(SunGraphics2D sg2d) {
        if (!(sg2d.paintState <= 1 || OGLPaints.isValid(sg2d) && this.graphicsConfig.isCapPresent(16))) {
            return null;
        }
        return super.getMaskFill(sg2d);
    }

    @Override
    public boolean copyArea(SunGraphics2D sg2d, int x, int y, int w, int h, int dx, int dy) {
        if (sg2d.transformState < 3 && sg2d.compositeState < 2) {
            oglRenderPipe.copyArea(sg2d, x += sg2d.transX, y += sg2d.transY, w, h, dx, dy);
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        this.invalidate();
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            OGLContext.setScratchSurface(this.graphicsConfig);
            RenderBuffer buf = rq.getBuffer();
            rq.ensureCapacityAndAlignment(12, 4);
            buf.putInt(72);
            buf.putLong(this.getNativeOps());
            rq.flushNow();
        }
        finally {
            rq.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void dispose(long pData, OGLGraphicsConfig gc) {
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            OGLContext.setScratchSurface(gc);
            RenderBuffer buf = rq.getBuffer();
            rq.ensureCapacityAndAlignment(12, 4);
            buf.putInt(73);
            buf.putLong(pData);
            rq.flushNow();
        }
        finally {
            rq.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void swapBuffers(long window) {
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            RenderBuffer buf = rq.getBuffer();
            rq.ensureCapacityAndAlignment(12, 4);
            buf.putInt(80);
            buf.putLong(window);
            rq.flushNow();
        }
        finally {
            rq.unlock();
        }
    }

    boolean isTexNonPow2Available() {
        return this.graphicsConfig.isCapPresent(32);
    }

    boolean isTexRectAvailable() {
        return this.graphicsConfig.isCapPresent(0x100000);
    }

    @Override
    public Rectangle getNativeBounds() {
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            Rectangle rectangle = new Rectangle(this.nativeWidth, this.nativeHeight);
            return rectangle;
        }
        finally {
            rq.unlock();
        }
    }

    boolean isOnScreen() {
        return this.getType() == 1;
    }

    static {
        if (!GraphicsEnvironment.isHeadless()) {
            String fbo = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.opengl.fbobject"));
            isFBObjectEnabled = !"false".equals(fbo);
            String lcd = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.opengl.lcdshader"));
            isLCDShaderEnabled = !"false".equals(lcd);
            String biop = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.opengl.biopshader"));
            isBIOpShaderEnabled = !"false".equals(biop);
            String grad = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.opengl.gradshader"));
            isGradShaderEnabled = !"false".equals(grad);
            OGLRenderQueue rq = OGLRenderQueue.getInstance();
            oglImagePipe = new OGLDrawImage();
            oglTextPipe = new OGLTextRenderer(rq);
            oglRenderPipe = new OGLRenderer(rq);
            if (GraphicsPrimitive.tracingEnabled()) {
                oglTextPipe = oglTextPipe.traceWrap();
            }
            oglAAPgramPipe = oglRenderPipe.getAAParallelogramPipe();
            oglTxRenderPipe = new PixelToParallelogramConverter(oglRenderPipe, oglRenderPipe, 1.0, 0.25, true);
            OGLBlitLoops.register();
            OGLMaskFill.register();
            OGLMaskBlit.register();
        }
    }
}

