/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin;

import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import sun.awt.geom.PathConsumer2D;

final class TransformingPathConsumer2D {
    private final Path2DWrapper wp_Path2DWrapper = new Path2DWrapper();
    private final TranslateFilter tx_TranslateFilter = new TranslateFilter();
    private final DeltaScaleFilter tx_DeltaScaleFilter = new DeltaScaleFilter();
    private final ScaleFilter tx_ScaleFilter = new ScaleFilter();
    private final DeltaTransformFilter tx_DeltaTransformFilter = new DeltaTransformFilter();
    private final TransformFilter tx_TransformFilter = new TransformFilter();
    private final DeltaScaleFilter dt_DeltaScaleFilter = new DeltaScaleFilter();
    private final DeltaTransformFilter dt_DeltaTransformFilter = new DeltaTransformFilter();
    private final DeltaScaleFilter iv_DeltaScaleFilter = new DeltaScaleFilter();
    private final DeltaTransformFilter iv_DeltaTransformFilter = new DeltaTransformFilter();

    TransformingPathConsumer2D() {
    }

    PathConsumer2D wrapPath2d(Path2D.Float p2d) {
        return this.wp_Path2DWrapper.init(p2d);
    }

    PathConsumer2D transformConsumer(PathConsumer2D out, AffineTransform at) {
        if (at == null) {
            return out;
        }
        float mxx = (float)at.getScaleX();
        float mxy = (float)at.getShearX();
        float mxt = (float)at.getTranslateX();
        float myx = (float)at.getShearY();
        float myy = (float)at.getScaleY();
        float myt = (float)at.getTranslateY();
        if (mxy == 0.0f && myx == 0.0f) {
            if (mxx == 1.0f && myy == 1.0f) {
                if (mxt == 0.0f && myt == 0.0f) {
                    return out;
                }
                return this.tx_TranslateFilter.init(out, mxt, myt);
            }
            if (mxt == 0.0f && myt == 0.0f) {
                return this.tx_DeltaScaleFilter.init(out, mxx, myy);
            }
            return this.tx_ScaleFilter.init(out, mxx, myy, mxt, myt);
        }
        if (mxt == 0.0f && myt == 0.0f) {
            return this.tx_DeltaTransformFilter.init(out, mxx, mxy, myx, myy);
        }
        return this.tx_TransformFilter.init(out, mxx, mxy, mxt, myx, myy, myt);
    }

    PathConsumer2D deltaTransformConsumer(PathConsumer2D out, AffineTransform at) {
        if (at == null) {
            return out;
        }
        float mxx = (float)at.getScaleX();
        float mxy = (float)at.getShearX();
        float myx = (float)at.getShearY();
        float myy = (float)at.getScaleY();
        if (mxy == 0.0f && myx == 0.0f) {
            if (mxx == 1.0f && myy == 1.0f) {
                return out;
            }
            return this.dt_DeltaScaleFilter.init(out, mxx, myy);
        }
        return this.dt_DeltaTransformFilter.init(out, mxx, mxy, myx, myy);
    }

    PathConsumer2D inverseDeltaTransformConsumer(PathConsumer2D out, AffineTransform at) {
        if (at == null) {
            return out;
        }
        float mxx = (float)at.getScaleX();
        float mxy = (float)at.getShearX();
        float myx = (float)at.getShearY();
        float myy = (float)at.getScaleY();
        if (mxy == 0.0f && myx == 0.0f) {
            if (mxx == 1.0f && myy == 1.0f) {
                return out;
            }
            return this.iv_DeltaScaleFilter.init(out, 1.0f / mxx, 1.0f / myy);
        }
        float det = mxx * myy - mxy * myx;
        return this.iv_DeltaTransformFilter.init(out, myy / det, -mxy / det, -myx / det, mxx / det);
    }

    static final class Path2DWrapper
    implements PathConsumer2D {
        private Path2D.Float p2d;

        Path2DWrapper() {
        }

        Path2DWrapper init(Path2D.Float p2d) {
            this.p2d = p2d;
            return this;
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.p2d.moveTo(x0, y0);
        }

        @Override
        public void lineTo(float x1, float y1) {
            this.p2d.lineTo(x1, y1);
        }

        @Override
        public void closePath() {
            this.p2d.closePath();
        }

        @Override
        public void pathDone() {
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.p2d.curveTo(x1, y1, x2, y2, x3, y3);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.p2d.quadTo(x1, y1, x2, y2);
        }

        @Override
        public long getNativeConsumer() {
            throw new InternalError("Not using a native peer");
        }
    }

    static final class DeltaTransformFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float mxx;
        private float mxy;
        private float myx;
        private float myy;

        DeltaTransformFilter() {
        }

        DeltaTransformFilter init(PathConsumer2D out, float mxx, float mxy, float myx, float myy) {
            this.out = out;
            this.mxx = mxx;
            this.mxy = mxy;
            this.myx = myx;
            this.myy = myy;
            return this;
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.out.moveTo(x0 * this.mxx + y0 * this.mxy, x0 * this.myx + y0 * this.myy);
        }

        @Override
        public void lineTo(float x1, float y1) {
            this.out.lineTo(x1 * this.mxx + y1 * this.mxy, x1 * this.myx + y1 * this.myy);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.out.quadTo(x1 * this.mxx + y1 * this.mxy, x1 * this.myx + y1 * this.myy, x2 * this.mxx + y2 * this.mxy, x2 * this.myx + y2 * this.myy);
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.out.curveTo(x1 * this.mxx + y1 * this.mxy, x1 * this.myx + y1 * this.myy, x2 * this.mxx + y2 * this.mxy, x2 * this.myx + y2 * this.myy, x3 * this.mxx + y3 * this.mxy, x3 * this.myx + y3 * this.myy);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }

    static final class DeltaScaleFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float sx;
        private float sy;

        DeltaScaleFilter() {
        }

        DeltaScaleFilter init(PathConsumer2D out, float mxx, float myy) {
            this.out = out;
            this.sx = mxx;
            this.sy = myy;
            return this;
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.out.moveTo(x0 * this.sx, y0 * this.sy);
        }

        @Override
        public void lineTo(float x1, float y1) {
            this.out.lineTo(x1 * this.sx, y1 * this.sy);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.out.quadTo(x1 * this.sx, y1 * this.sy, x2 * this.sx, y2 * this.sy);
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.out.curveTo(x1 * this.sx, y1 * this.sy, x2 * this.sx, y2 * this.sy, x3 * this.sx, y3 * this.sy);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }

    static final class TransformFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float mxx;
        private float mxy;
        private float mxt;
        private float myx;
        private float myy;
        private float myt;

        TransformFilter() {
        }

        TransformFilter init(PathConsumer2D out, float mxx, float mxy, float mxt, float myx, float myy, float myt) {
            this.out = out;
            this.mxx = mxx;
            this.mxy = mxy;
            this.mxt = mxt;
            this.myx = myx;
            this.myy = myy;
            this.myt = myt;
            return this;
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.out.moveTo(x0 * this.mxx + y0 * this.mxy + this.mxt, x0 * this.myx + y0 * this.myy + this.myt);
        }

        @Override
        public void lineTo(float x1, float y1) {
            this.out.lineTo(x1 * this.mxx + y1 * this.mxy + this.mxt, x1 * this.myx + y1 * this.myy + this.myt);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.out.quadTo(x1 * this.mxx + y1 * this.mxy + this.mxt, x1 * this.myx + y1 * this.myy + this.myt, x2 * this.mxx + y2 * this.mxy + this.mxt, x2 * this.myx + y2 * this.myy + this.myt);
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.out.curveTo(x1 * this.mxx + y1 * this.mxy + this.mxt, x1 * this.myx + y1 * this.myy + this.myt, x2 * this.mxx + y2 * this.mxy + this.mxt, x2 * this.myx + y2 * this.myy + this.myt, x3 * this.mxx + y3 * this.mxy + this.mxt, x3 * this.myx + y3 * this.myy + this.myt);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }

    static final class ScaleFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float sx;
        private float sy;
        private float tx;
        private float ty;

        ScaleFilter() {
        }

        ScaleFilter init(PathConsumer2D out, float sx, float sy, float tx, float ty) {
            this.out = out;
            this.sx = sx;
            this.sy = sy;
            this.tx = tx;
            this.ty = ty;
            return this;
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.out.moveTo(x0 * this.sx + this.tx, y0 * this.sy + this.ty);
        }

        @Override
        public void lineTo(float x1, float y1) {
            this.out.lineTo(x1 * this.sx + this.tx, y1 * this.sy + this.ty);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.out.quadTo(x1 * this.sx + this.tx, y1 * this.sy + this.ty, x2 * this.sx + this.tx, y2 * this.sy + this.ty);
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.out.curveTo(x1 * this.sx + this.tx, y1 * this.sy + this.ty, x2 * this.sx + this.tx, y2 * this.sy + this.ty, x3 * this.sx + this.tx, y3 * this.sy + this.ty);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }

    static final class TranslateFilter
    implements PathConsumer2D {
        private PathConsumer2D out;
        private float tx;
        private float ty;

        TranslateFilter() {
        }

        TranslateFilter init(PathConsumer2D out, float tx, float ty) {
            this.out = out;
            this.tx = tx;
            this.ty = ty;
            return this;
        }

        @Override
        public void moveTo(float x0, float y0) {
            this.out.moveTo(x0 + this.tx, y0 + this.ty);
        }

        @Override
        public void lineTo(float x1, float y1) {
            this.out.lineTo(x1 + this.tx, y1 + this.ty);
        }

        @Override
        public void quadTo(float x1, float y1, float x2, float y2) {
            this.out.quadTo(x1 + this.tx, y1 + this.ty, x2 + this.tx, y2 + this.ty);
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.out.curveTo(x1 + this.tx, y1 + this.ty, x2 + this.tx, y2 + this.ty, x3 + this.tx, y3 + this.ty);
        }

        @Override
        public void closePath() {
            this.out.closePath();
        }

        @Override
        public void pathDone() {
            this.out.pathDone();
        }

        @Override
        public long getNativeConsumer() {
            return 0L;
        }
    }
}

