/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.DatagramSocketImpl;
import java.net.DualStackPlainDatagramSocketImpl;
import java.net.SocketException;
import java.net.TwoStacksPlainDatagramSocketImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.security.action.GetPropertyAction;

class DefaultDatagramSocketImplFactory {
    private static final Class<?> prefixImplClass;
    private static float version;
    private static boolean preferIPv4Stack;
    private static final boolean useDualStackImpl;
    private static String exclBindProp;
    private static final boolean exclusiveBind;

    DefaultDatagramSocketImplFactory() {
    }

    static DatagramSocketImpl createDatagramSocketImpl(boolean isMulticast) throws SocketException {
        if (prefixImplClass != null) {
            try {
                return (DatagramSocketImpl)prefixImplClass.newInstance();
            }
            catch (Exception e) {
                throw new SocketException("can't instantiate DatagramSocketImpl");
            }
        }
        if (useDualStackImpl && !isMulticast) {
            return new DualStackPlainDatagramSocketImpl(exclusiveBind);
        }
        return new TwoStacksPlainDatagramSocketImpl(exclusiveBind && !isMulticast);
    }

    static {
        preferIPv4Stack = false;
        Class<?> prefixImplClassLocal = null;
        boolean useDualStackImplLocal = false;
        boolean exclusiveBindLocal = true;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                block2: {
                    version = 0.0f;
                    try {
                        version = Float.parseFloat(System.getProperties().getProperty("os.version"));
                        preferIPv4Stack = Boolean.parseBoolean(System.getProperties().getProperty("java.net.preferIPv4Stack"));
                        exclBindProp = System.getProperty("sun.net.useExclusiveBind");
                    }
                    catch (NumberFormatException e) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)e);
                    }
                }
                return null;
            }
        });
        if ((double)version >= 6.0 && !preferIPv4Stack) {
            useDualStackImplLocal = true;
        }
        if (exclBindProp != null) {
            exclusiveBindLocal = exclBindProp.length() == 0 ? true : Boolean.parseBoolean(exclBindProp);
        } else if ((double)version < 6.0) {
            exclusiveBindLocal = false;
        }
        String prefix = null;
        try {
            prefix = AccessController.doPrivileged(new GetPropertyAction("impl.prefix", null));
            if (prefix != null) {
                prefixImplClassLocal = Class.forName("java.net." + prefix + "DatagramSocketImpl");
            }
        }
        catch (Exception e) {
            System.err.println("Can't find class: java.net." + prefix + "DatagramSocketImpl: check impl.prefix property");
        }
        prefixImplClass = prefixImplClassLocal;
        useDualStackImpl = useDualStackImplLocal;
        exclusiveBind = exclusiveBindLocal;
    }
}

