/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

class Shutdown {
    private static final int RUNNING = 0;
    private static final int HOOKS = 1;
    private static final int FINALIZERS = 2;
    private static int state = 0;
    private static boolean runFinalizersOnExit = false;
    private static final int MAX_SYSTEM_HOOKS = 10;
    private static final Runnable[] hooks = new Runnable[10];
    private static int currentRunningHook = 0;
    private static Object lock = new Lock();
    private static Object haltLock = new Lock();

    Shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setRunFinalizersOnExit(boolean run) {
        Object object = lock;
        synchronized (object) {
            runFinalizersOnExit = run;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(int slot, boolean registerShutdownInProgress, Runnable hook) {
        Object object = lock;
        synchronized (object) {
            if (hooks[slot] != null) {
                throw new InternalError("Shutdown hook at slot " + slot + " already registered");
            }
            if (!registerShutdownInProgress ? state > 0 : state > 1 || state == 1 && slot <= currentRunningHook) {
                throw new IllegalStateException("Shutdown in progress");
            }
            Shutdown.hooks[slot] = hook;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runHooks() {
        for (int i = 0; i < 10; ++i) {
            try {
                Runnable hook;
                Object object = lock;
                synchronized (object) {
                    currentRunningHook = i;
                    hook = hooks[i];
                }
                if (hook == null) continue;
                hook.run();
                continue;
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) continue;
                ThreadDeath td = (ThreadDeath)t;
                throw td;
            }
        }
    }

    static native void beforeHalt();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void halt(int status) {
        Object object = haltLock;
        synchronized (object) {
            Shutdown.halt0(status);
        }
    }

    static native void halt0(int var0);

    private static native void runAllFinalizers();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sequence() {
        boolean rfoe;
        Object object = lock;
        synchronized (object) {
            if (state != 1) {
                return;
            }
        }
        Shutdown.runHooks();
        Object object2 = lock;
        synchronized (object2) {
            state = 2;
            rfoe = runFinalizersOnExit;
        }
        if (rfoe) {
            Shutdown.runAllFinalizers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void exit(int status) {
        boolean runMoreFinalizers = false;
        Class<Shutdown> clazz = lock;
        synchronized (clazz) {
            if (status != 0) {
                runFinalizersOnExit = false;
            }
            switch (state) {
                case 0: {
                    state = 1;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    if (status != 0) {
                        Shutdown.halt(status);
                        break;
                    }
                    runMoreFinalizers = runFinalizersOnExit;
                }
            }
        }
        if (runMoreFinalizers) {
            Shutdown.runAllFinalizers();
            Shutdown.halt(status);
        }
        clazz = Shutdown.class;
        synchronized (Shutdown.class) {
            Shutdown.beforeHalt();
            Shutdown.sequence();
            Shutdown.halt(status);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdown() {
        Class<Shutdown> clazz = lock;
        synchronized (clazz) {
            switch (state) {
                case 0: {
                    state = 1;
                    break;
                }
            }
        }
        clazz = Shutdown.class;
        synchronized (Shutdown.class) {
            Shutdown.sequence();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

