/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IgnoreAllErrorHandler
implements ErrorHandler {
    private static final Logger log = Logger.getLogger(IgnoreAllErrorHandler.class.getName());
    private static final boolean warnOnExceptions = IgnoreAllErrorHandler.getProperty("com.sun.org.apache.xml.internal.security.test.warn.on.exceptions");
    private static final boolean throwExceptions = IgnoreAllErrorHandler.getProperty("com.sun.org.apache.xml.internal.security.test.throw.exceptions");

    private static boolean getProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(name);
            }
        });
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        if (warnOnExceptions) {
            log.log(Level.WARNING, "", ex);
        }
        if (throwExceptions) {
            throw ex;
        }
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        if (warnOnExceptions) {
            log.log(Level.SEVERE, "", ex);
        }
        if (throwExceptions) {
            throw ex;
        }
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        if (warnOnExceptions) {
            log.log(Level.WARNING, "", ex);
        }
        if (throwExceptions) {
            throw ex;
        }
    }
}

