/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.serve.center.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.event.center.service.EventLevelService;
import com.zkteco.zkbiosecurity.event.center.service.EventTypeService;
import com.zkteco.zkbiosecurity.event.center.vo.EventLevelItem;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=335)
public class ServeCenterInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ServeCenterInit.class);
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private EventLevelService eventLevelService;
    @Autowired
    private EventTypeService eventTypeService;

    public void run(String ... args) throws Exception {
        try {
            boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("ServeCenterInit");
            if (!alreadyInit) {
                this.initAuthPermission();
                this.initAppPushAuthPermission();
                this.initHybridCloudPushParams();
                this.initEventLevel();
                this.initEventParams();
                this.initUpgradeVersion();
                this.baseSysParamService.setAlreadyInitModule("ServeCenterInit");
            }
            this.eventTypeService.clearEventType();
        }
        catch (Exception e) {
            log.error("ServeCenterInit error", (Throwable)e);
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = null;
        AuthPermissionItem parentMenuItem = null;
        AuthPermissionItem childMenuItem = null;
        AuthPermissionItem buttonMenuItem = null;
        systemItem = new AuthPermissionItem("MonitorCenter", "monitor_center_module", "monitor:center", "system", "true", Integer.valueOf(10000));
        systemItem = this.authPermissionService.initData(systemItem);
        parentMenuItem = new AuthPermissionItem("DeviceCenterInfo", "device_center_info", "device:center:info", "menu", "true", Integer.valueOf(1));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("device.png");
        parentMenuItem.setImgHover("device_over.png");
        parentMenuItem = this.authPermissionService.initData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("DeviceCenterManager", "common_dev_entity", "device:center:manager", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("deviceCenterManager.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("DeviceCenterManagerRefresh", "common_op_refresh", "device:center:manager:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("DeviceCenterManagerEdit", "device_manager_subset", "device:center:manager:edit", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("EventCenter", "event_center_manager", "event:center:manager", "menu", "true", Integer.valueOf(2));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("event.png");
        parentMenuItem.setImgHover("event_over.png");
        parentMenuItem = this.authPermissionService.initData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("EventType", "event_center_type", "event:center:type", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("eventType.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("EventTypeRefresh", "common_op_refresh", "event:center:type:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("EventTypeEdit", "event_type_edit", "event:center:type:edit", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("EventTypeDel", "common_op_del", "event:center:type:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("EventRecord", "event_center_record", "event:center:record", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("eventRecord.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("EventRecordRefresh", "common_op_refresh", "event:center:record:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("EventRecordEdit", "base_remote_confirm", "event:center:record:edit", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("EventRecordExport", "common_op_export", "event:center:record:export", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("MessageCenter", "message_center_manager", "message:center:manager", "menu", "true", Integer.valueOf(3));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("message.png");
        parentMenuItem.setImgHover("message_over.png");
        parentMenuItem = this.authPermissionService.initData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("MessageRecord", "message_center_record", "message:center:record", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("messageRecord.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("MessageRecordRefresh", "common_op_refresh", "message:center:record:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MessageRecordDetail", "system_detail", "message:center:record:Detail", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("MapCenterManager", "map_leftMenu_map", "map:config:manager", "menu", "true", Integer.valueOf(3));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("map.png");
        parentMenuItem.setImgHover("map_over.png");
        parentMenuItem = this.authPermissionService.initData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("MapRTMonitorManager", "map_leftMenu_mapRTMonitor", "map:rtMonitor", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("mapMonitoring.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapPersonLocus", "map_personLocus", "map:rtMonitor:personLocus", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapBulkOperations", "map_bulkOperations", "map:rtMonitor:bulkOperations", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapMonitorRefresh", "common_op_refresh", "map:rtMonitor:refresh", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapMonitorBackUpper", "map_backUpper", "map:rtMonitor:backUpper", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("MapConfigeManager", "map_leftMenu_mapConfig", "map:config", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("mapBaseMap.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapRefresh", "common_op_refresh", "map:config:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapAdd", "common_op_new", "map:config:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapEdit", "common_op_edit", "map:config:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapDel", "common_op_del", "map:config:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapSaveMapPos", "map_coordinate_adjusting", "map:config:saveMapPos", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapAddDoorToMap", "map_addDoor", "map:config:addDoorToMap", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapAddChannelToMap", "map_addChannel", "map:config:addChannelToMap", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapDelEntity", "base_map_delEntity", "map:config:delEntity", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapAddMapToMap", "map_addMap", "map:config:addMapToMap", "button", "true", Integer.valueOf(9));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapBackUpper", "map_backUpper", "map:config:backUpper", "button", "true", Integer.valueOf(10));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapModifyView", "map_modify_view", "map:config:modifyView", "button", "true", Integer.valueOf(11));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapAddDefendAreaToMap", "map_addDefendArea", "map:config:addDefendAreaToMap", "button", "true", Integer.valueOf(12));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapModifyIcon", "base_map_modifyIcon", "map:config:modifyIcon", "button", "true", Integer.valueOf(13));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapAddPsgGateToMap", "map_addPsgGate", "map:config:addPsgGateToMap", "button", "true", Integer.valueOf(14));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapAddAttDeviceToMap", "map_addAttDevice", "map:config:addAttDeviceToMap", "button", "true", Integer.valueOf(15));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapAddInsDeviceToMap", "map_addInsDevice", "map:config:addInsDeviceToMap", "button", "true", Integer.valueOf(16));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapAddParkDeviceToMap", "map_addParkDevice", "map:config:addParkDeviceToMap", "button", "true", Integer.valueOf(17));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("MapAddEsdcDeviceToMap", "map_addEsdcDevice", "map:config:addEsdcDeviceToMap", "button", "true", Integer.valueOf(18));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.initData(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("PushCenter", "pushCenter_module", "pushCenter", "menu", "true", Integer.valueOf(5));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("pushCenter.png");
        parentMenuItem.setImgHover("pushCenter_over.png");
        parentMenuItem = this.authPermissionService.initData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("PushCenterSetting", "pushCenter_setting", "pushCenter:setting", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("pushCenterSetting.do");
        this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("PushCenterSettingRefresh", "common_op_refresh", "pushCenter:setting:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("PushCenterSettingAdd", "common_op_new", "pushCenter:setting:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("PushCenterSettingDel", "common_op_del", "pushCenter:setting:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("PushCenterSettingEdit", "common_op_edit", "pushCenter:setting:edit", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("PushCenterRecord", "pushCenter_record_fail", "pushCenter:record", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("pushCenterRecord.do");
        this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("PushCenterRecordRefresh", "common_op_refresh", "pushCenter:record:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("PushCenterRecordDel", "common_op_del", "pushCenter:record:del", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("PushCenterRecordRetry", "pushCenter_record_retry", "pushCenter:record:retry", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("PushCenterRecordManual", "pushCenter_record_manual", "pushCenter:record:manual", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
    }

    private void initAppPushAuthPermission() {
        AuthPermissionItem subMenuItem1;
        AuthPermissionItem systemItem = this.authPermissionService.getItemByCode("System");
        if (systemItem == null) {
            systemItem = new AuthPermissionItem("System", "system_module", "system", "system", "true", Integer.valueOf(999));
            systemItem = this.authPermissionService.initData(systemItem);
        }
        if ((subMenuItem1 = this.authPermissionService.getItemByCode("SystemBaseManager")) == null) {
            subMenuItem1 = new AuthPermissionItem("SystemBaseManager", "system_module_systemManage", "system:system:manager", "menu", "true", Integer.valueOf(1));
            subMenuItem1.setParentId(systemItem.getId());
            subMenuItem1.setImg("base_basicManagement.png");
            subMenuItem1.setImgHover("base_basicManagement_over.png");
            subMenuItem1 = this.authPermissionService.initData(subMenuItem1);
        }
        AuthPermissionItem subMenuItem = new AuthPermissionItem("HybridCloudPushManagement", "hybridCloud_webhook_setting", "hybridCloudPush:management", "menu", "true", Integer.valueOf(11));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("hybridCloudPush.do");
        subMenuItem = this.authPermissionService.initData(subMenuItem);
    }

    private void initEventLevel() {
        this.saveEventLevel(I18nUtil.i18nCode((String)"event_level_emergency", (Object[])new Object[0]), "3");
        this.saveEventLevel(I18nUtil.i18nCode((String)"event_level_warning", (Object[])new Object[0]), "2");
        this.saveEventLevel(I18nUtil.i18nCode((String)"event_level_common", (Object[])new Object[0]), "1");
        this.saveEventLevel(I18nUtil.i18nCode((String)"event_level_normal", (Object[])new Object[0]), "0");
    }

    private void saveEventLevel(String levelName, String levelVal) {
        EventLevelItem item = this.eventLevelService.getItemByLevelVal(levelVal);
        if (Objects.isNull(item)) {
            this.eventLevelService.saveItem(new EventLevelItem(levelName, levelVal, true));
        }
    }

    private void initEventParams() {
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"6");
        values.put("runtime", (Object)"01:00:00");
        BaseSysParamItem item = new BaseSysParamItem("eventReportDataClean", values.toString(), "base_dataClean_eventTrans");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("38face.serverUrl", "http://127.0.0.1:8066/api/ZKComparison", "ZK Live face 3.8 server");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("aiCenter.aiServerType", "0", "ai server type");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("aiCenter.aiServerUrl", "http://127.0.0.1:8066", "ai server url");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("aiCenter.aiBodyServerType", "2", "ai body server type");
        this.baseSysParamService.initData(item);
        item = new BaseSysParamItem("aiCenter.aiBodyServerUrl", "http://127.0.0.1:29000", "ai body server url");
        this.baseSysParamService.initData(item);
    }

    private void initHybridCloudPushParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("hybridCloud.webhook.enable", "0", "hybridCloud webhook enable"));
        this.baseSysParamService.initData(new BaseSysParamItem("hybridCloud.serverUrl", "http://127.0.0.1:6001", "hybridCloud serverUrl"));
        this.baseSysParamService.initData(new BaseSysParamItem("hybridCloud.token", "", "hybridCloud token"));
        this.baseSysParamService.initData(new BaseSysParamItem("hybridCloud.signature.type", "0", "hybridCloud signature type"));
        this.baseSysParamService.initData(new BaseSysParamItem("hybridCloud.pushEventRecord.enable", "0", "hybridCloud pushEventRecord enable"));
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"serve-center");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("ServeUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("ServeUpgradeVersion", curVersion, "Serve Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

