/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Locale;
import sun.security.mscapi.CKey;
import sun.security.mscapi.CPrivateKey;
import sun.security.mscapi.CPublicKey;
import sun.security.rsa.RSAKeyFactory;
import sun.security.util.ECUtil;
import sun.security.util.KeyUtil;

abstract class CSignature
extends SignatureSpi {
    protected String keyAlgorithm;
    protected MessageDigest messageDigest;
    protected String messageDigestAlgorithm;
    protected boolean needsReset;
    protected CPrivateKey privateKey = null;
    protected CPublicKey publicKey = null;

    CSignature(String keyName, String digestName) {
        this.keyAlgorithm = keyName;
        if (digestName != null) {
            try {
                this.messageDigest = MessageDigest.getInstance(digestName);
                this.messageDigestAlgorithm = this.messageDigest.getAlgorithm();
            }
            catch (NoSuchAlgorithmException e) {
                throw new ProviderException(e);
            }
        } else {
            this.messageDigest = null;
            this.messageDigestAlgorithm = null;
        }
        this.needsReset = false;
    }

    static native byte[] signCngHash(int var0, byte[] var1, int var2, int var3, String var4, long var5, long var7) throws SignatureException;

    private static native boolean verifyCngSignedHash(int var0, byte[] var1, int var2, byte[] var3, int var4, int var5, String var6, long var7, long var9) throws SignatureException;

    protected void resetDigest() {
        if (this.needsReset) {
            if (this.messageDigest != null) {
                this.messageDigest.reset();
            }
            this.needsReset = false;
        }
    }

    protected byte[] getDigestValue() throws SignatureException {
        this.needsReset = false;
        return this.messageDigest.digest();
    }

    protected void setDigestName(String name) {
        this.messageDigestAlgorithm = name;
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.messageDigest.update(b);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.messageDigest.update(b, off, len);
        this.needsReset = true;
    }

    @Override
    protected void engineUpdate(ByteBuffer input) {
        this.messageDigest.update(input);
        this.needsReset = true;
    }

    private static byte[] convertEndianArray(byte[] byteArray) {
        if (byteArray == null || byteArray.length == 0) {
            return byteArray;
        }
        byte[] retval = new byte[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            retval[i] = byteArray[byteArray.length - i - 1];
        }
        return retval;
    }

    private static native byte[] signHash(boolean var0, byte[] var1, int var2, String var3, long var4, long var6) throws SignatureException;

    private static native boolean verifySignedHash(byte[] var0, int var1, String var2, byte[] var3, int var4, long var5, long var7) throws SignatureException;

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("No parameter accepted");
        }
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException("Parameter not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    static native CPublicKey importPublicKey(String var0, byte[] var1, int var2) throws KeyStoreException;

    static native CPublicKey importECPublicKey(String var0, byte[] var1, int var2) throws KeyStoreException;

    public static final class PSS
    extends RSA {
        private PSSParameterSpec pssParams = null;
        private Signature fallbackSignature;

        public PSS() {
            super(null);
        }

        @Override
        protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
            super.engineInitSign(key);
            this.fallbackSignature = null;
        }

        @Override
        protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
            if (key == null) {
                throw new InvalidKeyException("Key cannot be null");
            }
            if (!(key instanceof RSAPublicKey)) {
                throw new InvalidKeyException("Key type not supported: " + key.getClass());
            }
            this.privateKey = null;
            if (key instanceof CPublicKey) {
                this.fallbackSignature = null;
                this.publicKey = (CPublicKey)key;
            } else {
                if (this.fallbackSignature == null) {
                    try {
                        this.fallbackSignature = Signature.getInstance("RSASSA-PSS", "SunRsaSign");
                    }
                    catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                        throw new InvalidKeyException("Invalid key", e);
                    }
                }
                this.fallbackSignature.initVerify(key);
                if (this.pssParams != null) {
                    try {
                        this.fallbackSignature.setParameter(this.pssParams);
                    }
                    catch (InvalidAlgorithmParameterException e) {
                        throw new InvalidKeyException("Invalid params", e);
                    }
                }
                this.publicKey = null;
            }
            this.resetDigest();
        }

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            this.ensureInit();
            if (this.fallbackSignature != null) {
                this.fallbackSignature.update(b);
            } else {
                this.messageDigest.update(b);
            }
            this.needsReset = true;
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            this.ensureInit();
            if (this.fallbackSignature != null) {
                this.fallbackSignature.update(b, off, len);
            } else {
                this.messageDigest.update(b, off, len);
            }
            this.needsReset = true;
        }

        @Override
        protected void engineUpdate(ByteBuffer input) {
            try {
                this.ensureInit();
            }
            catch (SignatureException se) {
                throw new RuntimeException(se.getMessage());
            }
            if (this.fallbackSignature != null) {
                try {
                    this.fallbackSignature.update(input);
                }
                catch (SignatureException se) {
                    throw new RuntimeException(se.getMessage());
                }
            } else {
                this.messageDigest.update(input);
            }
            this.needsReset = true;
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            this.ensureInit();
            byte[] hash = this.getDigestValue();
            return PSS.signCngHash(2, hash, hash.length, this.pssParams.getSaltLength(), ((MGF1ParameterSpec)this.pssParams.getMGFParameters()).getDigestAlgorithm(), this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
        }

        @Override
        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            this.ensureInit();
            if (this.fallbackSignature != null) {
                this.needsReset = false;
                return this.fallbackSignature.verify(sigBytes);
            }
            byte[] hash = this.getDigestValue();
            return CSignature.verifyCngSignedHash(2, hash, hash.length, sigBytes, sigBytes.length, this.pssParams.getSaltLength(), ((MGF1ParameterSpec)this.pssParams.getMGFParameters()).getDigestAlgorithm(), this.publicKey.getHCryptProvider(), this.publicKey.getHCryptKey());
        }

        @Override
        protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (this.needsReset) {
                throw new ProviderException("Cannot set parameters during operations");
            }
            this.pssParams = this.validateSigParams(params);
            if (this.fallbackSignature != null) {
                this.fallbackSignature.setParameter(params);
            }
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            AlgorithmParameters ap = null;
            if (this.pssParams != null) {
                try {
                    ap = AlgorithmParameters.getInstance("RSASSA-PSS");
                    ap.init(this.pssParams);
                }
                catch (GeneralSecurityException gse) {
                    throw new ProviderException(gse.getMessage());
                }
            }
            return ap;
        }

        private void ensureInit() throws SignatureException {
            if (this.privateKey == null && this.publicKey == null && this.fallbackSignature == null) {
                throw new SignatureException("Missing key");
            }
            if (this.pssParams == null) {
                throw new SignatureException("Parameters required for RSASSA-PSS signatures");
            }
            if (this.fallbackSignature == null && this.messageDigest == null) {
                try {
                    this.messageDigest = MessageDigest.getInstance(this.pssParams.getDigestAlgorithm());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new SignatureException(e);
                }
            }
        }

        private PSSParameterSpec validateSigParams(AlgorithmParameterSpec p) throws InvalidAlgorithmParameterException {
            String mgf1HashAlg;
            if (p == null) {
                throw new InvalidAlgorithmParameterException("Parameters cannot be null");
            }
            if (!(p instanceof PSSParameterSpec)) {
                throw new InvalidAlgorithmParameterException("parameters must be type PSSParameterSpec");
            }
            PSSParameterSpec params = (PSSParameterSpec)p;
            if (params == this.pssParams) {
                return params;
            }
            if (!params.getMGFAlgorithm().equalsIgnoreCase("MGF1")) {
                throw new InvalidAlgorithmParameterException("Only supports MGF1");
            }
            if (params.getTrailerField() != 1) {
                throw new InvalidAlgorithmParameterException("Only supports TrailerFieldBC(1)");
            }
            AlgorithmParameterSpec algSpec = params.getMGFParameters();
            if (!(algSpec instanceof MGF1ParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Only support MGF1ParameterSpec");
            }
            MGF1ParameterSpec mgfSpec = (MGF1ParameterSpec)algSpec;
            String msgHashAlg = params.getDigestAlgorithm().toLowerCase(Locale.ROOT).replaceAll("-", "");
            if (msgHashAlg.equals("sha")) {
                msgHashAlg = "sha1";
            }
            if ((mgf1HashAlg = mgfSpec.getDigestAlgorithm().toLowerCase(Locale.ROOT).replaceAll("-", "")).equals("sha")) {
                mgf1HashAlg = "sha1";
            }
            if (!mgf1HashAlg.equals(msgHashAlg)) {
                throw new InvalidAlgorithmParameterException("MGF1 hash must be the same as message hash");
            }
            return params;
        }
    }

    static class ECDSA
    extends CSignature {
        public ECDSA(String messageDigestAlgorithm) {
            super("EC", messageDigestAlgorithm);
        }

        @Override
        protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
            if (key == null) {
                throw new InvalidKeyException("Key cannot be null");
            }
            if (!(key instanceof CPrivateKey) || !key.getAlgorithm().equalsIgnoreCase("EC")) {
                throw new InvalidKeyException("Key type not supported: " + key.getClass() + " " + key.getAlgorithm());
            }
            this.privateKey = (CPrivateKey)key;
            this.publicKey = null;
            this.resetDigest();
        }

        @Override
        protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
            if (key == null) {
                throw new InvalidKeyException("Key cannot be null");
            }
            if (!(key instanceof ECPublicKey)) {
                throw new InvalidKeyException("Key type not supported: " + key.getClass());
            }
            if (!(key instanceof CPublicKey)) {
                try {
                    this.publicKey = ECDSA.importECPublicKey("EC", CKey.generateECBlob(key), KeyUtil.getKeySize(key));
                }
                catch (KeyStoreException e) {
                    throw new InvalidKeyException(e);
                }
            } else {
                this.publicKey = (CPublicKey)key;
            }
            this.privateKey = null;
            this.resetDigest();
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            byte[] hash = this.getDigestValue();
            byte[] raw = ECDSA.signCngHash(0, hash, hash.length, 0, null, this.privateKey.getHCryptProvider(), 0L);
            return ECUtil.encodeSignature(raw);
        }

        @Override
        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            byte[] hash = this.getDigestValue();
            sigBytes = ECUtil.decodeSignature(sigBytes);
            return CSignature.verifyCngSignedHash(0, hash, hash.length, sigBytes, sigBytes.length, 0, null, this.publicKey.getHCryptProvider(), 0L);
        }
    }

    public static final class SHA512withECDSA
    extends ECDSA {
        public SHA512withECDSA() {
            super("SHA-512");
        }
    }

    public static final class SHA384withECDSA
    extends ECDSA {
        public SHA384withECDSA() {
            super("SHA-384");
        }
    }

    public static final class SHA256withECDSA
    extends ECDSA {
        public SHA256withECDSA() {
            super("SHA-256");
        }
    }

    public static final class SHA224withECDSA
    extends ECDSA {
        public SHA224withECDSA() {
            super("SHA-224");
        }
    }

    public static final class SHA1withECDSA
    extends ECDSA {
        public SHA1withECDSA() {
            super("SHA-1");
        }
    }

    public static final class MD2withRSA
    extends RSA {
        public MD2withRSA() {
            super("MD2");
        }
    }

    public static final class MD5withRSA
    extends RSA {
        public MD5withRSA() {
            super("MD5");
        }
    }

    public static final class SHA512withRSA
    extends RSA {
        public SHA512withRSA() {
            super("SHA-512");
        }
    }

    public static final class SHA384withRSA
    extends RSA {
        public SHA384withRSA() {
            super("SHA-384");
        }
    }

    public static final class SHA256withRSA
    extends RSA {
        public SHA256withRSA() {
            super("SHA-256");
        }
    }

    public static final class SHA1withRSA
    extends RSA {
        public SHA1withRSA() {
            super("SHA1");
        }
    }

    public static final class NONEwithRSA
    extends RSA {
        private static final int RAW_RSA_MAX = 64;
        private final byte[] precomputedDigest = new byte[64];
        private int offset = 0;

        public NONEwithRSA() {
            super(null);
        }

        @Override
        protected void engineUpdate(byte b) throws SignatureException {
            if (this.offset >= this.precomputedDigest.length) {
                this.offset = 65;
                return;
            }
            this.precomputedDigest[this.offset++] = b;
        }

        @Override
        protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
            if (len > this.precomputedDigest.length - this.offset) {
                this.offset = 65;
                return;
            }
            System.arraycopy(b, off, this.precomputedDigest, this.offset, len);
            this.offset += len;
        }

        @Override
        protected void engineUpdate(ByteBuffer byteBuffer) {
            int len = byteBuffer.remaining();
            if (len <= 0) {
                return;
            }
            if (len > this.precomputedDigest.length - this.offset) {
                this.offset = 65;
                return;
            }
            byteBuffer.get(this.precomputedDigest, this.offset, len);
            this.offset += len;
        }

        @Override
        protected void resetDigest() {
            this.offset = 0;
        }

        @Override
        protected byte[] getDigestValue() throws SignatureException {
            if (this.offset > 64) {
                throw new SignatureException("Message digest is too long");
            }
            if (this.offset == 20) {
                this.setDigestName("SHA1");
            } else if (this.offset == 36) {
                this.setDigestName("SHA1+MD5");
            } else if (this.offset == 32) {
                this.setDigestName("SHA-256");
            } else if (this.offset == 48) {
                this.setDigestName("SHA-384");
            } else if (this.offset == 64) {
                this.setDigestName("SHA-512");
            } else if (this.offset == 16) {
                this.setDigestName("MD5");
            } else {
                throw new SignatureException("Message digest length is not supported");
            }
            byte[] result = new byte[this.offset];
            System.arraycopy(this.precomputedDigest, 0, result, 0, this.offset);
            this.offset = 0;
            return result;
        }
    }

    static class RSA
    extends CSignature {
        public RSA(String digestAlgorithm) {
            super("RSA", digestAlgorithm);
        }

        @Override
        protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
            if (key == null) {
                throw new InvalidKeyException("Key cannot be null");
            }
            if (!(key instanceof CPrivateKey) || !key.getAlgorithm().equalsIgnoreCase("RSA")) {
                throw new InvalidKeyException("Key type not supported: " + key.getClass() + " " + key.getAlgorithm());
            }
            this.privateKey = (CPrivateKey)key;
            RSAKeyFactory.checkKeyLengths(this.privateKey.length() + 7 & 0xFFFFFFF8, null, 512, 16384);
            this.publicKey = null;
            this.resetDigest();
        }

        @Override
        protected void engineInitVerify(PublicKey key) throws InvalidKeyException {
            if (key == null) {
                throw new InvalidKeyException("Key cannot be null");
            }
            if (!(key instanceof RSAPublicKey)) {
                throw new InvalidKeyException("Key type not supported: " + key.getClass());
            }
            if (!(key instanceof CPublicKey)) {
                RSAPublicKey rsaKey = (RSAPublicKey)key;
                BigInteger modulus = rsaKey.getModulus();
                BigInteger exponent = rsaKey.getPublicExponent();
                RSAKeyFactory.checkKeyLengths(modulus.bitLength() + 7 & 0xFFFFFFF8, exponent, -1, 16384);
                byte[] modulusBytes = modulus.toByteArray();
                byte[] exponentBytes = exponent.toByteArray();
                int keyBitLength = modulusBytes[0] == 0 ? (modulusBytes.length - 1) * 8 : modulusBytes.length * 8;
                byte[] keyBlob = RSA.generatePublicKeyBlob(keyBitLength, modulusBytes, exponentBytes);
                try {
                    this.publicKey = RSA.importPublicKey("RSA", keyBlob, keyBitLength);
                }
                catch (KeyStoreException e) {
                    throw new InvalidKeyException(e);
                }
            } else {
                this.publicKey = (CPublicKey)key;
            }
            this.privateKey = null;
            this.resetDigest();
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            byte[] hash = this.getDigestValue();
            if (this.privateKey.getHCryptKey() == 0L) {
                return RSA.signCngHash(1, hash, hash.length, 0, this instanceof NONEwithRSA ? null : this.messageDigestAlgorithm, this.privateKey.getHCryptProvider(), 0L);
            }
            boolean noHashOID = this instanceof NONEwithRSA;
            byte[] result = CSignature.signHash(noHashOID, hash, hash.length, this.messageDigestAlgorithm, this.privateKey.getHCryptProvider(), this.privateKey.getHCryptKey());
            return CSignature.convertEndianArray(result);
        }

        @Override
        protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
            byte[] hash = this.getDigestValue();
            if (this.publicKey.getHCryptKey() == 0L) {
                return CSignature.verifyCngSignedHash(1, hash, hash.length, sigBytes, sigBytes.length, 0, this.messageDigestAlgorithm, this.publicKey.getHCryptProvider(), 0L);
            }
            return CSignature.verifySignedHash(hash, hash.length, this.messageDigestAlgorithm, CSignature.convertEndianArray(sigBytes), sigBytes.length, this.publicKey.getHCryptProvider(), this.publicKey.getHCryptKey());
        }

        static native byte[] generatePublicKeyBlob(int var0, byte[] var1, byte[] var2) throws InvalidKeyException;
    }
}

