/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import sun.security.internal.spec.TlsRsaPremasterSecretParameterSpec;
import sun.security.mscapi.CKey;
import sun.security.mscapi.CSignature;
import sun.security.rsa.RSAKeyFactory;
import sun.security.util.KeyUtil;

public final class CRSACipher
extends CipherSpi {
    private static final byte[] B0 = new byte[0];
    private static final int MODE_ENCRYPT = 1;
    private static final int MODE_DECRYPT = 2;
    private static final int MODE_SIGN = 3;
    private static final int MODE_VERIFY = 4;
    private static final String PAD_PKCS1 = "PKCS1Padding";
    private static final int PAD_PKCS1_LENGTH = 11;
    private int mode;
    private String paddingType = "PKCS1Padding";
    private int paddingLength = 0;
    private byte[] buffer;
    private int bufOfs;
    private int outputSize;
    private CKey publicKey;
    private CKey privateKey;
    private AlgorithmParameterSpec spec = null;
    private SecureRandom random;

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!mode.equalsIgnoreCase("ECB")) {
            throw new NoSuchAlgorithmException("Unsupported mode " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String paddingName) throws NoSuchPaddingException {
        if (!paddingName.equalsIgnoreCase(PAD_PKCS1)) {
            throw new NoSuchPaddingException("Padding " + paddingName + " not supported");
        }
        this.paddingType = PAD_PKCS1;
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.outputSize;
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.init(opmode, key);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            if (!(params instanceof TlsRsaPremasterSecretParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Parameters not supported");
            }
            this.spec = params;
            this.random = random;
        }
        this.init(opmode, key);
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.init(opmode, key);
    }

    private void init(int opmode, Key key) throws InvalidKeyException {
        boolean encrypt;
        switch (opmode) {
            case 1: 
            case 3: {
                this.paddingLength = 11;
                encrypt = true;
                break;
            }
            case 2: 
            case 4: {
                this.paddingLength = 0;
                encrypt = false;
                break;
            }
            default: {
                throw new InvalidKeyException("Unknown mode: " + opmode);
            }
        }
        if (!(key instanceof CKey)) {
            if (key instanceof RSAPublicKey) {
                RSAPublicKey rsaKey = (RSAPublicKey)key;
                BigInteger modulus = rsaKey.getModulus();
                BigInteger exponent = rsaKey.getPublicExponent();
                RSAKeyFactory.checkKeyLengths(modulus.bitLength() + 7 & 0xFFFFFFF8, exponent, -1, 16384);
                byte[] modulusBytes = modulus.toByteArray();
                byte[] exponentBytes = exponent.toByteArray();
                int keyBitLength = modulusBytes[0] == 0 ? (modulusBytes.length - 1) * 8 : modulusBytes.length * 8;
                byte[] keyBlob = CSignature.RSA.generatePublicKeyBlob(keyBitLength, modulusBytes, exponentBytes);
                try {
                    key = CSignature.importPublicKey("RSA", keyBlob, keyBitLength);
                }
                catch (KeyStoreException e) {
                    throw new InvalidKeyException(e);
                }
            } else {
                throw new InvalidKeyException("Unsupported key type: " + key);
            }
        }
        if (key instanceof PublicKey) {
            this.mode = encrypt ? 1 : 4;
            this.publicKey = (CKey)key;
            this.privateKey = null;
            this.outputSize = this.publicKey.length() / 8;
        } else if (key instanceof PrivateKey) {
            this.mode = encrypt ? 3 : 2;
            this.privateKey = (CKey)key;
            this.publicKey = null;
            this.outputSize = this.privateKey.length() / 8;
        } else {
            throw new InvalidKeyException("Unknown key type: " + key);
        }
        this.bufOfs = 0;
        this.buffer = new byte[this.outputSize];
    }

    private void update(byte[] in, int inOfs, int inLen) {
        if (inLen == 0 || in == null) {
            return;
        }
        if (this.bufOfs + inLen > this.buffer.length - this.paddingLength) {
            this.bufOfs = this.buffer.length + 1;
            return;
        }
        System.arraycopy(in, inOfs, this.buffer, this.bufOfs, inLen);
        this.bufOfs += inLen;
    }

    private byte[] doFinal() throws BadPaddingException, IllegalBlockSizeException {
        if (this.bufOfs > this.buffer.length) {
            throw new IllegalBlockSizeException("Data must not be longer than " + (this.buffer.length - this.paddingLength) + " bytes");
        }
        try {
            byte[] data = this.buffer;
            switch (this.mode) {
                case 3: {
                    byte[] byArray = CRSACipher.encryptDecrypt(data, this.bufOfs, this.privateKey.getHCryptKey(), true);
                    return byArray;
                }
                case 4: {
                    byte[] byArray = CRSACipher.encryptDecrypt(data, this.bufOfs, this.publicKey.getHCryptKey(), false);
                    return byArray;
                }
                case 1: {
                    byte[] byArray = CRSACipher.encryptDecrypt(data, this.bufOfs, this.publicKey.getHCryptKey(), true);
                    return byArray;
                }
                case 2: {
                    byte[] byArray = CRSACipher.encryptDecrypt(data, this.bufOfs, this.privateKey.getHCryptKey(), false);
                    return byArray;
                }
            }
            try {
                throw new AssertionError((Object)"Internal error");
            }
            catch (KeyException e) {
                throw new ProviderException(e);
            }
        }
        finally {
            this.bufOfs = 0;
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] in, int inOfs, int inLen) {
        this.update(in, inOfs, inLen);
        return B0;
    }

    @Override
    protected int engineUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) {
        this.update(in, inOfs, inLen);
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws BadPaddingException, IllegalBlockSizeException {
        this.update(in, inOfs, inLen);
        return this.doFinal();
    }

    @Override
    protected int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException, BadPaddingException, IllegalBlockSizeException {
        if (this.outputSize > out.length - outOfs) {
            throw new ShortBufferException("Need " + this.outputSize + " bytes for output");
        }
        this.update(in, inOfs, inLen);
        byte[] result = this.doFinal();
        int n = result.length;
        System.arraycopy(result, 0, out, outOfs, n);
        return n;
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        if (encoded.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for wrapping");
        }
        this.update(encoded, 0, encoded.length);
        try {
            return this.doFinal();
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("Wrapping failed", e);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String algorithm, int type) throws InvalidKeyException, NoSuchAlgorithmException {
        if (wrappedKey.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for unwrapping");
        }
        boolean isTlsRsaPremasterSecret = algorithm.equals("TlsRsaPremasterSecret");
        BadPaddingException failover = null;
        byte[] encoded = null;
        this.update(wrappedKey, 0, wrappedKey.length);
        try {
            encoded = this.doFinal();
        }
        catch (BadPaddingException e) {
            if (isTlsRsaPremasterSecret) {
                failover = e;
            }
            throw new InvalidKeyException("Unwrapping failed", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new InvalidKeyException("Unwrapping failed", e);
        }
        if (isTlsRsaPremasterSecret) {
            if (!(this.spec instanceof TlsRsaPremasterSecretParameterSpec)) {
                throw new IllegalStateException("No TlsRsaPremasterSecretParameterSpec specified");
            }
            encoded = KeyUtil.checkTlsPreMasterSecretKey(((TlsRsaPremasterSecretParameterSpec)this.spec).getClientVersion(), ((TlsRsaPremasterSecretParameterSpec)this.spec).getServerVersion(), this.random, encoded, failover != null);
        }
        return CRSACipher.constructKey(encoded, algorithm, type);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof CKey) {
            return ((CKey)key).length();
        }
        if (key instanceof RSAKey) {
            return ((RSAKey)((Object)key)).getModulus().bitLength();
        }
        throw new InvalidKeyException("Unsupported key type: " + key);
    }

    private static PublicKey constructPublicKey(byte[] encodedKey, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
            return keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchAlgorithmException("No installed provider supports the " + encodedKeyAlgorithm + " algorithm", nsae);
        }
        catch (InvalidKeySpecException ike) {
            throw new InvalidKeyException("Cannot construct public key", ike);
        }
    }

    private static PrivateKey constructPrivateKey(byte[] encodedKey, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new NoSuchAlgorithmException("No installed provider supports the " + encodedKeyAlgorithm + " algorithm", nsae);
        }
        catch (InvalidKeySpecException ike) {
            throw new InvalidKeyException("Cannot construct private key", ike);
        }
    }

    private static SecretKey constructSecretKey(byte[] encodedKey, String encodedKeyAlgorithm) {
        return new SecretKeySpec(encodedKey, encodedKeyAlgorithm);
    }

    private static Key constructKey(byte[] encodedKey, String encodedKeyAlgorithm, int keyType) throws InvalidKeyException, NoSuchAlgorithmException {
        switch (keyType) {
            case 1: {
                return CRSACipher.constructPublicKey(encodedKey, encodedKeyAlgorithm);
            }
            case 2: {
                return CRSACipher.constructPrivateKey(encodedKey, encodedKeyAlgorithm);
            }
            case 3: {
                return CRSACipher.constructSecretKey(encodedKey, encodedKeyAlgorithm);
            }
        }
        throw new InvalidKeyException("Unknown key type " + keyType);
    }

    private static native byte[] encryptDecrypt(byte[] var0, int var1, long var2, boolean var4) throws KeyException;
}

