/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.io.ObjectStreamException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyRep;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.Arrays;
import sun.security.mscapi.CKey;
import sun.security.rsa.RSAPublicKeyImpl;
import sun.security.rsa.RSAUtil;
import sun.security.util.ECKeySizeParameterSpec;

public abstract class CPublicKey
extends CKey
implements PublicKey {
    private static final long serialVersionUID = -2289561342425825391L;
    protected byte[] encoding = null;

    static CPublicKey of(String alg, long hCryptProv, long hCryptKey, int keyLength) {
        return CPublicKey.of(alg, new CKey.NativeHandles(hCryptProv, hCryptKey), keyLength);
    }

    public static CPublicKey of(String alg, CKey.NativeHandles handles, int keyLength) {
        switch (alg) {
            case "RSA": {
                return new CRSAPublicKey(handles, keyLength);
            }
            case "EC": {
                return new CECPublicKey(handles, keyLength);
            }
        }
        throw new AssertionError((Object)("Unsupported algorithm: " + alg));
    }

    protected CPublicKey(String alg, CKey.NativeHandles handles, int keyLength) {
        super(alg, handles, keyLength);
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    native byte[] getPublicKeyBlob(long var1, long var3) throws KeyException;

    public static class CRSAPublicKey
    extends CPublicKey
    implements RSAPublicKey {
        private BigInteger modulus = null;
        private BigInteger exponent = null;
        private static final long serialVersionUID = 12L;

        CRSAPublicKey(CKey.NativeHandles handles, int keyLength) {
            super("RSA", handles, keyLength);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.algorithm + "PublicKey [size=").append(this.keyLength).append(" bits, type=");
            if (this.handles.hCryptKey != 0L) {
                sb.append(CRSAPublicKey.getKeyType(this.handles.hCryptKey)).append(", container=").append(CRSAPublicKey.getContainerName(this.handles.hCryptProv));
            } else {
                sb.append("CNG");
            }
            sb.append("]\n  modulus: ").append(this.getModulus()).append("\n  public exponent: ").append(this.getPublicExponent());
            return sb.toString();
        }

        @Override
        public BigInteger getPublicExponent() {
            if (this.exponent == null) {
                try {
                    byte[] publicKeyBlob = this.getPublicKeyBlob(this.handles.hCryptProv, this.handles.hCryptKey);
                    this.exponent = new BigInteger(1, this.getExponent(publicKeyBlob));
                }
                catch (KeyException e) {
                    throw new ProviderException(e);
                }
            }
            return this.exponent;
        }

        @Override
        public BigInteger getModulus() {
            if (this.modulus == null) {
                try {
                    byte[] publicKeyBlob = this.getPublicKeyBlob(this.handles.hCryptProv, this.handles.hCryptKey);
                    this.modulus = new BigInteger(1, this.getModulus(publicKeyBlob));
                }
                catch (KeyException e) {
                    throw new ProviderException(e);
                }
            }
            return this.modulus;
        }

        @Override
        public byte[] getEncoded() {
            if (this.encoding == null) {
                try {
                    this.encoding = RSAPublicKeyImpl.newKey(RSAUtil.KeyType.RSA, null, this.getModulus(), this.getPublicExponent()).getEncoded();
                }
                catch (KeyException keyException) {
                    // empty catch block
                }
            }
            return this.encoding;
        }

        private native byte[] getExponent(byte[] var1) throws KeyException;

        private native byte[] getModulus(byte[] var1) throws KeyException;
    }

    public static class CECPublicKey
    extends CPublicKey
    implements ECPublicKey {
        private ECPoint w = null;
        private static final long serialVersionUID = 12L;

        CECPublicKey(CKey.NativeHandles handles, int keyLength) {
            super("EC", handles, keyLength);
        }

        @Override
        public ECPoint getW() {
            if (this.w == null) {
                try {
                    byte[] blob = this.getPublicKeyBlob(this.handles.hCryptProv, this.handles.hCryptKey);
                    int len = blob[8] & 0xFF;
                    byte[] x = Arrays.copyOfRange(blob, 8, 8 + len);
                    byte[] y = Arrays.copyOfRange(blob, 8 + len, 8 + len + len);
                    this.w = new ECPoint(new BigInteger(1, x), new BigInteger(1, y));
                }
                catch (KeyException e) {
                    throw new ProviderException(e);
                }
            }
            return this.w;
        }

        @Override
        public byte[] getEncoded() {
            if (this.encoding == null) {
                try {
                    this.encoding = KeyFactory.getInstance("EC").generatePublic(new ECPublicKeySpec(this.getW(), this.getParams())).getEncoded();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return this.encoding;
        }

        @Override
        public ECParameterSpec getParams() {
            try {
                AlgorithmParameters ap = AlgorithmParameters.getInstance("EC");
                ap.init(new ECKeySizeParameterSpec(this.keyLength));
                return ap.getParameterSpec(ECParameterSpec.class);
            }
            catch (Exception e) {
                throw new ProviderException(e);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.algorithm + "PublicKey [size=").append(this.keyLength).append("]\n  ECPoint: ").append(this.getW()).append("\n  params: ").append(this.getParams());
            return sb.toString();
        }
    }
}

