/*
 * Decompiled with CFR 0.152.
 */
package sun.security.mscapi;

import java.math.BigInteger;
import java.security.Key;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import sun.security.util.KeyUtil;
import sun.security.util.Length;

abstract class CKey
implements Key,
Length {
    private static final long serialVersionUID = -1088859394025049194L;
    protected final NativeHandles handles;
    protected final int keyLength;
    protected final String algorithm;

    protected CKey(String algorithm, NativeHandles handles, int keyLength) {
        this.algorithm = algorithm;
        this.handles = handles;
        this.keyLength = keyLength;
    }

    private static native void cleanUp(long var0, long var2);

    @Override
    public int length() {
        return this.keyLength;
    }

    public long getHCryptKey() {
        return this.handles.hCryptKey;
    }

    public long getHCryptProvider() {
        return this.handles.hCryptProv;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    protected static native String getContainerName(long var0);

    protected static native String getKeyType(long var0);

    static byte[] generateECBlob(Key k) {
        int keyBitLength = KeyUtil.getKeySize(k);
        int keyLen = (keyBitLength + 7) / 8;
        boolean isPrivate = k instanceof ECPrivateKey;
        byte[] keyBlob = new byte[8 + keyLen * (isPrivate ? 3 : 2)];
        keyBlob[0] = 69;
        keyBlob[1] = 67;
        keyBlob[2] = 83;
        keyBlob[3] = isPrivate ? (byte)(keyBitLength == 256 ? 50 : (keyBitLength == 384 ? 52 : 54)) : (byte)(keyBitLength == 256 ? 49 : (keyBitLength == 384 ? 51 : 53));
        if (isPrivate) {
            ECPrivateKey prk = (ECPrivateKey)k;
            BigInteger s = prk.getS();
            byte[] bs = s.toByteArray();
            System.arraycopy(bs, 0, keyBlob, 8 + keyLen + keyLen + keyLen - bs.length, bs.length);
        } else {
            ECPublicKey puk = (ECPublicKey)k;
            BigInteger x = puk.getW().getAffineX();
            BigInteger y = puk.getW().getAffineY();
            byte[] by = y.toByteArray();
            System.arraycopy(by, 0, keyBlob, 8 + keyLen + keyLen - by.length, by.length);
            byte[] bx = x.toByteArray();
            System.arraycopy(bx, 0, keyBlob, 8 + keyLen - bx.length, bx.length);
        }
        keyBlob[4] = (byte)keyLen;
        keyBlob[7] = 0;
        keyBlob[6] = 0;
        keyBlob[5] = 0;
        return keyBlob;
    }

    static class NativeHandles {
        long hCryptProv = 0L;
        long hCryptKey = 0L;

        public NativeHandles(long hCryptProv, long hCryptKey) {
            this.hCryptProv = hCryptProv;
            this.hCryptKey = hCryptKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                NativeHandles nativeHandles = this;
                synchronized (nativeHandles) {
                    CKey.cleanUp(this.hCryptProv, this.hCryptKey);
                    this.hCryptProv = 0L;
                    this.hCryptKey = 0L;
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

