/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.psg.remote.PsgTransactionRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgTransactionService;
import com.zkteco.zkbiosecurity.psg.vo.PsgTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgTransactionController
extends ExportController
implements PsgTransactionRemote {
    @Autowired
    private PsgTransactionService psgTransactionService;

    @RequiresPermissions(value={"psg:transaction"})
    public ModelAndView index() {
        return new ModelAndView("psg/transaction/psgTransaction");
    }

    @RequiresPermissions(value={"psg:transaction:refresh"})
    public DxGrid list(PsgTransactionItem condition) {
        Pager pager = this.psgTransactionService.loadTransactionByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"psg:transaction:del"})
    public ZKResultMsg del(String ids) {
        this.psgTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:transaction:del"})
    @LogRequest(module="psg_module", object="common_leftMenu_transaction", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.psgTransactionService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:transaction:export"})
    @LogRequest(module="psg_module", object="common_leftMenu_transaction", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PsgTransactionItem psgTransactionItem = new PsgTransactionItem();
        this.setConditionValue((BaseItem)psgTransactionItem);
        String sessionId = request.getSession().getId();
        String areaNames = this.psgTransactionService.getAreaNamesByAuthFilter(sessionId);
        String deptCodes = this.psgTransactionService.getDeptCodesByAuthFilter(sessionId);
        psgTransactionItem.setAreaNameIn(areaNames);
        psgTransactionItem.setDeptCodeIn(deptCodes);
        List itemList = this.psgTransactionService.getItemData(PsgTransactionItem.class, (BaseItem)psgTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, PsgTransactionItem.class);
    }

    public ZKResultMsg isFileExist(String vidLinkageHandle) {
        boolean isExist = this.psgTransactionService.isFileExist(vidLinkageHandle);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)String.valueOf(isExist)));
    }

    @RequiresPermissions(value={"psg:rtMonitor:transactionTodayHappen"})
    public DxGrid getTransactionsTodayLast(PsgTransactionItem psgTransactionItem) {
        psgTransactionItem.setStartTime(DateUtil.getTodayBeginTime());
        psgTransactionItem.setEndTime(DateUtil.getTodayEndTime());
        Pager pager = this.psgTransactionService.getTransactionsTodayLast(psgTransactionItem);
        return GridUtil.convert((Pager)pager, psgTransactionItem.getClass());
    }

    public ZKResultMsg viewVidLinkData(String vidLinkageHandle, String fileType) {
        return this.psgTransactionService.viewVidLinkData(vidLinkageHandle, fileType);
    }

    public ZKResultMsg getVideoFile(String id) {
        Map retMap = this.psgTransactionService.getVideoFileValidate(id);
        if (Objects.nonNull(retMap)) {
            ZKResultMsg ret = (ZKResultMsg)retMap.get("ret");
            if (null != ret) {
                return I18nUtil.i18nMsg((ZKResultMsg)ret);
            }
            String filePath = retMap.get("filePath").toString();
            File file = (File)retMap.get("file");
            int index = filePath.lastIndexOf(File.separator);
            String fileName = filePath.substring(index + 1);
            if (file.isDirectory() && file.listFiles().length > 0) {
                File childFile = file.listFiles()[0];
                fileName = fileName.substring(0, fileName.lastIndexOf(".")) + childFile.getName().substring(childFile.getName().lastIndexOf("."));
            }
            this.response.setCharacterEncoding("utf-8");
            this.response.setContentType("multipart/form-data");
            this.response.setHeader("Content-Disposition", "attachment;fileName=" + fileName);
            try {
                int length;
                FileInputStream inputStream = new FileInputStream(filePath);
                ServletOutputStream os = this.response.getOutputStream();
                byte[] b = new byte[2048];
                while ((length = ((InputStream)inputStream).read(b)) > 0) {
                    os.write(b, 0, length);
                }
                os.close();
                ((InputStream)inputStream).close();
            }
            catch (Exception e) {
                this.log.error("exception", (Throwable)e);
            }
        }
        return null;
    }

    public ZKResultMsg getDecryptPhotoBase64(String photoPath) {
        String decryptPhoto;
        if (StringUtils.isNotBlank((CharSequence)photoPath) && StringUtils.isNotBlank((CharSequence)(decryptPhoto = FileEncryptUtil.getDecryptFileBase64((String)photoPath)))) {
            return new ZKResultMsg((Object)("data:image/jpg;base64," + decryptPhoto));
        }
        return ZKResultMsg.failMsg();
    }

    public ZKResultMsg getTransactionInfoById(String id) {
        PsgTransactionItem item;
        if (StringUtils.isNotBlank((CharSequence)id) && Objects.nonNull(item = this.psgTransactionService.getItemById(id))) {
            return new ZKResultMsg((Object)item);
        }
        return ZKResultMsg.failMsg();
    }
}

