/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.remote.PsgSwingGateRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceOptionService;
import com.zkteco.zkbiosecurity.psg.service.PsgSwingGateService;
import com.zkteco.zkbiosecurity.psg.vo.PsgSwingGateItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgSwingGateController
extends BaseController
implements PsgSwingGateRemote {
    @Autowired
    private PsgSwingGateService psgSwingGateService;
    @Autowired
    private PsgDeviceOptionService psgDeviceOptionService;

    @RequiresPermissions(value={"psg:swingGate"})
    public ModelAndView index() {
        return new ModelAndView("psg/swingGate/psgSwingGate");
    }

    @RequiresPermissions(value={"psg:swingGate:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PsgSwingGateItem item = this.psgSwingGateService.getItemById(id);
            this.buildEditSwingGateItem(item);
        }
        return new ModelAndView("psg/swingGate/editPsgSwingGate");
    }

    @RequiresPermissions(value={"psg:swingGate:edit"})
    @LogChangeRequest(module="psg_module", object="psg_device_swingGate", opType="common_op_edit", vo=PsgSwingGateItem.class, service=PsgSwingGateService.class)
    public ZKResultMsg save(PsgSwingGateItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.psgSwingGateService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:swingGate:refresh"})
    public DxGrid list(PsgSwingGateItem condition) {
        Pager pager = this.psgSwingGateService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ModelAndView editSwingGateItemByDevId(String devId) {
        PsgSwingGateItem item = this.psgSwingGateService.findByDevId(devId);
        if (Objects.nonNull(item)) {
            this.buildEditSwingGateItem(item);
        }
        return new ModelAndView("psg/swingGate/editPsgSwingGate");
    }

    public void buildEditSwingGateItem(PsgSwingGateItem item) {
        String unmannedTimeRange;
        this.request.setAttribute("item", (Object)item);
        String delayCloseGateTimeRange = this.psgDeviceOptionService.getValueByNameAndDevSn(item.getDevSn(), "PassCloseDelayRange");
        if (!"0".equals(delayCloseGateTimeRange)) {
            this.request.setAttribute("delayCloseGateTimeRange", (Object)delayCloseGateTimeRange);
        }
        if (!"0".equals(unmannedTimeRange = this.psgDeviceOptionService.getValueByNameAndDevSn(item.getDevSn(), "PassUnmannedRange"))) {
            this.request.setAttribute("unmannedTimeRange", (Object)unmannedTimeRange);
        }
        this.request.setAttribute("editPage", (Object)true);
    }
}

