/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.psg.remote.PsgRTMonitorRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgAuxInService;
import com.zkteco.zkbiosecurity.psg.service.PsgBaseDictionaryService;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import com.zkteco.zkbiosecurity.psg.service.PsgGateService;
import com.zkteco.zkbiosecurity.psg.service.PsgParamService;
import com.zkteco.zkbiosecurity.psg.service.PsgRTMonitorService;
import com.zkteco.zkbiosecurity.psg.vo.PsgRTMonitorItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgRTMonitorController
extends ExportController
implements PsgRTMonitorRemote {
    @Autowired
    private PsgRTMonitorService psgRTMonitorService;
    @Autowired
    private PsgGateService psgGateService;
    @Autowired
    private PsgAuxInService psgAuxInService;
    @Autowired
    private PsgDeviceService psgDeviceService;
    @Autowired
    private PsgBaseDictionaryService psgBaseDictionaryService;
    @Autowired
    private PsgParamService psgParamService;
    @Autowired
    private PersParamsService persParamsService;

    @RequiresPermissions(value={"psg:rtMonitor"})
    public ModelAndView index() {
        String loadPlugins = (String)this.psgParamService.getVidParams().get("vid.loadPlugins");
        String personPhotoMaxHeight = this.psgParamService.getParamValByName("psg.personPhotoMaxHeight");
        boolean isEnableCardNoEncrypt = this.persParamsService.getEncryptPropByParamName("pers.cardNo.encryptProp");
        this.request.setAttribute("personPhotoMaxHeight", (Object)personPhotoMaxHeight);
        this.request.setAttribute("loadPlugins", (Object)loadPlugins);
        this.request.setAttribute("isEnableCardNoEncrypt", (Object)isEnableCardNoEncrypt);
        return new ModelAndView("psg/rtMonitor/psgRTMonitor");
    }

    public DxGrid list(PsgRTMonitorItem codition) {
        return null;
    }

    public List getAllGate() {
        ArrayList data = new ArrayList();
        ZKResultMsg resultMsg = this.psgGateService.getGateStatus(this.request.getSession().getId(), I18nUtil.i18nCode((String)"common_paging_loading", (Object[])new Object[0]));
        JSONArray gateStates = (JSONArray)resultMsg.getData();
        if (Objects.nonNull(gateStates) && gateStates.size() > 0) {
            gateStates.forEach(gate -> data.add(gate));
        }
        return data;
    }

    public List getAllAuxIn() {
        ArrayList data = new ArrayList();
        ZKResultMsg resultMsg = this.psgAuxInService.getAuxInStatus(this.request.getSession().getId());
        JSONArray auxInStatus = (JSONArray)resultMsg.getData();
        if (Objects.nonNull(auxInStatus) && auxInStatus.size() > 0) {
            auxInStatus.stream().forEach(auxIn -> data.add(auxIn));
        }
        return data;
    }

    @RequiresPermissions(value={"psg:rtMonitor:openInGate"})
    @LogRequest(module="psg_module", object="common_leftMenu_rtMonitor", opType="psg_gate_remoteOpenIn", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg openInGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("openInGate", ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"psg:rtMonitor:openOutGate"})
    @LogRequest(module="psg_module", object="common_leftMenu_rtMonitor", opType="psg_gate_remoteOpenOut", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg openOutGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("openOutGate", ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"psg:rtMonitor:closeGate"})
    @LogRequest(module="psg_module", object="common_leftMenu_rtMonitor", opType="psg_eventNo_9", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg closeGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("closeGate", ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"psg:rtMonitor:cancelAlarm"})
    @LogRequest(module="psg_module", object="common_leftMenu_rtMonitor", opType="psg_eventNo_7", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg cancelAlarm(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("cancelAlarm", ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"psg:rtMonitor:lockGate"})
    @LogRequest(module="psg_module", object="common_leftMenu_rtMonitor", opType="psg_newEventNo_233", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg lockGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("lockGate", ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"psg:rtMonitor:unLockGate"})
    @LogRequest(module="psg_module", object="common_leftMenu_rtMonitor", opType="psg_newEventNo_234", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg unLockGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("unLockGate", ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="psg_module", object="common_leftMenu_rtMonitor", opType="psg_rtMonitor_remoteNormalOpen", requestParams={"name"}, opContent="psg_gate_name")
    @RequiresPermissions(value={"psg:rtMonitor:normalOpenGate"})
    public ZKResultMsg normalOpenGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("normalOpenGate", ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="psg_module", object="common_leftMenu_rtMonitor", opType="psg_eventNo_11", requestParams={"name"}, opContent="psg_gate_name")
    @RequiresPermissions(value={"psg:rtMonitor:enableNormalOpenGate"})
    public ZKResultMsg enableNormalOpenGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("enableNormalOpenGate", ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="psg_module", object="common_leftMenu_rtMonitor", opType="psg_eventNo_10", requestParams={"name"}, opContent="psg_gate_name")
    @RequiresPermissions(value={"psg:rtMonitor:disableNormalOpenGate"})
    public ZKResultMsg disableNormalOpenGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("disableNormalOpenGate", ids);
        return this.dealResultData(dataMap);
    }

    public ZKResultMsg getAreasByUser() {
        Map areaMap = this.psgRTMonitorService.getFilterAreaMap(this.request.getSession().getId());
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        if (areaMap.size() > 0) {
            JSONObject dataJson = new JSONObject();
            dataJson.put("areaId", areaMap.get("areaIds"));
            dataJson.put("areaName", areaMap.get("areaName"));
            resultMsg.setData((Object)dataJson);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg isKeepAlive() {
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    private ZKResultMsg dealResultData(Map<String, String> dataMap) {
        String cmdIdData = dataMap.get("cmdId");
        String msg = "";
        ZKResultMsg resultMsg = new ZKResultMsg();
        if ("true".equals(dataMap.get("notExistDev"))) {
            msg = I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]);
            resultMsg.setMsg(msg);
            return resultMsg;
        }
        if (!"".equals(cmdIdData)) {
            for (String cmdData : cmdIdData.split(",")) {
                String cmdId = cmdData.split("=")[0];
                String doorName = cmdData.split("=")[1];
                Map resultMap = this.psgDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (Objects.isNull(resultMap)) {
                    msg = msg + doorName + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                    continue;
                }
                Integer ret = Integer.valueOf((String)resultMap.get("result"));
                if (Objects.isNull(ret)) {
                    msg = msg + doorName + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                    continue;
                }
                if (ret >= 0) continue;
                String failedInfo = I18nUtil.i18nCode((String)this.psgBaseDictionaryService.getCommReason(ret.intValue()), (Object[])new Object[0]);
                msg = msg + doorName + "," + I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + failedInfo + ";";
            }
        }
        if (!"".equals(dataMap.get("offline"))) {
            for (String gateName : dataMap.get("offline").split(",")) {
                msg = msg + gateName + "," + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + ";";
            }
        }
        if (!"".equals(dataMap.get("notSupport"))) {
            for (String gateName : dataMap.get("notSupport").split(",")) {
                msg = msg + gateName + "," + I18nUtil.i18nCode((String)"psg_dev_devNotSupportFunction", (Object[])new Object[0]) + ";";
            }
        }
        if (!"".equals(msg)) {
            resultMsg.setRet("400");
            resultMsg.setMsg(msg);
        }
        resultMsg.setData((Object)"");
        return resultMsg;
    }
}

