/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.psg.remote.PsgPersonLastAddrRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgPersonLastAddrService;
import com.zkteco.zkbiosecurity.psg.service.PsgTransactionService;
import com.zkteco.zkbiosecurity.psg.vo.PsgPersonLastAddrItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgPersonLastAddrController
extends ExportController
implements PsgPersonLastAddrRemote {
    @Autowired
    private PsgPersonLastAddrService psgPersonLastAddrService;
    @Autowired
    private PsgTransactionService psgTransactionService;

    @RequiresPermissions(value={"psg:personLastAddr"})
    public ModelAndView index() {
        return new ModelAndView("psg/personLastAddr/psgPersonLastAddr");
    }

    @RequiresPermissions(value={"psg:personLastAddr:refresh"})
    public DxGrid list(PsgPersonLastAddrItem condition) {
        Pager pager = this.psgPersonLastAddrService.loadPersonLastAddrByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"psg:personLastAddr:del"})
    public ZKResultMsg del(String ids) {
        this.psgPersonLastAddrService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:personLastAddr:del"})
    @LogRequest(module="psg_module", object="psg_trans_lastAddr", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.psgPersonLastAddrService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:personLastAddr:export"})
    @LogRequest(module="psg_module", object="psg_trans_lastAddr", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PsgPersonLastAddrItem psgPersonLastAddrItem = new PsgPersonLastAddrItem();
        this.setConditionValue((BaseItem)psgPersonLastAddrItem);
        Pager pager = this.psgPersonLastAddrService.loadPersonLastAddrByAuthUserFilter(request.getSession().getId(), psgPersonLastAddrItem, this.getBeginIndex(), this.getEndIndex());
        List itemList = pager.getData();
        this.excelExport(itemList, PsgPersonLastAddrItem.class);
    }
}

