/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.remote.PsgPersonRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgLevelService;
import com.zkteco.zkbiosecurity.psg.service.PsgPersonService;
import com.zkteco.zkbiosecurity.psg.vo.PsgLevelItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgLevelPersonItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgPersonItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgSelectPersonItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgSelectPersonRadioItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgPersonController
extends BaseController
implements PsgPersonRemote {
    @Autowired
    private PsgPersonService psgPersonService;
    @Autowired
    private PsgLevelService psgLevelService;

    @RequiresPermissions(value={"psg:person"})
    public ModelAndView index() {
        return new ModelAndView("psg/person/psgPerson");
    }

    @RequiresPermissions(value={"psg:person:edit", "pers:person:psgEdit"})
    public ModelAndView edit(String personId) {
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            this.request.setAttribute("item", (Object)this.psgPersonService.getItemByPersonId(personId));
            this.request.setAttribute("tempList", (Object)this.psgLevelService.getLevelByPersonId(personId));
        } else {
            PsgLevelItem masterLevel = this.psgLevelService.getMasterLevel();
            if (Objects.nonNull(masterLevel)) {
                this.request.setAttribute("defaultLevel", (Object)masterLevel);
            }
        }
        return new ModelAndView("psg/person/editPsgPerson");
    }

    @RequiresPermissions(value={"psg:person:edit"})
    public ZKResultMsg save(PsgPersonItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.psgPersonService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg saveParamSet(PsgPersonItem item, String ids) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            for (String id : ids.split(",")) {
                item.setPersonId(id);
                item.setDisabled(Boolean.valueOf(item.getDisabled() == null ? false : item.getDisabled()));
                this.psgPersonService.saveParamSet(item);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:person:refresh"})
    public DxGrid list(PsgPersonItem codition) {
        Pager pager = this.psgPersonService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"psg:person:del"})
    public ZKResultMsg del(String ids) {
        this.psgPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid getLevelPerson(PsgLevelPersonItem condition) {
        Pager pager = this.psgPersonService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        List itemList = pager.getData();
        Map itemMap = this.psgPersonService.getPersonItemMap((Collection)itemList);
        itemList.stream().forEach(item -> {
            item.setPersonPin(((PsgSelectPersonItem)itemMap.get(item.getId())).getPersonPin());
            item.setPersonName(((PsgSelectPersonItem)itemMap.get(item.getId())).getPersonName());
            item.setPersonLastName(((PsgSelectPersonItem)itemMap.get(item.getId())).getPersonLastName());
            item.setDeptName(((PsgSelectPersonItem)itemMap.get(item.getId())).getDeptName());
            item.setCardNo(((PsgSelectPersonItem)itemMap.get(item.getId())).getCardNo());
        });
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectPersonlist(PsgSelectPersonItem codition) {
        Pager pager = new Pager();
        if (codition.getType().equals("noSelected")) {
            pager = this.psgPersonService.getNoExistPerson(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        } else if (codition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ZKResultMsg getPersonCountByDept(String deptIds) {
        long personCount = this.psgPersonService.getPersonCountByDept(deptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)personCount));
    }

    public ModelAndView filterPersonByVaildCard(String cardNo) {
        Map filterPersonMap = this.psgPersonService.filterPersonByVaildCard(cardNo);
        if ("true".equals(filterPersonMap.get("cardNoExist"))) {
            this.request.setAttribute("personPin", filterPersonMap.get("personPin"));
            return new ModelAndView("psg/rtMonitor/opPsgSetCardNoToPerson");
        }
        this.request.setAttribute("cardNo", (Object)cardNo);
        return new ModelAndView("psg/rtMonitor/opPsgSelectNoCardPersonContent");
    }

    public DxGrid getNoCardPerson(PsgSelectPersonRadioItem psgSelectPersonRadioItem) {
        Pager pager = new Pager();
        if (psgSelectPersonRadioItem.getType().equals("noSelected")) {
            pager = this.psgPersonService.getNoCardPerson(this.request.getSession().getId(), psgSelectPersonRadioItem, this.getPageNo(), this.getPageSize());
        } else if (psgSelectPersonRadioItem.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, psgSelectPersonRadioItem.getClass());
    }

    public ZKResultMsg setPersonCard(String personId, String cardNo) {
        this.psgPersonService.setCardNoToPerson(personId, cardNo);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

