/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.psg.remote.PsgPassageRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgPassageService;
import com.zkteco.zkbiosecurity.psg.vo.PsgPassageItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgPassageController
extends ExportController
implements PsgPassageRemote {
    @Autowired
    private PsgPassageService psgPassageService;

    @RequiresPermissions(value={"psg:passage"})
    public ModelAndView index() {
        return new ModelAndView("psg/passage/psgPassage");
    }

    @RequiresPermissions(value={"psg:passage:add", "psg:passage:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.psgPassageService.getItemById(id));
        }
        return new ModelAndView("psg/passage/editPsgPassage");
    }

    @RequiresPermissions(value={"psg:passage:add", "psg:passage:edit"})
    @LogChangeRequest(module="psg_passage", object="psg_passage", opType="psg_passage_add", vo=PsgPassageItem.class, service=PsgPassageService.class)
    public ZKResultMsg save(PsgPassageItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.psgPassageService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:passage:refresh"})
    public DxGrid list(PsgPassageItem condition) {
        Pager pager = this.psgPassageService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"psg:passage:del"})
    @LogRequest(module="psg_passage", object="psg_passage", opType="common_op_del", requestParams={"ids"}, opContent="psg_passage_code")
    public ZKResultMsg delete(String ids) {
        this.psgPassageService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validateName(String name) {
        boolean isExist = this.psgPassageService.validateName(name);
        return String.valueOf(isExist);
    }

    public String validateSortNo(String sortNo, String areaId) {
        boolean isExist = this.psgPassageService.validateSortNo(sortNo, areaId);
        return String.valueOf(isExist);
    }

    public ZKResultMsg getPassageList() {
        return new ZKResultMsg((Object)this.psgPassageService.getPassageList());
    }

    public TreeItem getPassageTree() {
        List items = this.psgPassageService.getPassageTree();
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }

    public String isExistByPassageId(String passageId) {
        boolean isExist = false;
        PsgPassageItem psgPassageItem = this.psgPassageService.getItemById(passageId);
        if (Objects.nonNull(psgPassageItem)) {
            isExist = true;
        }
        return String.valueOf(isExist);
    }
}

