/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.remote.PsgParamRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgParamService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgParamController
extends BaseController
implements PsgParamRemote {
    @Autowired
    private PsgParamService psgParamService;

    @RequiresPermissions(value={"psg:param:refresh"})
    public ModelAndView index() {
        Map psgParams = this.psgParamService.getPsgParams();
        this.request.setAttribute("psgParams", (Object)psgParams);
        return new ModelAndView("psg/param/psgParams");
    }

    @RequiresPermissions(value={"psg:param:edit"})
    @LogRequest(module="psg_module", object="common_leftMenu_paramSet", opType="common_leftMenu_paramSet", opContent="common_leftMenu_paramSet", sysParams={"psg.downNewlog:down_event_hours", "psg.personPhotoMaxHeight", "psg.receiver:mail"})
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        String downNewLogHours = this.request.getParameter("down_event_hours");
        params.put("psg.downNewlog", downNewLogHours);
        StringBuffer StrBuf = new StringBuffer("0 0 ").append(downNewLogHours).append(" * * ?");
        params.put("psg.downNewLogExpression", StrBuf.toString());
        String receiver = this.request.getParameter("mail");
        if (receiver != null) {
            params.put("psg.receiver", receiver.replaceAll(";", ","));
        } else {
            params.put("psg.receiver", "");
        }
        this.psgParamService.saveItem(params);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

