/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.constants.PsgConstants;
import com.zkteco.zkbiosecurity.psg.remote.PsgLinkageRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceOptionService;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import com.zkteco.zkbiosecurity.psg.service.PsgLinkageService;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceEventItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgLinkageBeanItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgLinkageItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgLinkageSelectDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgLinkageController
extends BaseController
implements PsgLinkageRemote {
    Logger logger = LoggerFactory.getLogger(PsgLinkageController.class);
    @Autowired
    private PsgLinkageService psgLinkageService;
    @Autowired
    private PsgDeviceOptionService psgDeviceOptionService;
    @Autowired
    private PsgDeviceService psgDeviceService;

    @RequiresPermissions(value={"psg:linkage"})
    public ModelAndView index() {
        return new ModelAndView("psg/linkage/psgLinkage");
    }

    @RequiresPermissions(value={"psg:linkage:add", "psg:linkage:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PsgLinkageItem psgLinkageItem = this.psgLinkageService.getLinkageParams(id);
            this.request.setAttribute("item", (Object)psgLinkageItem);
        }
        return new ModelAndView("psg/linkage/editPsgLinkage");
    }

    public ModelAndView editPsgLinkageItemByDevId(String devId) {
        PsgDeviceItem deviceItem = this.psgDeviceService.getItemById(devId);
        PsgLinkageItem item = new PsgLinkageItem();
        item.setDeviceAlias(deviceItem.getAlias());
        item.setDeviceId(deviceItem.getId());
        this.request.setAttribute("psgDeviceEdit", (Object)true);
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("psg/linkage/editPsgLinkage");
    }

    @RequiresPermissions(value={"psg:linkage:add", "psg:linkage:edit"})
    @LogRequest(module="psg_module", object="psg_dev_linkage", opType="common_op_edit", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg save(PsgLinkageItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String[] inputsAddr = this.request.getParameter("inputAddr").split(",");
        String outputGate = this.request.getParameter("outputGateAddr");
        String[] outputGateAddr = "".equals(outputGate) ? new String[]{} : outputGate.split(",");
        String[] outputsAddr = new String[outputGateAddr.length];
        System.arraycopy(outputGateAddr, 0, outputsAddr, 0, outputGateAddr.length);
        String[] triggerCondArray = this.request.getParameter("triggerCond").split(",");
        short gateActionType = Short.parseShort(this.request.getParameter("gateActionType"));
        short gateActionTime = Short.parseShort(this.request.getParameter("gateActionTime"));
        String[] mailAddr = this.request.getParameter("mailAddr").replaceAll(";", ",").split(",");
        String popUpVideo = this.request.getParameter("popUpVideo");
        String popUpTime = this.request.getParameter("popUpTime");
        String record = this.request.getParameter("record");
        String recordTime = this.request.getParameter("recordTime");
        String capture = this.request.getParameter("capture");
        String captureTime = this.request.getParameter("captureTime");
        PsgLinkageBeanItem psgLinkageBean = new PsgLinkageBeanItem();
        psgLinkageBean.setInputsAddr(inputsAddr);
        psgLinkageBean.setOutputsAddr(outputsAddr);
        psgLinkageBean.setTriggerCondArray(triggerCondArray);
        psgLinkageBean.setGateActionType(gateActionType);
        psgLinkageBean.setGateActionTime(gateActionTime);
        psgLinkageBean.setMailAddr(mailAddr);
        if (StringUtils.isNotBlank((CharSequence)popUpVideo) && "1".equals(popUpVideo)) {
            psgLinkageBean.setPopUpTime(Integer.valueOf(Integer.parseInt(popUpTime)));
        }
        if (StringUtils.isNotBlank((CharSequence)record) && "2".equals(record)) {
            psgLinkageBean.setRecordTime(Integer.valueOf(Integer.parseInt(recordTime)));
        }
        if (StringUtils.isNotBlank((CharSequence)capture) && "3".equals(capture)) {
            psgLinkageBean.setCapture(capture);
            if (StringUtils.isNotBlank((CharSequence)captureTime)) {
                psgLinkageBean.setCaptureTime(Integer.valueOf(Integer.parseInt(captureTime)));
            } else {
                psgLinkageBean.setCaptureTime(Integer.valueOf(0));
            }
        }
        this.psgLinkageService.saveItem(psgLinkageBean, item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:linkage:refresh"})
    public DxGrid list(PsgLinkageItem condition) {
        Pager pager = this.psgLinkageService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        List psgLinkageItemList = pager.getData();
        psgLinkageItemList.forEach(psgLinkageItem -> {
            List triggerCondList = this.psgLinkageService.getTriggerCondByLinkId(psgLinkageItem.getId());
            StringBuilder triggerStr = new StringBuilder();
            triggerCondList.forEach(triggerCond -> triggerStr.append(I18nUtil.i18nCode((String)triggerCond, (Object[])new Object[0])).append(","));
            psgLinkageItem.setTriggerCond(triggerStr.substring(0, triggerStr.length() - 1));
        });
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"psg:linkage:del"})
    @LogRequest(module="psg_module", object="psg_dev_linkage", opType="common_op_del", requestParams={"names"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg del(String ids) {
        this.psgLinkageService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg checkTriggerOpt() {
        String devId = this.request.getParameter("devId");
        String[] triggerCondArray = this.request.getParameter("triggerOpt").split(",");
        String[] inAddrArray = this.request.getParameter("inAddr").split(",");
        String linkageId = this.request.getParameter("linkageId");
        ZKResultMsg zkResultMsg = this.psgLinkageService.checkTriggerOpt(devId, triggerCondArray, inAddrArray, linkageId);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg checkMailParam() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.psgLinkageService.completeMailInfo());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg isSupportLockGate(String devId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.psgDeviceOptionService.getAccSupportFunListVal(devId, 2));
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public String valid(String name) {
        PsgLinkageItem item = this.psgLinkageService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getLinkTriggerOpt() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String deviceId = this.request.getParameter("devId");
        String psgLinkageId = this.request.getParameter("psgLinkageId");
        Map triggerOptMap = this.psgLinkageService.getLinkTriggerOpt(deviceId, psgLinkageId);
        List eventList = (List)triggerOptMap.get("eventList");
        Map checkEventMap = (Map)triggerOptMap.get("checkEventMap");
        Map checkParentElementMap = (Map)triggerOptMap.get("checkParentElementMap");
        JSONArray triggerOptArray = new JSONArray();
        try {
            JSONArray deviceEvent = new JSONArray();
            JSONArray auxInEvent = new JSONArray();
            JSONArray gateEvent = new JSONArray();
            JSONObject dataJson = null;
            for (PsgDeviceEventItem event : eventList) {
                short eventNo = event.getEventNo();
                if (PsgConstants.LINKAGE_TRIGGER_FILTER.contains(eventNo)) continue;
                dataJson = new JSONObject();
                dataJson.put("id", (Object)event.getEventNo());
                dataJson.put("text", (Object)I18nUtil.i18nCode((String)event.getName(), (Object[])new Object[0]));
                if (checkEventMap.containsKey(eventNo)) {
                    dataJson.put("checked", (Object)1);
                }
                if (PsgConstants.AUXIN_EVENT.contains(eventNo)) {
                    auxInEvent.add((Object)dataJson);
                    continue;
                }
                gateEvent.add((Object)dataJson);
            }
            ArrayList<String> parentElement = new ArrayList<String>();
            parentElement.add(I18nUtil.i18nCode((String)"psg_gate_gateEvent", (Object[])new Object[0]));
            parentElement.add(I18nUtil.i18nCode((String)"common_linkIO_auxInEvent", (Object[])new Object[0]));
            if (deviceEvent.size() > 0) {
                parentElement.add(I18nUtil.i18nCode((String)"common_linkIO_deviceEvent", (Object[])new Object[0]));
            }
            for (int i = 0; i < parentElement.size(); ++i) {
                dataJson = new JSONObject();
                dataJson.put("id", (Object)(i + "_parent"));
                dataJson.put("text", parentElement.get(i));
                dataJson.put("open", (Object)"1");
                if (checkParentElementMap.containsKey(i)) {
                    dataJson.put("checked", (Object)"-1");
                }
                dataJson.put("item", (Object)(i == 0 ? gateEvent : (i == 1 ? auxInEvent : deviceEvent)));
                triggerOptArray.add((Object)dataJson);
            }
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        zkResultMsg.setData((Object)triggerOptArray);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg getInOutInfo() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String devId = this.request.getParameter("devId");
        String psgLinkageId = this.request.getParameter("psgLinkageId");
        String[] triggerOpt = this.request.getParameter("triggerOpt").split(",");
        Map map = this.psgLinkageService.getInOutInfo(devId, triggerOpt, psgLinkageId);
        Map checkedOutputMap = (Map)map.get("checkedOutputMap");
        JSONArray gateOutputArray = (JSONArray)map.get("gateOutputArray");
        String devSn = (String)map.get("devSn");
        JSONArray inputArray = (JSONArray)map.get("inputArray");
        JSONObject actionObj = new JSONObject();
        actionObj.put("inputArray", (Object)inputArray);
        JSONArray outputArray = new JSONArray();
        if (!this.psgDeviceOptionService.isSupportFun(devSn, "~CtlAllRelayFunOn")) {
            outputArray = this.buildOutputArray(checkedOutputMap, gateOutputArray);
            actionObj.put("gateOutputArray", outputArray.get(0));
            actionObj.put("ctlAllRelayFunOn", (Object)true);
        } else {
            if (gateOutputArray.size() > 0) {
                actionObj.put("gateOutputArray", (Object)gateOutputArray);
            }
            actionObj.put("ctlAllRelayFunOn", (Object)false);
        }
        zkResultMsg.setData((Object)actionObj);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public DxGrid selectDevicelist(PsgLinkageSelectDeviceItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            condition.setSelectDeviceIdsNotIn(condition.getSelectId());
        } else if (condition.getType().equals("selected")) {
            condition.setSelectDeviceIdsIn(condition.getSelectId());
        }
        String authAreaIds = this.psgDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            condition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.psgDeviceService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg convertTriggerCond(String value) {
        List triggerCondList = this.psgLinkageService.getTriggerCondByLinkId(value);
        StringBuilder triggerStr = new StringBuilder();
        triggerCondList.stream().forEach(triggerCond -> triggerStr.append(triggerCond + ","));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)triggerStr.toString().substring(0, triggerStr.length() - 1)));
    }

    private JSONArray buildOutputArray(Map<String, Map<Integer, String>> checkedOutputMap, JSONArray gateOutputArray) {
        JSONArray outputArray = new JSONArray();
        try {
            JSONObject dataJson = new JSONObject();
            if (gateOutputArray.size() > 0) {
                dataJson.put("id", (Object)"0_PsgGate");
                dataJson.put("text", (Object)I18nUtil.i18nCode((String)"psg_gate_allGate", (Object[])new Object[0]));
                dataJson.put("open", (Object)"1");
                if (checkedOutputMap != null && checkedOutputMap.containsKey("PsgGate") && checkedOutputMap.get("PsgGate").containsKey("0")) {
                    dataJson.put("checked", (Object)"1");
                }
                dataJson.put("item", (Object)gateOutputArray);
                outputArray.add((Object)dataJson);
            } else {
                outputArray.add((Object)"");
            }
        }
        catch (Exception e) {
            this.logger.error("buildOutputArray", (Throwable)e);
            throw new RuntimeException(e);
        }
        return outputArray;
    }

    public ZKResultMsg getPsgLinkageCountByDevId(String devId) {
        Long count = this.psgLinkageService.getPsgLinkageCountByDevId(devId);
        return new ZKResultMsg((Object)count);
    }
}

