/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.remote.PsgGatePassRuleRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgGatePassRuleService;
import com.zkteco.zkbiosecurity.psg.vo.PsgGatePassRuleItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgGatePassRuleController
extends BaseController
implements PsgGatePassRuleRemote {
    private final long maxGatePassRuleCount = 255L;
    @Autowired
    private PsgGatePassRuleService psgGatePassRuleService;

    @RequiresPermissions(value={"psg:gatePassRule"})
    public ModelAndView index() {
        return new ModelAndView("psg/gatePassRule/psgGatePassRule");
    }

    @RequiresPermissions(value={"psg:gatePassRule:add", "psg:gatePassRule:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("tempPsgGatePassRule", (Object)this.psgGatePassRuleService.getItemById(id));
        }
        return new ModelAndView("psg/gatePassRule/editPsgGatePassRule");
    }

    @RequiresPermissions(value={"psg:gatePassRule:add", "psg:gatePassRule:edit"})
    @LogChangeRequest(module="psg_module", object="psg_leftMenu_gatePassRules", opType="common_op_edit", vo=PsgGatePassRuleItem.class, service=PsgGatePassRuleService.class)
    public ZKResultMsg save(PsgGatePassRuleItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.psgGatePassRuleService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:gatePassRule:refresh"})
    public DxGrid list(PsgGatePassRuleItem codition) {
        Pager pager = this.psgGatePassRuleService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"psg:gatePassRule:del"})
    @LogRequest(module="psg_module", object="psg_leftMenu_gatePassRules", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg del(String ids) {
        this.psgGatePassRuleService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validName(String name) {
        return this.psgGatePassRuleService.validName(name);
    }

    public ZKResultMsg getTimeSegList() {
        return new ZKResultMsg((Object)this.psgGatePassRuleService.getGatePassRuleList());
    }

    public ZKResultMsg dataValid(PsgGatePassRuleItem psgGatePassRuleItem) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String result = "true";
        String checkResult = this.checkGatePassRule(psgGatePassRuleItem.getMondayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_mondayStart1", (Object[])new Object[0]), psgGatePassRuleItem.getMondayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_mondayEnd1", (Object[])new Object[0]), psgGatePassRuleItem.getMondayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_mondayStart2", (Object[])new Object[0]), psgGatePassRuleItem.getMondayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_mondayEnd2", (Object[])new Object[0]), psgGatePassRuleItem.getMondayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_mondayStart3", (Object[])new Object[0]), psgGatePassRuleItem.getMondayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_mondayEnd3", (Object[])new Object[0]), psgGatePassRuleItem.getMondayStart4(), I18nUtil.i18nCode((String)"common_timeSeg_mondayStart4", (Object[])new Object[0]), psgGatePassRuleItem.getMondayEnd4(), I18nUtil.i18nCode((String)"common_timeSeg_mondayEnd4", (Object[])new Object[0]), psgGatePassRuleItem.getMondayStart5(), I18nUtil.i18nCode((String)"common_timeSeg_mondayStart5", (Object[])new Object[0]), psgGatePassRuleItem.getMondayEnd5(), I18nUtil.i18nCode((String)"common_timeSeg_mondayEnd5", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkGatePassRule(psgGatePassRuleItem.getTuesdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayStart1", (Object[])new Object[0]), psgGatePassRuleItem.getTuesdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayEnd1", (Object[])new Object[0]), psgGatePassRuleItem.getTuesdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayStart2", (Object[])new Object[0]), psgGatePassRuleItem.getTuesdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayEnd2", (Object[])new Object[0]), psgGatePassRuleItem.getTuesdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayStart3", (Object[])new Object[0]), psgGatePassRuleItem.getTuesdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayEnd3", (Object[])new Object[0]), psgGatePassRuleItem.getTuesdayStart4(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayStart4", (Object[])new Object[0]), psgGatePassRuleItem.getTuesdayEnd4(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayEnd4", (Object[])new Object[0]), psgGatePassRuleItem.getTuesdayStart5(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayStart5", (Object[])new Object[0]), psgGatePassRuleItem.getTuesdayEnd5(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayEnd5", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkGatePassRule(psgGatePassRuleItem.getWednesdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayStart1", (Object[])new Object[0]), psgGatePassRuleItem.getWednesdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayEnd1", (Object[])new Object[0]), psgGatePassRuleItem.getWednesdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayStart2", (Object[])new Object[0]), psgGatePassRuleItem.getWednesdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayEnd2", (Object[])new Object[0]), psgGatePassRuleItem.getWednesdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayStart3", (Object[])new Object[0]), psgGatePassRuleItem.getWednesdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayEnd3", (Object[])new Object[0]), psgGatePassRuleItem.getWednesdayStart4(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayStart4", (Object[])new Object[0]), psgGatePassRuleItem.getWednesdayEnd4(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayEnd4", (Object[])new Object[0]), psgGatePassRuleItem.getWednesdayStart5(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayStart5", (Object[])new Object[0]), psgGatePassRuleItem.getWednesdayEnd5(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayEnd5", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkGatePassRule(psgGatePassRuleItem.getThursdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayStart1", (Object[])new Object[0]), psgGatePassRuleItem.getThursdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayEnd1", (Object[])new Object[0]), psgGatePassRuleItem.getThursdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayStart2", (Object[])new Object[0]), psgGatePassRuleItem.getThursdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayEnd2", (Object[])new Object[0]), psgGatePassRuleItem.getThursdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayStart3", (Object[])new Object[0]), psgGatePassRuleItem.getThursdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayEnd3", (Object[])new Object[0]), psgGatePassRuleItem.getThursdayStart4(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayStart4", (Object[])new Object[0]), psgGatePassRuleItem.getThursdayEnd4(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayEnd4", (Object[])new Object[0]), psgGatePassRuleItem.getThursdayStart5(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayStart5", (Object[])new Object[0]), psgGatePassRuleItem.getThursdayEnd5(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayEnd5", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkGatePassRule(psgGatePassRuleItem.getFridayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_fridayStart1", (Object[])new Object[0]), psgGatePassRuleItem.getFridayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_fridayEnd1", (Object[])new Object[0]), psgGatePassRuleItem.getFridayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_fridayStart2", (Object[])new Object[0]), psgGatePassRuleItem.getFridayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_fridayEnd2", (Object[])new Object[0]), psgGatePassRuleItem.getFridayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_fridayStart3", (Object[])new Object[0]), psgGatePassRuleItem.getFridayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_fridayEnd3", (Object[])new Object[0]), psgGatePassRuleItem.getFridayStart4(), I18nUtil.i18nCode((String)"common_timeSeg_fridayStart4", (Object[])new Object[0]), psgGatePassRuleItem.getFridayEnd4(), I18nUtil.i18nCode((String)"common_timeSeg_fridayEnd4", (Object[])new Object[0]), psgGatePassRuleItem.getFridayStart5(), I18nUtil.i18nCode((String)"common_timeSeg_fridayStart5", (Object[])new Object[0]), psgGatePassRuleItem.getFridayEnd5(), I18nUtil.i18nCode((String)"common_timeSeg_fridayEnd5", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkGatePassRule(psgGatePassRuleItem.getSaturdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayStart1", (Object[])new Object[0]), psgGatePassRuleItem.getSaturdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayEnd1", (Object[])new Object[0]), psgGatePassRuleItem.getSaturdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayStart2", (Object[])new Object[0]), psgGatePassRuleItem.getSaturdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayEnd2", (Object[])new Object[0]), psgGatePassRuleItem.getSaturdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayStart3", (Object[])new Object[0]), psgGatePassRuleItem.getSaturdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayEnd3", (Object[])new Object[0]), psgGatePassRuleItem.getSaturdayStart4(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayStart4", (Object[])new Object[0]), psgGatePassRuleItem.getSaturdayEnd4(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayEnd4", (Object[])new Object[0]), psgGatePassRuleItem.getSaturdayStart5(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayStart5", (Object[])new Object[0]), psgGatePassRuleItem.getSaturdayEnd5(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayEnd5", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkGatePassRule(psgGatePassRuleItem.getSundayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_sundayStart1", (Object[])new Object[0]), psgGatePassRuleItem.getSundayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_sundayEnd1", (Object[])new Object[0]), psgGatePassRuleItem.getSundayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_sundayStart2", (Object[])new Object[0]), psgGatePassRuleItem.getSundayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_sundayEnd2", (Object[])new Object[0]), psgGatePassRuleItem.getSundayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_sundayStart3", (Object[])new Object[0]), psgGatePassRuleItem.getSundayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_sundayEnd3", (Object[])new Object[0]), psgGatePassRuleItem.getSundayStart4(), I18nUtil.i18nCode((String)"common_timeSeg_sundayStart4", (Object[])new Object[0]), psgGatePassRuleItem.getSundayEnd4(), I18nUtil.i18nCode((String)"common_timeSeg_sundayEnd4", (Object[])new Object[0]), psgGatePassRuleItem.getSundayStart5(), I18nUtil.i18nCode((String)"common_timeSeg_sundayStart5", (Object[])new Object[0]), psgGatePassRuleItem.getSundayEnd5(), I18nUtil.i18nCode((String)"common_timeSeg_sundayEnd5", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        resultMsg.setData((Object)result);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    private String checkGatePassRule(String start1, String start1Vname, String end1, String end1Vname, String start2, String start2Vname, String end2, String end2Vname, String start3, String start3Vname, String end3, String end3Vname, String start4, String start4Vname, String end4, String end4Vname, String start5, String start5Vname, String end5, String end5Vname) {
        String checkResult = this.checkStartEndTime(start1, start1Vname, end1, end1Vname);
        if (checkResult != null) {
            return checkResult;
        }
        checkResult = this.checkStartEndTime(start2, start2Vname, end2, end2Vname);
        if (checkResult != null) {
            return checkResult;
        }
        checkResult = this.checkStartEndTime(start3, start3Vname, end3, end3Vname);
        if (checkResult != null) {
            return checkResult;
        }
        checkResult = this.checkStartEndTime(start4, start4Vname, end4, end4Vname);
        if (checkResult != null) {
            return checkResult;
        }
        checkResult = this.checkStartEndTime(start5, start5Vname, end5, end5Vname);
        if (checkResult != null) {
            return checkResult;
        }
        if (start1.equals("00:00") && end1.equals("00:00")) {
            if (!start2.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{start2Vname});
            }
            if (!end2.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{end2Vname});
            }
            if (!start3.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{start3Vname});
            }
            if (!end3.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{end3Vname});
            }
            if (!start4.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{start4Vname});
            }
            if (!end4.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{end4Vname});
            }
            if (!start5.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{start5Vname});
            }
            if (!end5.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{end5Vname});
            }
        } else if (start2.equals("00:00") && end2.equals("00:00")) {
            if (!start3.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{start3Vname});
            }
            if (!end3.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{end3Vname});
            }
            if (!start4.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{start4Vname});
            }
            if (!end4.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{end4Vname});
            }
            if (!start5.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{start5Vname});
            }
            if (!end5.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{end5Vname});
            }
        } else if (start3.equals("00:00") && end3.equals("00:00")) {
            if (!start4.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{start4Vname});
            }
            if (!end4.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{end4Vname});
            }
            if (!start5.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{start5Vname});
            }
            if (!end5.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{end5Vname});
            }
            if (DateUtil.stringToDate((String)start2, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime() <= DateUtil.stringToDate((String)end1, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime()) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError3", (Object[])new Object[]{start2Vname, end1Vname});
            }
        } else if (start4.equals("00:00") && end4.equals("00:00")) {
            if (!start5.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{start5Vname});
            }
            if (!end5.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{end5Vname});
            }
            if (DateUtil.stringToDate((String)start3, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime() <= DateUtil.stringToDate((String)end2, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime()) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError3", (Object[])new Object[]{start3Vname, end2Vname});
            }
        } else {
            if (DateUtil.stringToDate((String)start2, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime() <= DateUtil.stringToDate((String)end1, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime()) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError3", (Object[])new Object[]{start2Vname, end1Vname});
            }
            if (DateUtil.stringToDate((String)start3, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime() <= DateUtil.stringToDate((String)end2, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime()) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError3", (Object[])new Object[]{start3Vname, end2Vname});
            }
            if (DateUtil.stringToDate((String)start4, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime() <= DateUtil.stringToDate((String)end3, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime()) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError3", (Object[])new Object[]{start4Vname, end3Vname});
            }
            if (!end5.equals("00:00") && DateUtil.stringToDate((String)start5, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime() <= DateUtil.stringToDate((String)end4, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime()) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError3", (Object[])new Object[]{start5Vname, end4Vname});
            }
        }
        return null;
    }

    private String checkStartEndTime(String startTime, String startVname, String endTime, String endVname) {
        Date startDate = DateUtil.stringToDate((String)startTime, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM);
        Date endDate = DateUtil.stringToDate((String)endTime, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM);
        if (startDate.getTime() > endDate.getTime()) {
            return I18nUtil.i18nCode((String)"common_timeSeg_fillError4", (Object[])new Object[]{startVname, endVname});
        }
        if (startDate.getTime() == endDate.getTime() && !startTime.equals("00:00")) {
            return I18nUtil.i18nCode((String)"common_timeSeg_fillError5", (Object[])new Object[]{startVname, endVname});
        }
        return null;
    }
}

