/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogChangeRequest;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.remote.PsgGateRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgBaseDictionaryService;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import com.zkteco.zkbiosecurity.psg.service.PsgGateService;
import com.zkteco.zkbiosecurity.psg.service.PsgRTMonitorService;
import com.zkteco.zkbiosecurity.psg.vo.PsgGateItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgGateController
extends BaseController
implements PsgGateRemote {
    @Autowired
    private PsgGateService psgGateService;
    @Autowired
    private PsgRTMonitorService psgRTMonitorService;
    @Autowired
    private PsgDeviceService psgDeviceService;
    @Autowired
    private PsgBaseDictionaryService psgBaseDictionaryService;

    @RequiresPermissions(value={"psg:gate"})
    public ModelAndView index() {
        return new ModelAndView("psg/gate/psgGate");
    }

    @RequiresPermissions(value={"psg:gate:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PsgGateItem item = this.psgGateService.getItemById(id);
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("editPage", (Object)true);
        }
        return new ModelAndView("psg/gate/editPsgGate");
    }

    public ModelAndView editPsgGateItemByDevId(String devId) {
        PsgGateItem item = this.psgGateService.getItemByDevId(devId);
        if (Objects.nonNull(item)) {
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("editPage", (Object)true);
        }
        return new ModelAndView("psg/gate/editPsgGate");
    }

    @RequiresPermissions(value={"psg:gate:edit"})
    @LogChangeRequest(module="psg_passage", object="psg_leftMenu_gate", opType="common_op_edit", vo=PsgGateItem.class, service=PsgGateService.class)
    public ZKResultMsg save(PsgGateItem item, String applyTo) {
        ZKResultMsg res = new ZKResultMsg();
        this.psgGateService.saveItem(item, applyTo);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(PsgGateItem condition) {
        Pager pager = this.psgGateService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"psg:gate:openInGate", "psg:gate:openOutGate", "psg:gate:closeGate", "psg:gate:cancelAlarm", "psg:gate:normalOpenGate", "psg:gate:lockGate", "psg:gate:unLockGate", "psg:gate:enableNormalOpenGate", "psg:gate:disableNormalOpenGate"})
    public ModelAndView getGateIds(String ids) {
        String[] idArr = ids.split(",");
        String type = this.request.getParameter("type");
        Map retMap = this.psgGateService.getGateIds(idArr, type);
        this.request.setAttribute("retIds", retMap.get("retIds"));
        this.request.setAttribute("gatesName", retMap.get("gatesName"));
        this.request.setAttribute("disabledGatesName", retMap.get("disabledGatesName"));
        this.request.setAttribute("offlineGatesName", retMap.get("offlineGatesName"));
        this.request.setAttribute("notSupportGatesName", retMap.get("notSupportGatesName"));
        this.request.setAttribute("type", (Object)type);
        return new ModelAndView("psg/gate/opPsgGate");
    }

    public boolean isExist(String name) {
        return this.psgGateService.isExist(name);
    }

    public boolean checkPwd(String forcePwd) {
        return this.psgGateService.checkPwd(forcePwd);
    }

    public ZKResultMsg getPsgDeviceOpt(String deviceId) {
        ZKResultMsg res = new ZKResultMsg();
        Map devOptMap = this.psgGateService.getPsgDeviceOpt(deviceId);
        res.setData((Object)devOptMap);
        return res;
    }

    public ZKResultMsg getVerifyMode(String deviceId) {
        List selectItemList = this.psgGateService.getVerifyMode(deviceId);
        return new ZKResultMsg((Object)selectItemList);
    }

    @RequiresPermissions(value={"psg:rtMonitor:openInGate"})
    @LogRequest(module="psg_module", object="psg_leftMenu_gate", opType="psg_gate_remoteOpenIn", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg openInGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("openInGate", ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"psg:rtMonitor:openOutGate"})
    @LogRequest(module="psg_module", object="psg_leftMenu_gate", opType="psg_gate_remoteOpenOut", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg openOutGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("openOutGate", ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"psg:gate:cancelAlarm"})
    @LogRequest(module="psg_module", object="psg_leftMenu_gate", opType="psg_eventNo_7", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg cancelAlarm(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("cancelAlarm", ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"psg:gate:lockGate"})
    @LogRequest(module="psg_module", object="psg_leftMenu_gate", opType="psg_newEventNo_233", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg lockGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("lockGate", ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"psg:gate:unLockGate"})
    @LogRequest(module="psg_module", object="psg_leftMenu_gate", opType="psg_newEventNo_234", requestParams={"name"}, opContent="psg_gate_name")
    public ZKResultMsg unLockGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("unLockGate", ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="psg_module", object="psg_leftMenu_gate", opType="psg_rtMonitor_remoteNormalOpen", requestParams={"name"}, opContent="psg_gate_name")
    @RequiresPermissions(value={"psg:gate:normalOpenGate"})
    public ZKResultMsg normalOpenGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("normalOpenGate", ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="psg_module", object="psg_leftMenu_gate", opType="psg_eventNo_11", requestParams={"name"}, opContent="psg_gate_name")
    @RequiresPermissions(value={"psg:gate:enableNormalOpenGate"})
    public ZKResultMsg enableNormalOpenGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("enableNormalOpenGate", ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="psg_module", object="psg_leftMenu_gate", opType="psg_eventNo_10", requestParams={"name"}, opContent="psg_gate_name")
    @RequiresPermissions(value={"psg:gate:disableNormalOpenGate"})
    public ZKResultMsg disableNormalOpenGate(String ids) {
        Map dataMap = this.psgRTMonitorService.operateGate("disableNormalOpenGate", ids);
        return this.dealResultData(dataMap);
    }

    private ZKResultMsg dealResultData(Map<String, String> dataMap) {
        String cmdIdData = dataMap.get("cmdId");
        String msg = "";
        ZKResultMsg resultMsg = new ZKResultMsg();
        if ("true".equals(dataMap.get("notExistDev"))) {
            msg = I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]);
            resultMsg.setMsg(msg);
            return resultMsg;
        }
        if (!"".equals(cmdIdData)) {
            for (String cmdData : cmdIdData.split(",")) {
                String cmdId = cmdData.split("=")[0];
                String doorName = cmdData.split("=")[1];
                Map resultMap = this.psgDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (Objects.isNull(resultMap)) {
                    msg = msg + doorName + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                    continue;
                }
                Integer ret = Integer.valueOf((String)resultMap.get("result"));
                if (Objects.isNull(ret)) {
                    msg = msg + doorName + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                    continue;
                }
                if (ret >= 0) continue;
                String failedInfo = I18nUtil.i18nCode((String)this.psgBaseDictionaryService.getCommReason(ret.intValue()), (Object[])new Object[0]);
                msg = msg + doorName + "," + I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + failedInfo + ";";
            }
        }
        if (!"".equals(dataMap.get("offline"))) {
            for (String gateName : dataMap.get("offline").split(",")) {
                msg = msg + gateName + "," + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + ";";
            }
        }
        if (!"".equals(dataMap.get("notSupport"))) {
            for (String gateName : dataMap.get("notSupport").split(",")) {
                msg = msg + gateName + "," + I18nUtil.i18nCode((String)"psg_dev_devNotSupportFunction", (Object[])new Object[0]) + ";";
            }
        }
        if (!"".equals(msg)) {
            resultMsg.setRet("400");
            resultMsg.setMsg(msg);
        }
        resultMsg.setData((Object)"");
        return resultMsg;
    }
}

