/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceMonitorService;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;

@Controller
public class PsgDeviceMonitorWSController
extends BaseController {
    @Autowired
    private PsgDeviceMonitorService psgDeviceMonitorService;
    @Autowired
    private PsgDeviceService psgDeviceService;

    @MessageMapping(value={"/psgDeviceMonitor/getDeviceEvents"})
    @SendTo(value={"/topic/psgDeviceMonitor/getDeviceEvents"})
    public JSONObject getDeviceEvents(String _params) {
        JSONObject params = JSONObject.parseObject((String)_params);
        JSONObject dxGrid = new JSONObject();
        String areaIds = params.containsKey((Object)"areaId") ? params.getString("areaId") : "";
        dxGrid.put("pos", (Object)0);
        ArrayList rows = new ArrayList();
        List psgDeviceMonitorItems = this.psgDeviceMonitorService.getDeviceMonitor(areaIds);
        psgDeviceMonitorItems.stream().forEach(item -> {
            JSONObject row = new JSONObject();
            String status = this.psgDeviceService.getStatus(item.getDevSn());
            row.put("id", (Object)item.getId());
            JSONObject userData = new JSONObject();
            userData.put("areaId", (Object)item.getAreaId());
            userData.put("status", (Object)item.getDevStatus());
            row.put("userdata", (Object)userData);
            if (status.equals(String.valueOf(1))) {
                row.put("style", (Object)"color:green");
                row.put("dataLevel", (Object)0);
            } else if (status.equals(String.valueOf(2))) {
                row.put("style", (Object)"color:#E57A14");
                row.put("dataLevel", (Object)1);
            } else {
                row.put("style", (Object)"color:red");
                row.put("dataLevel", (Object)2);
            }
            JSONArray data = new JSONArray();
            data.add((Object)item.getDevName());
            data.add((Object)item.getDevSn());
            data.add((Object)item.getAreaName());
            data.add((Object)item.getOpState());
            data.add((Object)item.getCurState());
            data.add((Object)item.getCmdCount());
            data.add((Object)(item.getLastError().equals("") ? I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]) : item.getLastError()));
            data.add((Object)"0,1");
            row.put("data", (Object)data);
            rows.add(row);
        });
        dxGrid.put("rows", rows);
        dxGrid.put("clientId", params.get((Object)"clientId"));
        dxGrid.put("total_count", (Object)rows.size());
        return dxGrid;
    }
}

