/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.remote.PsgAntiPassbackRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgAntiPassbackService;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import com.zkteco.zkbiosecurity.psg.vo.PsgAntiPassbackItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgAntiPassbackSelectDeviceItem;
import com.zkteco.zkbiosecurity.psg.vo.PsgDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgAntiPassbackController
extends BaseController
implements PsgAntiPassbackRemote {
    @Autowired
    private PsgAntiPassbackService psgAntiPassbackService;
    @Autowired
    private PsgDeviceService psgDeviceService;

    @RequiresPermissions(value={"psg:antiPassback"})
    public ModelAndView index() {
        return new ModelAndView("psg/antiPassback/psgAntiPassback");
    }

    @RequiresPermissions(value={"psg:antiPassback:add", "psg:antiPassback:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.psgAntiPassbackService.getItemById(id));
        }
        return new ModelAndView("psg/antiPassback/editPsgAntiPassback");
    }

    public ModelAndView editAntiPassbackItemByDevId(String devId) {
        PsgAntiPassbackItem item = this.psgAntiPassbackService.getItemByDevId(devId);
        if (Objects.nonNull(item)) {
            this.request.setAttribute("item", (Object)item);
        } else {
            PsgDeviceItem devItem = this.psgDeviceService.getItemById(devId);
            item = new PsgAntiPassbackItem();
            item.setDeviceId(devItem.getId());
            item.setDeviceName(devItem.getAlias());
            this.request.setAttribute("psgDeviceEdit", (Object)true);
            this.request.setAttribute("item", (Object)item);
        }
        return new ModelAndView("psg/antiPassback/editPsgAntiPassback");
    }

    @RequiresPermissions(value={"psg:antiPassback:add", "psg:antiPassback:edit"})
    @LogRequest(module="psg_module", object="psg_eventNo_24", opType="common_op_edit", requestParams={"deviceName"}, opContent="common_dev_name")
    public ZKResultMsg save(PsgAntiPassbackItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.psgAntiPassbackService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:antiPassback:refresh"})
    public DxGrid list(PsgAntiPassbackItem codition) {
        Pager pager = this.psgAntiPassbackService.loadPagerByAuthFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        List psgAntiPassbackItemList = pager.getData();
        psgAntiPassbackItemList.forEach(psgAntiPassbackItem -> psgAntiPassbackItem.setApbRuleShow(this.psgAntiPassbackService.convertAntiPassbackRule(psgAntiPassbackItem.getId())));
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"psg:antiPassback:del"})
    @LogRequest(module="psg_module", object="psg_eventNo_24", opType="common_op_del", requestParams={"deviceNames"}, opContent="common_dev_name")
    public ZKResultMsg del(String ids) {
        this.psgAntiPassbackService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getRule(String deviceId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        Map map = this.psgAntiPassbackService.getApbRule(deviceId);
        Map doorMap = (Map)map.get("gateMap");
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        if (doorMap != null && doorMap.size() > 0) {
            String rule = String.format(I18nUtil.i18nCode((String)"psg_apb_controlOut", (Object[])new Object[0]), doorMap.get(1));
            selectItemList.add(this.getJsonObj("1", rule));
            rule = String.format(I18nUtil.i18nCode((String)"psg_apb_controlIn", (Object[])new Object[0]), doorMap.get(1));
            selectItemList.add(this.getJsonObj("2", rule));
            rule = String.format(I18nUtil.i18nCode((String)"psg_apb_controlInOut", (Object[])new Object[0]), doorMap.get(1));
            selectItemList.add(this.getJsonObj("3", rule));
        }
        zkResultMsg.setData(selectItemList);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"psg:device:refresh"})
    public DxGrid selectDevicelist(PsgAntiPassbackSelectDeviceItem codition) {
        String filterDevId = this.psgAntiPassbackService.getDevIdWithApb();
        if (StringUtils.isBlank((CharSequence)codition.getSelectId())) {
            codition.setSelectId("-1");
        }
        if (codition.getType().equals("noSelected")) {
            if (StringUtils.isNotBlank((CharSequence)filterDevId)) {
                filterDevId = codition.getSelectId() + "," + filterDevId;
                codition.setSelectId(filterDevId);
            }
            codition.setSelectDeviceIdsNotIn(codition.getSelectId());
        } else if (codition.getType().equals("selected")) {
            codition.setSelectDeviceIdsIn(codition.getSelectId());
        }
        String authAreaIds = this.psgDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            codition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.psgDeviceService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    private SelectItem getJsonObj(String val, String name) {
        SelectItem selectItem = new SelectItem();
        selectItem.setValue(val);
        selectItem.setText((Object)name);
        return selectItem;
    }

    public ZKResultMsg getPsgAntiPassbackCountByDevId(String devId) {
        Long count = this.psgAntiPassbackService.getPsgAntiPassbackCountByDevId(devId);
        return new ZKResultMsg((Object)count);
    }
}

