/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.psg.remote.PsgAlarmTransactionRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgTransactionService;
import com.zkteco.zkbiosecurity.psg.vo.PsgAlarmTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgAlarmTransactionController
extends ExportController
implements PsgAlarmTransactionRemote {
    @Autowired
    private PsgTransactionService psgTransactionService;

    @RequiresPermissions(value={"psg:alarmTransaction"})
    public ModelAndView index() {
        return new ModelAndView("psg/alarmTransaction/psgAlarmTransaction");
    }

    @RequiresPermissions(value={"psg:alarmTransaction:refresh"})
    public DxGrid list(PsgAlarmTransactionItem condition) {
        Pager pager = this.psgTransactionService.loadAlarmTransactionByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"psg:alarmTransaction:del"})
    public ZKResultMsg del(String ids) {
        this.psgTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:alarmTransaction:del"})
    @LogRequest(module="psg_module", object="common_leftMenu_exceptTransaction", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.psgTransactionService.deleteAllExceptionData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:alarmTransaction:export"})
    @LogRequest(module="psg_module", object="common_leftMenu_exceptTransaction", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PsgAlarmTransactionItem psgAlarmTransactionItem = new PsgAlarmTransactionItem();
        this.setConditionValue((BaseItem)psgAlarmTransactionItem);
        String deptCodes = this.psgTransactionService.getDeptCodesByAuthFilter(request.getSession().getId());
        psgAlarmTransactionItem.setDeptCodeIn(deptCodes);
        List intemList = this.psgTransactionService.getItemData(PsgAlarmTransactionItem.class, (BaseItem)psgAlarmTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, PsgAlarmTransactionItem.class);
    }
}

