/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.api.controller;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.service.PsgTransactionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/psgTransaction"})
@Api(tags={"PsgTransaction"}, description="psg transaction")
public class PsgApiV2TransactionController {
    @Autowired
    private PsgTransactionService psgTransactionService;

    @ApiOperation(value="Get Transaction List By Sn", notes="Return Transactions", response=ApiResultMessage.class)
    @RequestMapping(value={"/device/{deviceSn}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getTransactionsByDeviceSn(@PathVariable(name="deviceSn") String deviceSn, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        if (StringUtils.isBlank((CharSequence)deviceSn)) {
            return ApiResultMessage.message((int)-48, (String)I18nUtil.i18nCode((String)"common_api_devSnNotNull", (Object[])new Object[0]));
        }
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
        }
        Pager pager = this.psgTransactionService.getApiTransactionsBySnAndPage(deviceSn, startTime, endTime, pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)pager);
    }

    @ApiOperation(value="Get Transaction List By Pin", notes="Return Transactions", response=ApiResultMessage.class)
    @RequestMapping(value={"/person/{pin}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getTransactionsByPin(@PathVariable(name="pin") String pin, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        if (StringUtils.isBlank((CharSequence)pin)) {
            return ApiResultMessage.message((int)-20, (String)I18nUtil.i18nCode((String)"pers_import_pinNotEmpty", (Object[])new Object[0]));
        }
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
        }
        Pager pager = this.psgTransactionService.getApiTransactionsByPinAndPage(pin, startTime, endTime, pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)pager);
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Transactions List", notes="Return Transactions List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="personPin", required=false) String personPin, @RequestParam(name="startDate", required=false) String startDate, @RequestParam(name="endDate", required=false) String endDate, @RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage apiResultMessage = this.checkParam(startDate, endDate, pageNo, pageSize);
        if (apiResultMessage != null) {
            return apiResultMessage;
        }
        Date startTime = null;
        Date endTime = null;
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
        }
        Pager pager = this.psgTransactionService.getApiTransactionsByPage(personPin, startTime, endTime, pageNo, pageSize);
        return ApiResultMessage.successMessage((Object)pager);
    }

    private ApiResultMessage checkParam(String startDate, String endDate, Integer pageNo, Integer pageSize) {
        Date startTime = null;
        Date endTime = null;
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startTime = DateUtil.stringToDate((String)startDate);
            endTime = DateUtil.stringToDate((String)endDate);
            if (startTime == null || endTime == null) {
                return ApiResultMessage.message((int)-100, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid2", (Object[])new Object[0]));
            }
            if (startTime.getTime() > endTime.getTime()) {
                return ApiResultMessage.message((int)-101, (String)I18nUtil.i18nCode((String)"common_dsTime_timeValid4", (Object[])new Object[0]));
            }
        }
        return null;
    }
}

