/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.api.controller;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.psg.service.PsgLevelService;
import com.zkteco.zkbiosecurity.psg.vo.PsgLevelItem;
import com.zkteco.zkbiosecurity.psg.vo.api.vo.PsgApiLevelItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/psgLevel"})
@Api(tags={"psgLevel"}, description="psg level")
public class PsgApiV2LevelController {
    private static final Logger log = LoggerFactory.getLogger(PsgApiV2LevelController.class);
    @Autowired
    private PsgLevelService psgLevelService;

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get PsgLevel List", notes="Return PsgLevel List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="pageNo") Integer pageNo, @RequestParam(name="pageSize") Integer pageSize) {
        ApiResultMessage rs = new ApiResultMessage();
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.failedMessage((int)-90);
        }
        ArrayList apiPsgLevels = new ArrayList();
        Pager pager = this.psgLevelService.getItemsByPage((BaseItem)new PsgLevelItem(), pageNo - 1, pageSize.intValue());
        List psgLevelItemList = pager.getData();
        if (!psgLevelItemList.isEmpty()) {
            psgLevelItemList.forEach(psgLevelItem -> {
                PsgApiLevelItem psgApiLevelItem = PsgApiLevelItem.createApiLevel((PsgLevelItem)psgLevelItem);
                if (psgApiLevelItem != null) {
                    apiPsgLevels.add(psgApiLevelItem);
                }
            });
        }
        pager.setData(apiPsgLevels);
        rs.setData((Object)pager);
        return rs;
    }
}

