/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.api.controller;

import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.service.PsgDeviceService;
import com.zkteco.zkbiosecurity.psg.service.PsgGateService;
import com.zkteco.zkbiosecurity.psg.service.PsgRTMonitorService;
import com.zkteco.zkbiosecurity.psg.vo.PsgGateItem;
import com.zkteco.zkbiosecurity.psg.vo.api.vo.PsgApiGateItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/psgGate"})
@Api(tags={"PsgGate"}, description="psg gate")
public class PsgApiV2GateController {
    private static final Logger log = LoggerFactory.getLogger(PsgApiV2GateController.class);
    @Autowired
    private PsgGateService psgGateService;
    @Autowired
    private PsgRTMonitorService psgRTMonitorService;
    @Autowired
    private PsgDeviceService psgDeviceService;

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Gate List", notes="Return Gate List", response=ApiResultMessage.class)
    public ApiResultMessage list(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize) {
        if (pageNo == null || pageSize == null) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageNotNull", (Object[])new Object[0]));
        }
        if (pageNo <= 0 || pageSize <= 0) {
            return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
        }
        if (pageSize > 1000) {
            return ApiResultMessage.message((int)-91, (String)I18nUtil.i18nCode((String)"common_api_pageSizeOver", (Object[])new Object[0]));
        }
        ArrayList apiGateItemList = new ArrayList();
        Pager pager = this.psgGateService.getItemsByPage((BaseItem)new PsgGateItem(), pageNo - 1, pageSize.intValue());
        List psgGateItemList = pager.getData();
        if (!psgGateItemList.isEmpty()) {
            psgGateItemList.forEach(psgGateItem -> {
                PsgApiGateItem psgApiGateItem = PsgApiGateItem.createApiGate((PsgGateItem)psgGateItem);
                if (psgApiGateItem != null) {
                    apiGateItemList.add(psgApiGateItem);
                }
            });
        }
        pager.setData(apiGateItemList);
        return ApiResultMessage.successMessage((Object)pager);
    }
}

